/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformCachingFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.TransformListStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public interface SvgTransformableFigure
extends TransformCachingFigure {
    public static final boolean CACHE = true;
    public static final @NonNull TransformListStyleableKey TRANSFORMS = TransformableFigure.TRANSFORMS;

    public static @NonNull Set<Key<?>> getDeclaredKeys() {
        LinkedHashSet keys = new LinkedHashSet();
        Figure.getDeclaredKeys(SvgTransformableFigure.class, keys);
        return keys;
    }

    default public void applyTransformableFigureProperties(@NonNull RenderContext ctx, @NonNull Node node) {
        Transform t = this.getLocalToParent();
        ObservableList transforms = node.getTransforms();
        if (t == null || t.isIdentity()) {
            if (!transforms.isEmpty()) {
                transforms.clear();
            }
        } else if (transforms.size() == 1) {
            if (!Objects.equals(transforms.getFirst(), t)) {
                transforms.set(0, t);
            }
        } else {
            transforms.clear();
            transforms.add(t);
        }
    }

    default public void clearTransforms() {
        this.remove((Key)TRANSFORMS);
    }

    default public void flattenTransforms() {
        Transform p2l = this.getLocalToParent(false);
        if (p2l == null || p2l.isIdentity()) {
            this.remove((Key)TRANSFORMS);
        } else {
            this.set((MapAccessor)TRANSFORMS, VectorList.of((Object[])new Transform[]{p2l}));
        }
    }

    default public @Nullable Transform getInverseTransform() {
        Transform t;
        ImmutableList list = (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)TRANSFORMS);
        if (list.isEmpty()) {
            t = null;
        } else {
            try {
                t = ((Transform)list.get(list.size() - 1)).createInverse();
                for (int i = list.size() - 2; i >= 0; --i) {
                    t = FXTransforms.concat((Transform[])new Transform[]{t, ((Transform)list.get(i)).createInverse()});
                }
            }
            catch (NonInvertibleTransformException e) {
                throw new InternalError(e);
            }
        }
        return t;
    }

    default public @NonNull Transform getLocalToParent() {
        return this.getLocalToParent(true);
    }

    default public @NonNull Transform getLocalToParent(boolean styled) {
        Transform l2p;
        Transform transform = l2p = styled ? this.getCachedLocalToParent() : null;
        if (l2p == null) {
            ImmutableList t;
            Point2D center = this.getCenterInLocal();
            ImmutableList immutableList = t = styled ? (ImmutableList)this.getStyled((MapAccessor)TRANSFORMS) : (ImmutableList)this.get((MapAccessor)TRANSFORMS);
            if (t != null && !t.isEmpty()) {
                l2p = FXTransforms.concat((Transform[])new Transform[]{null, this.getTransform()});
            }
            if (l2p == null) {
                l2p = FXTransforms.IDENTITY;
            }
            if (styled) {
                this.setCachedLocalToParent(l2p);
            }
        }
        return l2p;
    }

    default public @NonNull List<Transform> getLocalToParentAsList(boolean styled) {
        ImmutableList t;
        ArrayList<Transform> list = new ArrayList<Transform>();
        Point2D center = this.getCenterInLocal();
        ImmutableList immutableList = t = styled ? (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)TRANSFORMS) : (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
        if (!t.isEmpty()) {
            list.addAll(t.asList());
        }
        return list;
    }

    default public @NonNull Transform getParentToLocal() {
        return this.getParentToLocal(true);
    }

    default public @NonNull Transform getParentToLocal(boolean styled) {
        Transform p2l = this.getCachedParentToLocal();
        if (p2l == null) {
            ImmutableList t;
            Point2D center = this.getCenterInLocal();
            ImmutableList immutableList = t = styled ? (ImmutableList)this.getStyled((MapAccessor)TRANSFORMS) : (ImmutableList)this.get((MapAccessor)TRANSFORMS);
            if (t != null && !t.isEmpty()) {
                p2l = this.getInverseTransform();
            }
            this.setCachedParentToLocal(p2l);
        }
        return p2l;
    }

    default public @Nullable Transform getTransform() {
        Transform t;
        ImmutableList list = (ImmutableList)this.getStyledNonNull((NonNullMapAccessor)TRANSFORMS);
        if (list.isEmpty()) {
            t = null;
        } else {
            t = (Transform)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                t = FXTransforms.concat((Transform[])new Transform[]{t, (Transform)list.get(i)});
            }
        }
        return t;
    }

    default public boolean hasCenterTransforms() {
        return false;
    }

    default public boolean hasTransforms() {
        return !((ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS)).isEmpty();
    }

    default public void reshapeInLocal(Transform transform) {
        if (this.hasCenterTransforms() && !(transform instanceof Translate)) {
            ImmutableList ts = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
            if (ts.isEmpty()) {
                this.set((MapAccessor)TRANSFORMS, ts.add((Object)transform));
            } else {
                int last = ts.size() - 1;
                Transform concatenatedWithLast = FXTransforms.concat((Transform[])new Transform[]{(Transform)ts.get(last), transform});
                if (concatenatedWithLast instanceof Affine) {
                    this.set((MapAccessor)TRANSFORMS, ts.add((Object)transform));
                } else {
                    this.set((MapAccessor)TRANSFORMS, ts.set(last, (Object)concatenatedWithLast));
                }
            }
            return;
        }
        Bounds b = this.getLayoutBounds();
        b = transform.transform(b);
        this.reshapeInLocal(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    default public void reshapeInParent(@NonNull Transform transform) {
        boolean hasCenters = this.hasCenterTransforms();
        boolean hasTransforms = this.hasTransforms();
        if (!hasTransforms && transform instanceof Translate) {
            this.reshapeInLocal(transform);
            return;
        }
        Transform parentToLocal = this.getParentToLocal();
        if (hasCenters || this.hasTransforms()) {
            if (transform instanceof Translate) {
                Translate translate = (Translate)transform;
                if (!hasCenters) {
                    Point2D p = parentToLocal == null ? new Point2D(translate.getTx(), translate.getTy()) : parentToLocal.deltaTransform(translate.getTx(), translate.getTy());
                    this.reshapeInLocal((Transform)new Translate(p.getX(), p.getY()));
                } else {
                    ImmutableList transforms = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
                    Transform lastTransform = (Transform)transforms.get(transforms.size() - 1);
                    if (lastTransform instanceof Translate) {
                        this.set((MapAccessor)TRANSFORMS, transforms.set(transforms.size() - 1, (Object)lastTransform.createConcatenation((Transform)translate)));
                    } else {
                        this.set((MapAccessor)TRANSFORMS, transforms.add(0, (Object)translate));
                    }
                }
            } else {
                this.flattenTransforms();
                ImmutableList transforms = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
                this.set((MapAccessor)TRANSFORMS, transforms.add(0, (Object)transform));
            }
        } else {
            this.reshapeInLocal(FXTransforms.concat((Transform[])new Transform[]{parentToLocal, transform}));
        }
    }

    default public void setTransforms(Transform ... transforms) {
        if (transforms.length == 1 && transforms[0].isIdentity()) {
            this.set((MapAccessor)TRANSFORMS, VectorList.of());
        } else {
            this.set((MapAccessor)TRANSFORMS, VectorList.of((Object[])transforms));
        }
    }

    default public void transformInLocal(@NonNull Transform t) {
        this.flattenTransforms();
        ImmutableList transforms = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
        this.set((MapAccessor)TRANSFORMS, transforms.add((Object)t));
    }

    default public void transformInParent(@NonNull Transform t) {
        if (t.isIdentity()) {
            return;
        }
        if (t instanceof Translate) {
            Translate tr = (Translate)t;
            this.flattenTransforms();
            ImmutableList transforms = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
            if (transforms.isEmpty()) {
                this.translateInLocal(new CssPoint2D(tr.getTx(), tr.getTy()));
            } else {
                Transform lastTransform = (Transform)transforms.get(transforms.size() - 1);
                if (lastTransform instanceof Translate) {
                    this.set((MapAccessor)TRANSFORMS, transforms.set(transforms.size() - 1, (Object)lastTransform.createConcatenation(t)));
                } else {
                    this.set((MapAccessor)TRANSFORMS, transforms.add(0, (Object)t));
                }
            }
        } else {
            this.flattenTransforms();
            ImmutableList transforms = (ImmutableList)this.getNonNull((NonNullMapAccessor)TRANSFORMS);
            this.set((MapAccessor)TRANSFORMS, transforms.add(0, (Object)t));
        }
    }
}

