/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.io;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class SvgFontFamilyConverter
implements CssConverter<ImmutableList<String>> {
    public static final String GENERIC_FONT_FAMILY_SERIF = "serif";
    public static final String GENERIC_FONT_FAMILY_SANS_SERIF = "sans-serif";
    public static final String GENERIC_FONT_FAMILY_CURSIVE = "cursive";
    public static final String GENERIC_FONT_FAMILY_FANTASY = "fantasy";
    public static final String GENERIC_FONT_FAMILY_MONOSPACE = "monospace";

    public @Nullable ImmutableList<String> parse(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        block5: while (true) {
            switch (tt.next()) {
                case -4: {
                    if (!buf.isEmpty()) {
                        throw tt.createParseException("<font-family>: Comma expected.");
                    }
                    list.add(tt.currentStringNonNull());
                    continue block5;
                }
                case -2: {
                    if (!buf.isEmpty()) {
                        buf.append(' ');
                    }
                    buf.append(tt.currentStringNonNull());
                    continue block5;
                }
                case 44: {
                    if (buf.isEmpty()) continue block5;
                    list.add(buf.toString());
                    buf.setLength(0);
                    continue block5;
                }
            }
            break;
        }
        tt.pushBack();
        if (list.isEmpty()) {
            throw tt.createParseException("<font-family>: <font-family> or <generic-family> expected.");
        }
        tt.requireNextToken(-1, "<font-family>: EOF expected.");
        return VectorList.copyOf(list);
    }

    public <TT extends ImmutableList<String>> void produceTokens(@Nullable TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        boolean first = true;
        block10: for (String s : value) {
            if (first) {
                first = false;
            } else {
                out.accept(new CssToken(44));
                out.accept(new CssToken(-16, " "));
            }
            switch (s) {
                case "serif": 
                case "sans-serif": 
                case "cursive": 
                case "fantasy": 
                case "monospace": {
                    out.accept(new CssToken(-2, s));
                    continue block10;
                }
            }
            out.accept(new CssToken(-4, s));
        }
    }

    public @Nullable ImmutableList<String> getDefaultValue() {
        return VectorList.of((Object[])new String[]{GENERIC_FONT_FAMILY_SERIF});
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8font-family\u27e9: \uff5b\u27e8family-name\uff5cgeneric-family\u27e9,\uff5d\u27e8family-name\uff5cgeneric-family\u27e9\n  with \u27e8family-name\u27e9: \u27e8string\u27e9\n  with \u27e8generic-family\u27e9: serif\uff5csans-serif\uff5ccursive\uff5cfantasy\uff5cmonospace";
    }

    public boolean isNullable() {
        return false;
    }
}

