/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.text;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.Paintable;

public class SvgCssPaintableConverter
extends AbstractCssConverter<Paintable> {
    public static final String CURRENT_COLOR_KEYWORD = "currentColor";
    private static final @NonNull ColorCssConverter colorConverter = new ColorCssConverter(false);

    public SvgCssPaintableConverter(boolean nullable) {
        super(nullable);
    }

    protected <TT extends Paintable> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        if (!(value instanceof CssColor)) {
            throw new UnsupportedOperationException("not yet implemented for " + String.valueOf(value));
        }
        CssColor c = (CssColor)value;
        colorConverter.produceTokens(c, idSupplier, out);
    }

    public @NonNull Paintable parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() == -12) {
            Object object;
            String url = tt.currentStringNonNull();
            if (url.startsWith("#") && (object = idResolver.getObject(url.substring(1))) instanceof Paintable) {
                return (Paintable)object;
            }
            throw tt.createParseException("SvgPaintable illegal URL: " + url);
        }
        tt.pushBack();
        return (Paintable)colorConverter.parseNonNull(tt, idResolver);
    }

    public @Nullable String getHelpText() {
        String[] lines = ("Format of \u27e8Paint\u27e9: none\uff5c\uff08\u27e8Color\u27e9\uff5c \u27e8LinearGradient\u27e9\uff5c \u27e8RadialGradient\u27e9\n" + colorConverter.getHelpText()).split("\n");
        StringBuilder buf = new StringBuilder();
        HashSet<String> duplicateLines = new HashSet<String>();
        for (String line : lines) {
            if (!duplicateLines.add(line)) continue;
            if (!buf.isEmpty()) {
                buf.append('\n');
            }
            buf.append(line);
        }
        return buf.toString();
    }
}

