/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.draw.figure;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.transform.Transform;
import javax.xml.transform.stream.StreamSource;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.SimpleUriResolver;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.RectangleConnector;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.CompositableFigure;
import org.jhotdraw8.draw.figure.ConnectableFigure;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.ImageableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.RectangleFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.key.CssRectangle2DStyleableMapAccessor;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.locator.Locator;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.svg.io.FXSvgTinyReader;

public class SvgImageFigure
extends AbstractLeafFigure
implements ResizableFigure,
TransformableFigure,
StyleableFigure,
LockableFigure,
CompositableFigure,
ConnectableFigure,
HideableFigure,
ImageableFigure {
    public static final String TYPE_SELECTOR = "Image";
    public static final @NonNull CssSizeStyleableKey X = RectangleFigure.X;
    public static final @NonNull CssSizeStyleableKey Y = RectangleFigure.Y;
    public static final @NonNull CssSizeStyleableKey WIDTH = RectangleFigure.WIDTH;
    public static final @NonNull CssSizeStyleableKey HEIGHT = RectangleFigure.HEIGHT;
    public static final @NonNull CssRectangle2DStyleableMapAccessor BOUNDS = RectangleFigure.BOUNDS;

    public SvgImageFigure() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public SvgImageFigure(double x, double y, double width, double height) {
        this.set((MapAccessor)BOUNDS, new CssRectangle2D(x, y, width, height));
    }

    public SvgImageFigure(CssRectangle2D rect) {
        this.set((MapAccessor)BOUNDS, rect);
    }

    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return (CssRectangle2D)this.getNonNull((NonNullMapAccessor)BOUNDS);
    }

    public void reshapeInLocal(@NonNull Transform transform) {
        Rectangle2D r = ((CssRectangle2D)this.getNonNull((NonNullMapAccessor)BOUNDS)).getConvertedValue();
        BoundingBox b = new BoundingBox(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
        b = transform.transform((Bounds)b);
        this.reshapeInLocal(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.set((MapAccessor)BOUNDS, new CssRectangle2D(width.getValue() < 0.0 ? x.add(width) : x, height.getValue() < 0.0 ? y.add(height) : y, width.abs(), height.abs()));
    }

    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Group g = new Group();
        return g;
    }

    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Node imageNode;
        Group g = (Group)node;
        Object renderedUri = g.getProperties().get((Object)"renderedUri");
        URI imageUri = (URI)this.getStyled((MapAccessor)IMAGE_URI);
        Drawing drawing = this.getDrawing();
        URI documentHome = drawing == null ? null : (URI)drawing.get((MapAccessor)Drawing.DOCUMENT_HOME);
        URI absoluteImageUri = documentHome == null || imageUri == null ? imageUri : new SimpleUriResolver().absolutize(documentHome, imageUri);
        Node node2 = imageNode = g.getChildren().isEmpty() ? null : (Node)g.getChildren().getFirst();
        if (imageNode == null || !Objects.equals(renderedUri, absoluteImageUri)) {
            imageNode = this.loadImage();
            g.getChildren().setAll((Object[])new Node[]{imageNode});
            g.getProperties().put((Object)"renderedUri", (Object)absoluteImageUri);
        }
        UnitConverter converter = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        Transform reshapeTransform = FXTransforms.createReshapeTransform((Bounds)imageNode.getBoundsInLocal(), (Bounds)this.getLayoutBounds());
        imageNode.getTransforms().setAll((Object[])new Transform[]{reshapeTransform});
        this.applyTransformableFigureProperties(ctx, (Node)g);
        this.applyCompositableFigureProperties(ctx, (Node)g);
        this.applyStyleableFigureProperties(ctx, (Node)g);
        this.applyHideableFigureProperties(ctx, (Node)g);
    }

    public @Nullable Connector findConnector(@NonNull Point2D p, Figure prototype, double tolerance) {
        return new RectangleConnector((Locator)new BoundsLocator(this.getLayoutBounds(), p));
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node loadImage() {
        URI uri = (URI)this.getStyled((MapAccessor)IMAGE_URI);
        if (uri == null) {
            return new Group();
        }
        Drawing drawing = this.getDrawing();
        URI documentHome = drawing == null ? null : (URI)drawing.get((MapAccessor)Drawing.DOCUMENT_HOME);
        URI absoluteUri = documentHome == null ? uri : documentHome.resolve(uri);
        try (BufferedInputStream in = new BufferedInputStream(absoluteUri.toURL().openStream());){
            String path;
            String string = path = absoluteUri.getPath() == null ? absoluteUri.toString() : absoluteUri.getPath();
            if (path != null && path.toLowerCase().endsWith(".svg")) {
                Group g = new Group();
                g.getChildren().addAll((Object[])new Node[]{new FXSvgTinyReader().read(new StreamSource(in))});
                Group imageView = g;
                return imageView;
            }
            Image image = new Image(absoluteUri.toString(), true);
            ImageView imageView = new ImageView(image);
            return imageView;
        }
        catch (IOException e) {
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            logger.log(Level.INFO, "Could not load SVG image from " + String.valueOf(absoluteUri), e);
            return new Group();
        }
    }

    public @NonNull Bounds getBoundsInLocal() {
        return this.getLayoutBounds();
    }
}

