/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.MappedConverter;
import org.jhotdraw8.css.value.CssDefaultableValue;
import org.jhotdraw8.css.value.CssDefaulting;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.NamedCssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.AbstractCompositeFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Grouping;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.NonTransformableFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.key.DefaultableStyleableMapAccessor;
import org.jhotdraw8.draw.key.NonNullObjectStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullKey;
import org.jhotdraw8.fxcollection.typesafekey.NonNullObjectKey;
import org.jhotdraw8.fxcollection.typesafekey.SimpleParameterizedType;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.svg.css.SvgDefaultablePaint;
import org.jhotdraw8.svg.css.SvgPaintDefaulting;
import org.jhotdraw8.svg.figure.SvgDefaultableFigure;
import org.jhotdraw8.svg.figure.SvgElementFigure;
import org.jhotdraw8.svg.figure.SvgStop;
import org.jhotdraw8.svg.text.SvgGradientUnits;

public abstract class AbstractSvgGradientFigure
extends AbstractCompositeFigure
implements Grouping,
ResizableFigure,
NonTransformableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
SvgDefaultableFigure,
SvgElementFigure,
Paintable {
    public static final @NonNull NonNullObjectStyleableKey<SvgGradientUnits> GRADIENT_UNITS = new NonNullObjectStyleableKey("gradientUnits", SvgGradientUnits.class, (Converter)new MappedConverter(Map.of("userSpaceOnUse", SvgGradientUnits.USER_SPACE_ON_USE, "objectBoundingBox", SvgGradientUnits.OBJECT_BOUNDING_BOX)), (Object)SvgGradientUnits.OBJECT_BOUNDING_BOX);
    public static final @NonNull NonNullObjectStyleableKey<CycleMethod> SPREAD_METHOD = new NonNullObjectStyleableKey("spreadMethod", CycleMethod.class, (Converter)new MappedConverter(Map.of("pad", CycleMethod.NO_CYCLE, "reflect", CycleMethod.REFLECT, "repeat", CycleMethod.REPEAT)), (Object)CycleMethod.NO_CYCLE);
    public static final @NonNull NonNullKey<ImmutableList<SvgStop>> STOPS = new NonNullObjectKey("stops", (Type)new SimpleParameterizedType(ImmutableList.class, new Type[]{SvgStop.class}), (Object)VectorList.of());

    public AbstractSvgGradientFigure() {
        this.set((MapAccessor)VISIBLE, false);
    }

    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Group g = new Group();
        g.setAutoSizeChildren(false);
        g.setManaged(false);
        g.setVisible(false);
        return g;
    }

    public @Nullable Paint getPaint() {
        return this.getPaint(null);
    }

    protected @NonNull ArrayList<Stop> getStops(ImmutableList<SvgStop> cssStops) {
        ArrayList<Stop> stops = new ArrayList<Stop>(cssStops.size());
        double maxOffset = 0.0;
        for (SvgStop cssStop : cssStops) {
            Color color;
            CssSize opacity;
            NamedCssColor cssColor;
            SvgDefaultablePaint<CssColor> colorDef = cssStop.color();
            if (colorDef == null) {
                cssColor = NamedCssColor.BLACK;
            } else if (colorDef.getDefaulting() == null) {
                cssColor = colorDef.getValue();
            } else {
                cssColor = switch (colorDef.getDefaulting()) {
                    default -> (CssColor)this.getDefaultableStyled((DefaultableStyleableMapAccessor)STOP_COLOR_KEY);
                    case SvgPaintDefaulting.CURRENT_COLOR -> (CssColor)this.getDefaultableStyled((DefaultableStyleableMapAccessor)COLOR_KEY);
                };
            }
            Double offset = cssStop.offset();
            CssDefaultableValue<CssSize> opacityDef = cssStop.opacity();
            if (opacityDef.getDefaulting() != null) {
                opacity = switch (opacityDef.getDefaulting()) {
                    case CssDefaulting.INHERIT -> (CssSize)this.getDefaultableStyled((DefaultableStyleableMapAccessor)STOP_OPACITY_KEY);
                    default -> CssSize.ONE;
                };
            } else {
                opacity = (CssSize)opacityDef.getValue();
            }
            Color color2 = color = cssColor == null ? Color.BLACK : cssColor.getColor();
            if (opacity != null && opacity.getConvertedValue() != 1.0) {
                color = Color.color((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), (double)opacity.getConvertedValue());
            }
            if (offset == null) continue;
            maxOffset = Math.max(offset, maxOffset);
            stops.add(new Stop(maxOffset, color));
        }
        return stops;
    }

    public void updateNode(@NonNull RenderContext ctx, @NonNull Node n) {
    }

    public boolean isSuitableParent(@NonNull Figure newParent) {
        return true;
    }

    public boolean isSuitableChild(@NonNull Figure newChild) {
        return true;
    }

    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
    }
}

