/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.css.StyleOrigin;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.converter.DoubleCssConverter;
import org.jhotdraw8.css.converter.KebabCaseEnumCssConverter;
import org.jhotdraw8.css.converter.ListCssConverter;
import org.jhotdraw8.css.converter.MappedCssConverter;
import org.jhotdraw8.css.converter.PercentageCssConverter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.value.CssDefaultableValue;
import org.jhotdraw8.css.value.CssDefaulting;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.NamedCssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.DefaultableFigure;
import org.jhotdraw8.draw.key.DefaultableStyleableKey;
import org.jhotdraw8.draw.key.DefaultableStyleableMapAccessor;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.SimpleParameterizedType;
import org.jhotdraw8.icollection.MapEntries;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.svg.css.SvgDefaultablePaint;
import org.jhotdraw8.svg.css.SvgPaintDefaulting;
import org.jhotdraw8.svg.io.SvgFontFamilyConverter;
import org.jhotdraw8.svg.key.SvgDefaultablePaintStyleableKey;
import org.jhotdraw8.svg.key.SvgDefaultablePaintStyleableMapAccessor;
import org.jhotdraw8.svg.text.SvgCssPaintableConverter;
import org.jhotdraw8.svg.text.SvgDisplay;
import org.jhotdraw8.svg.text.SvgFontSize;
import org.jhotdraw8.svg.text.SvgFontSizeConverter;
import org.jhotdraw8.svg.text.SvgShapeRendering;
import org.jhotdraw8.svg.text.SvgStrokeAlignmentConverter;
import org.jhotdraw8.svg.text.SvgTextAnchor;
import org.jhotdraw8.svg.text.SvgVisibility;

public interface SvgDefaultableFigure
extends DefaultableFigure {
    public static final DefaultableStyleableKey<CssColor> COLOR_KEY = new DefaultableStyleableKey("color", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{CssColor.class}), (CssConverter)new ColorCssConverter(true), new CssDefaultableValue(CssDefaulting.INHERIT, null), (Object)NamedCssColor.BLACK);
    public static final DefaultableStyleableKey<CssColor> STOP_COLOR_KEY = new DefaultableStyleableKey("stop-color", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{CssColor.class}), (CssConverter)new ColorCssConverter(true), new CssDefaultableValue(CssDefaulting.INHERIT, null), (Object)NamedCssColor.BLACK);
    public static final DefaultableStyleableKey<CssSize> STOP_OPACITY_KEY = new DefaultableStyleableKey("stop-opacity", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{CssSize.class}), (CssConverter)new SizeCssConverter(true), new CssDefaultableValue(CssDefaulting.INHERIT, null), (Object)CssSize.ONE);
    public static final SvgDefaultablePaintStyleableKey<Paintable> FILL_KEY = new SvgDefaultablePaintStyleableKey<NamedCssColor>("fill", (Type)new SimpleParameterizedType(SvgDefaultablePaint.class, new Type[]{Paintable.class}), (CssConverter<NamedCssColor>)new SvgCssPaintableConverter(true), (SvgDefaultablePaint<NamedCssColor>)new SvgDefaultablePaint<Object>(SvgPaintDefaulting.INHERIT, null), NamedCssColor.BLACK);
    public static final @NonNull DefaultableStyleableKey<FillRule> FILL_RULE_KEY = new DefaultableStyleableKey("fill-rule", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{FillRule.class}), (CssConverter)new MappedCssConverter("fill-rule", (Map)MapEntries.linkedHashMap((List)MapEntries.of((Object)"nonzero", (Object)FillRule.NON_ZERO, (Object)"evenodd", (Object)FillRule.EVEN_ODD))), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)FillRule.NON_ZERO);
    public static final DefaultableStyleableKey<ImmutableList<String>> FONT_FAMILY_KEY = new DefaultableStyleableKey("font-family", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{new SimpleParameterizedType(ImmutableList.class, new Type[]{String.class})}), (CssConverter)new SvgFontFamilyConverter(), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)VectorList.of((Object[])new String[]{"sans-serif"}));
    public static final DefaultableStyleableKey<SvgFontSize> FONT_SIZE_KEY = new DefaultableStyleableKey("font-size", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{SvgFontSize.class}), (CssConverter)new SvgFontSizeConverter(), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)new SvgFontSize(SvgFontSize.SizeKeyword.MEDIUM, null));
    public static final SvgDefaultablePaintStyleableKey<Paintable> STROKE_KEY = new SvgDefaultablePaintStyleableKey<Object>("stroke", (Type)new SimpleParameterizedType(SvgDefaultablePaint.class, new Type[]{Paintable.class}), (CssConverter<Object>)new SvgCssPaintableConverter(true), new SvgDefaultablePaint<Object>(SvgPaintDefaulting.INHERIT, null), null);
    public static final DefaultableStyleableKey<StrokeType> STROKE_ALIGNMENT_KEY = new DefaultableStyleableKey("stroke-alignment", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{StrokeType.class}), (CssConverter)new SvgStrokeAlignmentConverter(false), new CssDefaultableValue(CssDefaulting.INHERIT, null), (Object)StrokeType.CENTERED);
    public static final DefaultableStyleableKey<ImmutableList<Double>> STROKE_DASHARRAY_KEY = new DefaultableStyleableKey("stroke-dasharray", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{new SimpleParameterizedType(ImmutableList.class, new Type[]{Double.class})}), (CssConverter)new ListCssConverter((CssConverter)new DoubleCssConverter(false), ", "), new CssDefaultableValue(CssDefaulting.INHERIT, null), null);
    public static final DefaultableStyleableKey<Double> STROKE_DASHOFFSET_KEY = new DefaultableStyleableKey("stroke-dashoffset", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{Double.class}), (CssConverter)new PercentageCssConverter(false), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)0.0);
    public static final DefaultableStyleableKey<Double> FILL_OPACITY_KEY = new DefaultableStyleableKey("fill-opacity", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{Double.class}), (CssConverter)new PercentageCssConverter(false), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)1.0);
    public static final DefaultableStyleableKey<Double> STROKE_OPACITY_KEY = new DefaultableStyleableKey("stroke-opacity", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{Double.class}), (CssConverter)new PercentageCssConverter(false), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)1.0);
    public static final @NonNull DefaultableStyleableKey<SvgTextAnchor> TEXT_ANCHOR_KEY = new DefaultableStyleableKey("text-anchor", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{SvgTextAnchor.class}), (CssConverter)new KebabCaseEnumCssConverter(SvgTextAnchor.class), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)SvgTextAnchor.START);
    public static final @NonNull DefaultableStyleableKey<SvgShapeRendering> SHAPE_RENDERING_KEY = new DefaultableStyleableKey("shape-rendering", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{SvgShapeRendering.class}), (CssConverter)new MappedCssConverter("shape-rendering", (Map)MapEntries.linkedHashMap((List)MapEntries.of((Object)"auto", (Object)((Object)SvgShapeRendering.AUTO), (Object)"optimizeSpeed", (Object)((Object)SvgShapeRendering.OPTIMIZE_SPEED), (Object)"crispEdges", (Object)((Object)SvgShapeRendering.CRISP_EDGES), (Object)"geometricPrecision", (Object)((Object)SvgShapeRendering.GEOMETRIC_PRECISION)))), new CssDefaultableValue((Object)SvgShapeRendering.GEOMETRIC_PRECISION), (Object)SvgShapeRendering.AUTO);
    public static final DefaultableStyleableKey<Double> STROKE_MITERLIMIT_KEY = new DefaultableStyleableKey("stroke-miterlimit", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{Double.class}), (CssConverter)new DoubleCssConverter(false), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)4.0);
    public static final DefaultableStyleableKey<StrokeLineCap> STROKE_LINECAP_KEY = new DefaultableStyleableKey("stroke-linecap", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{StrokeLineCap.class}), (CssConverter)new MappedCssConverter("stroke-linecap", (Map)MapEntries.linkedHashMap((List)MapEntries.of((Object)"butt", (Object)StrokeLineCap.BUTT, (Object)"round", (Object)StrokeLineCap.ROUND, (Object)"square", (Object)StrokeLineCap.SQUARE))), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)StrokeLineCap.BUTT);
    public static final DefaultableStyleableKey<StrokeLineJoin> STROKE_LINEJOIN_KEY = new DefaultableStyleableKey("stroke-linejoin", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{StrokeLineJoin.class}), (CssConverter)new MappedCssConverter("stroke-linejoin", (Map)MapEntries.linkedHashMap((List)MapEntries.of((Object)"miter", (Object)StrokeLineJoin.MITER, (Object)"round", (Object)StrokeLineJoin.ROUND, (Object)"bevel", (Object)StrokeLineJoin.BEVEL))), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)StrokeLineJoin.MITER);
    public static final DefaultableStyleableKey<CssSize> STROKE_WIDTH_KEY = new DefaultableStyleableKey("stroke-width", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{CssSize.class}), (CssConverter)new SizeCssConverter(false), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)CssSize.ONE);
    public static final DefaultableStyleableKey<SvgVisibility> VISIBILITY_KEY = new DefaultableStyleableKey("visiblity", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{SvgVisibility.class}), (CssConverter)new MappedCssConverter("visiblity", (Map)MapEntries.linkedHashMap((List)MapEntries.of((Object)"visible", (Object)((Object)SvgVisibility.VISIBLE), (Object)"hidden", (Object)((Object)SvgVisibility.HIDDEN), (Object)"collapse", (Object)((Object)SvgVisibility.COLLAPSE)))), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)SvgVisibility.VISIBLE);
    public static final DefaultableStyleableKey<BlendMode> MIX_BLEND_MODE_KEY = new DefaultableStyleableKey("mix-blend-mode", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{BlendMode.class}), (CssConverter)new MappedCssConverter("mix-blend-mode", (Map)MapEntries.linkedHashMap((List)MapEntries.ofEntries((Map.Entry[])new Map.Entry[]{MapEntries.entry((Object)"normal", (Object)BlendMode.SRC_OVER), MapEntries.entry((Object)"mulitply", (Object)BlendMode.MULTIPLY), MapEntries.entry((Object)"screen", (Object)BlendMode.SCREEN), MapEntries.entry((Object)"overlay", (Object)BlendMode.OVERLAY), MapEntries.entry((Object)"darken", (Object)BlendMode.DARKEN), MapEntries.entry((Object)"lighten", (Object)BlendMode.LIGHTEN), MapEntries.entry((Object)"color-dodge", (Object)BlendMode.COLOR_DODGE), MapEntries.entry((Object)"color-burn", (Object)BlendMode.COLOR_BURN), MapEntries.entry((Object)"hard-light", (Object)BlendMode.HARD_LIGHT), MapEntries.entry((Object)"soft-light", (Object)BlendMode.SOFT_LIGHT), MapEntries.entry((Object)"difference", (Object)BlendMode.DIFFERENCE), MapEntries.entry((Object)"exclusion", (Object)BlendMode.EXCLUSION), MapEntries.entry((Object)"hue", (Object)BlendMode.SRC_OVER), MapEntries.entry((Object)"saturation", (Object)BlendMode.SRC_OVER), MapEntries.entry((Object)"color", (Object)BlendMode.SRC_OVER), MapEntries.entry((Object)"luminosity", (Object)BlendMode.SRC_OVER)}))), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)BlendMode.SRC_OVER);
    public static final @NonNull DefaultableStyleableKey<SvgDisplay> DISPLAY_KEY = new DefaultableStyleableKey("display", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{SvgDisplay.class}), (CssConverter)new MappedCssConverter("display", (Map)MapEntries.linkedHashMap((List)MapEntries.of((Object)"inline", (Object)((Object)SvgDisplay.INLINE))), true), new CssDefaultableValue((Object)SvgDisplay.INLINE), (Object)SvgDisplay.INLINE);
    public static final @NonNull DefaultableStyleableKey<Double> OPACITY_KEY = new DefaultableStyleableKey("opacity", (Type)new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{Double.class}), (CssConverter)new PercentageCssConverter(false), new CssDefaultableValue(CssDefaulting.INHERIT), (Object)1.0);

    default public void applySvgDefaultableCompositingProperties(@NonNull RenderContext ctx, @NonNull Node node) {
        node.setOpacity(((Double)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)OPACITY_KEY)).doubleValue());
        BlendMode bmValue = (BlendMode)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)MIX_BLEND_MODE_KEY);
        if (bmValue == BlendMode.SRC_OVER) {
            bmValue = null;
        }
        if (node.getBlendMode() != bmValue) {
            node.setBlendMode(bmValue);
        }
    }

    default public void applySvgDefaultableFillProperties(@NonNull RenderContext ctx, @NonNull Shape shape) {
        Paintable fill = this.getDefaultableStyled(FILL_KEY);
        if (fill instanceof CssColor && "currentColor".equals(((CssColor)fill).getName())) {
            fill = (Paintable)this.getDefaultableStyled((DefaultableStyleableMapAccessor)COLOR_KEY);
        }
        shape.setFill(Paintable.getPaint((Paintable)fill));
        double fillOpacity = (Double)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)FILL_OPACITY_KEY);
        shape.setOpacity(fillOpacity);
    }

    default public void applySvgDefaultableStrokeProperties(@NonNull RenderContext ctx, @NonNull Shape shape) {
        Paintable stroke = this.getDefaultableStyled(STROKE_KEY);
        if (stroke instanceof CssColor && "currentColor".equals(((CssColor)stroke).getName())) {
            stroke = (Paintable)this.getDefaultableStyled((DefaultableStyleableMapAccessor)COLOR_KEY);
        }
        shape.setStroke(Paintable.getPaint((Paintable)stroke));
        CssSize sw = (CssSize)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)STROKE_WIDTH_KEY);
        shape.setStrokeWidth(sw.getConvertedValue((UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY)));
        shape.setOpacity(((Double)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)STROKE_OPACITY_KEY)).doubleValue());
        SvgShapeRendering shapeRendering = (SvgShapeRendering)((Object)this.getDefaultableStyled((DefaultableStyleableMapAccessor)SHAPE_RENDERING_KEY));
        if (shapeRendering == SvgShapeRendering.CRISP_EDGES) {
            shape.setTranslateX(0.5);
            shape.setTranslateY(0.5);
        }
        shape.setStrokeLineCap((StrokeLineCap)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)STROKE_LINECAP_KEY));
        shape.setStrokeLineJoin((StrokeLineJoin)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)STROKE_LINEJOIN_KEY));
        shape.setStrokeMiterLimit(((Double)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)STROKE_MITERLIMIT_KEY)).doubleValue());
        shape.setStrokeDashOffset(((Double)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)STROKE_DASHOFFSET_KEY)).doubleValue());
        ImmutableList dasharray = (ImmutableList)this.getDefaultableStyled((DefaultableStyleableMapAccessor)STROKE_DASHARRAY_KEY);
        if (dasharray == null) {
            shape.getStrokeDashArray().clear();
        } else {
            boolean allZeros = true;
            for (Double value : dasharray) {
                if (!(value > 0.0)) continue;
                allZeros = false;
                break;
            }
            if (allZeros) {
                shape.getStrokeDashArray().clear();
            } else {
                shape.getStrokeDashArray().setAll((Collection)dasharray.asCollection());
            }
        }
    }

    default public void applySvgShapeProperties(@NonNull RenderContext ctx, Shape fillShape, Shape strokeShape) {
        double fillOpacity;
        double strokeOpacity = (Double)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)STROKE_OPACITY_KEY);
        if (strokeOpacity == (fillOpacity = ((Double)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)FILL_OPACITY_KEY)).doubleValue())) {
            this.applySvgDefaultableFillProperties(ctx, fillShape);
            this.applySvgDefaultableStrokeProperties(ctx, fillShape);
            fillShape.setVisible(true);
            strokeShape.setVisible(false);
        } else {
            fillShape.setStroke(null);
            strokeShape.setFill(null);
            this.applySvgDefaultableFillProperties(ctx, fillShape);
            this.applySvgDefaultableStrokeProperties(ctx, strokeShape);
            fillShape.setVisible(true);
            strokeShape.setVisible(true);
        }
    }

    default public <T extends Paintable> @Nullable Paintable getDefaultableStyled(@NonNull SvgDefaultablePaintStyleableMapAccessor<T> key) {
        return this.getDefaultableStyled(StyleOrigin.INLINE, key);
    }

    default public <T extends Paintable> @Nullable Paintable getDefaultableStyled(@NonNull StyleOrigin origin, @NonNull SvgDefaultablePaintStyleableMapAccessor<T> key) {
        SvgDefaultablePaint dv = Objects.requireNonNull((SvgDefaultablePaint)this.getStyled(origin == StyleOrigin.INLINE ? null : origin, (MapAccessor)key));
        if (dv.getDefaulting() == null) {
            return dv.getValue();
        }
        switch (dv.getDefaulting()) {
            case INHERIT: {
                if (this.getParent() instanceof SvgDefaultableFigure) {
                    return ((SvgDefaultableFigure)this.getParent()).getDefaultableStyled(key);
                }
                return key.getInitialValue();
            }
            case CURRENT_COLOR: {
                return (Paintable)this.getDefaultableStyled((DefaultableStyleableMapAccessor)COLOR_KEY);
            }
        }
        throw new UnsupportedOperationException("unsupported defaulting: " + String.valueOf((Object)dv.getDefaulting()));
    }
}

