/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.DefaultableStyleableMapAccessor;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.svg.figure.SvgDefaultableFigure;
import org.jhotdraw8.svg.figure.SvgElementFigure;
import org.jhotdraw8.svg.figure.SvgPathLengthFigure;
import org.jhotdraw8.svg.figure.SvgTransformableFigure;
import org.jhotdraw8.svg.text.SvgShapeRendering;

public class SvgLineFigure
extends AbstractLeafFigure
implements StyleableFigure,
LockableFigure,
SvgTransformableFigure,
PathIterableFigure,
HideableFigure,
SvgPathLengthFigure,
SvgDefaultableFigure,
SvgElementFigure {
    public static final @NonNull String TYPE_SELECTOR = "line";
    public static final @NonNull CssSizeStyleableKey X1 = new CssSizeStyleableKey("x1", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey Y1 = new CssSizeStyleableKey("y1", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey X2 = new CssSizeStyleableKey("x2", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey Y2 = new CssSizeStyleableKey("y2", CssSize.ZERO);

    public @NonNull Node createNode(@NonNull RenderContext ctx) {
        Line n = new Line();
        n.setManaged(false);
        return n;
    }

    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, @Nullable AffineTransform tx) {
        Path2D.Double p = new Path2D.Double();
        p.moveTo(((CssSize)this.getNonNull((NonNullMapAccessor)X1)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)Y1)).getConvertedValue());
        p.lineTo(((CssSize)this.getNonNull((NonNullMapAccessor)X2)).getConvertedValue(), ((CssSize)this.getNonNull((NonNullMapAccessor)Y2)).getConvertedValue());
        return p.getPathIterator(tx);
    }

    public @NonNull Bounds getBoundsInLocal() {
        return this.getCssLayoutBounds().getConvertedBoundsValue();
    }

    public @NonNull CssRectangle2D getCssLayoutBounds() {
        CssSize startX = (CssSize)this.getNonNull((NonNullMapAccessor)X1);
        CssSize startY = (CssSize)this.getNonNull((NonNullMapAccessor)Y1);
        CssSize endX = (CssSize)this.getNonNull((NonNullMapAccessor)X2);
        CssSize endY = (CssSize)this.getNonNull((NonNullMapAccessor)Y2);
        return new CssRectangle2D(new CssPoint2D(startX, startY), new CssPoint2D(endX, endY));
    }

    @Override
    public void reshapeInLocal(@NonNull Transform transform) {
        CssSize startX = (CssSize)this.getNonNull((NonNullMapAccessor)X1);
        CssSize startY = (CssSize)this.getNonNull((NonNullMapAccessor)Y1);
        CssSize endX = (CssSize)this.getNonNull((NonNullMapAccessor)X2);
        CssSize endY = (CssSize)this.getNonNull((NonNullMapAccessor)Y2);
        CssPoint2D start = new CssPoint2D(startX, startY);
        CssPoint2D end = new CssPoint2D(endX, endY);
        CssPoint2D tstart = new CssPoint2D(FXTransforms.transform((Transform)transform, (Point2D)start.getConvertedValue()));
        CssPoint2D tend = new CssPoint2D(FXTransforms.transform((Transform)transform, (Point2D)end.getConvertedValue()));
        this.set((MapAccessor)X1, tstart.getX());
        this.set((MapAccessor)Y1, tstart.getY());
        this.set((MapAccessor)X2, tend.getX());
        this.set((MapAccessor)Y2, tend.getY());
    }

    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.reshapeInLocal(x.getConvertedValue(), y.getConvertedValue(), width.getConvertedValue(), height.getConvertedValue());
    }

    public void reshapeInLocal(double x, double y, double width, double height) {
        this.reshapeInLocal(FXTransforms.createReshapeTransform((Bounds)this.getLayoutBounds(), (double)x, (double)y, (double)width, (double)height));
    }

    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Line n = (Line)node;
        UnitConverter unit = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double startX = ((CssSize)this.getNonNull((NonNullMapAccessor)X1)).getConvertedValue(unit);
        double startY = ((CssSize)this.getNonNull((NonNullMapAccessor)Y1)).getConvertedValue(unit);
        double endX = ((CssSize)this.getNonNull((NonNullMapAccessor)X2)).getConvertedValue(unit);
        double endY = ((CssSize)this.getNonNull((NonNullMapAccessor)Y2)).getConvertedValue(unit);
        if (startX == endX && startY == endY) {
            n.setVisible(false);
            return;
        }
        this.applyHideableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyTransformableFigureProperties(ctx, node);
        this.applySvgDefaultableStrokeProperties(ctx, (Shape)n);
        this.applySvgDefaultableCompositingProperties(ctx, (Node)n);
        n.setStartX(startX);
        n.setStartY(startY);
        n.setEndX(endX);
        n.setEndY(endY);
        n.applyCss();
        SvgShapeRendering shapeRendering = (SvgShapeRendering)((Object)this.getDefaultableStyled((DefaultableStyleableMapAccessor)SHAPE_RENDERING_KEY));
        if (shapeRendering == SvgShapeRendering.CRISP_EDGES) {
            n.setTranslateX(0.5);
            n.setTranslateY(0.5);
        }
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }
}

