/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Objects;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.figure.TextableFigure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.DefaultableStyleableMapAccessor;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.SimpleRenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.svg.figure.SvgDefaultableFigure;
import org.jhotdraw8.svg.figure.SvgElementFigure;
import org.jhotdraw8.svg.figure.SvgTransformableFigure;
import org.jhotdraw8.svg.text.SvgFontSize;
import org.jhotdraw8.svg.text.SvgTextAnchor;

public class SvgTextFigure
extends AbstractLeafFigure
implements StyleableFigure,
LockableFigure,
SvgTransformableFigure,
PathIterableFigure,
HideableFigure,
TextableFigure,
SvgDefaultableFigure,
SvgElementFigure {
    public static final @NonNull String TYPE_SELECTOR = "text";
    public static final @NonNull CssSizeStyleableKey X = new CssSizeStyleableKey("x", CssSize.ZERO);
    public static final @NonNull CssSizeStyleableKey Y = new CssSizeStyleableKey("y", CssSize.ZERO);
    private @Nullable Bounds cachedLayoutBounds;

    public SvgTextFigure() {
        this(0.0, 0.0);
    }

    public SvgTextFigure(@NonNull Point2D position) {
        this(position.getX(), position.getY());
    }

    public SvgTextFigure(double x, double y) {
        if (x != 0.0) {
            this.set((MapAccessor)X, CssSize.of((double)x));
        }
        if (y != 0.0) {
            this.set((MapAccessor)Y, CssSize.of((double)y));
        }
    }

    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Group g = new Group();
        g.setManaged(false);
        g.setAutoSizeChildren(false);
        Text n0 = new Text();
        n0.setManaged(false);
        Text n1 = new Text();
        n1.setManaged(false);
        g.getProperties().put((Object)"fillNode", (Object)n0);
        g.getProperties().put((Object)"strokeNode", (Object)n1);
        return g;
    }

    protected @Nullable Bounds getCachedLayoutBounds() {
        return this.cachedLayoutBounds;
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    protected @Nullable Bounds setCachedLayoutBounds(Bounds newValue) {
        Bounds oldValue = this.cachedLayoutBounds;
        this.cachedLayoutBounds = newValue;
        return oldValue;
    }

    public @NonNull Bounds getLayoutBounds() {
        Bounds boundsInLocal = this.getCachedLayoutBounds();
        return boundsInLocal == null ? this.computeLayoutBounds() : boundsInLocal;
    }

    public @NonNull Bounds getBoundsInLocal() {
        return this.getCssLayoutBounds().getConvertedBoundsValue();
    }

    public @NonNull CssRectangle2D getCssLayoutBounds() {
        return new CssRectangle2D(this.getLayoutBounds());
    }

    public @NonNull Bounds computeLayoutBounds() {
        return this.computeLayoutBounds((RenderContext)new SimpleRenderContext(), new Text());
    }

    protected @NonNull Bounds computeLayoutBounds(@NonNull RenderContext ctx, Text textNode) {
        this.updateTextNode(ctx, textNode);
        Bounds b = textNode.getLayoutBounds();
        Insets i = new Insets(0.0, 0.0, 0.0, 0.0);
        return new BoundingBox(b.getMinX() - i.getLeft(), b.getMinY() - i.getTop(), b.getWidth() + i.getLeft() + i.getRight(), textNode.getBaselineOffset() + i.getTop() + i.getBottom());
    }

    protected @NonNull Bounds getTextBounds(@Nullable RenderContext ctx) {
        Text textNode = new Text();
        this.updateTextNode(ctx, textNode);
        Bounds b = textNode.getLayoutBounds();
        return b;
    }

    public @NonNull PathIterator getPathIterator(@NonNull RenderContext ctx, @Nullable AffineTransform tx) {
        Text tn = new Text();
        tn.setX(((CssSize)this.getStyledNonNull((NonNullMapAccessor)X)).getConvertedValue());
        tn.setY(((CssSize)this.getStyledNonNull((NonNullMapAccessor)Y)).getConvertedValue());
        tn.setBoundsType(TextBoundsType.VISUAL);
        tn.setText(this.getText(null));
        return FXShapes.fxShapeToAwtShape((Shape)tn).getPathIterator(tx);
    }

    protected @Nullable String getText(@NonNull RenderContext ctx) {
        return (String)this.get((MapAccessor)TEXT);
    }

    public void layout(@NonNull RenderContext ctx) {
        Bounds b = this.computeLayoutBounds(ctx, new Text());
        this.setCachedLayoutBounds(b);
    }

    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        Bounds lb = this.computeLayoutBounds();
        Insets i = new Insets(0.0, 0.0, 0.0, 0.0);
        this.set((MapAccessor)X, CssSize.of((double)(x.getConvertedValue() + i.getLeft())));
        this.set((MapAccessor)Y, CssSize.of((double)(y.getConvertedValue() + lb.getHeight() - i.getBottom())));
    }

    public void translateInLocal(@NonNull CssPoint2D delta) {
        CssSize x = (CssSize)this.get((MapAccessor)X);
        CssSize y = (CssSize)this.get((MapAccessor)Y);
        this.set((MapAccessor)X, x.add(delta.getX()));
        this.set((MapAccessor)Y, y.add(delta.getY()));
    }

    protected void updateGroupNode(@NonNull RenderContext ctx, Group node) {
        this.applySvgDefaultableCompositingProperties(ctx, (Node)node);
    }

    public void updateNode(@NonNull RenderContext ctx, @NonNull Node node) {
        Group g = (Group)node;
        Text n0 = (Text)g.getProperties().get((Object)"fillNode");
        Text n1 = (Text)g.getProperties().get((Object)"strokeNode");
        this.updateGroupNode(ctx, g);
        this.updateTextNode(ctx, n0);
        this.updateTextNode(ctx, n1);
        this.applySvgShapeProperties(ctx, (Shape)n0, (Shape)n1);
        g.getChildren().clear();
        if (n0.getFill() != null) {
            g.getChildren().add((Object)n0);
        }
        if (n1.getStroke() != null) {
            g.getChildren().add((Object)n1);
        }
    }

    protected void updateTextNode(@NonNull RenderContext ctx, @NonNull Text tn) {
        String text;
        this.applySvgDefaultableFillProperties(ctx, (Shape)tn);
        SvgTextAnchor textAnchor = (SvgTextAnchor)((Object)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)TEXT_ANCHOR_KEY));
        switch (textAnchor) {
            case START: {
                tn.setTextAlignment(TextAlignment.LEFT);
                break;
            }
            case MIDDLE: {
                tn.setTextAlignment(TextAlignment.CENTER);
                break;
            }
            case END: {
                tn.setTextAlignment(TextAlignment.RIGHT);
            }
        }
        SvgFontSize fontSize = (SvgFontSize)this.getDefaultableStyledNonNull((DefaultableStyleableMapAccessor)FONT_SIZE_KEY);
        UnitConverter unitConverter = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double convertedFontSize = fontSize.getConvertedValue(this, unitConverter);
        Font font = tn.getFont();
        if (font != null && font.getSize() != convertedFontSize) {
            font = Font.font((String)font.getFamily(), (double)convertedFontSize);
            tn.setFont(font);
        }
        if (!Objects.equals(text = this.getText(ctx), tn.getText())) {
            tn.setText(text);
        }
        Bounds boundsInLocal = tn.getBoundsInLocal();
        double x = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)X)).getConvertedValue(unitConverter);
        double y = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)Y)).getConvertedValue(unitConverter);
        switch (textAnchor) {
            case START: {
                break;
            }
            case MIDDLE: {
                x -= boundsInLocal.getWidth() * 0.5;
                break;
            }
            case END: {
                x -= boundsInLocal.getWidth();
            }
        }
        tn.setX(x);
        tn.setY(y);
    }
}

