/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.io;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdFactory;
import org.jhotdraw8.base.converter.SimpleIdFactory;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.converter.DoubleCssConverter;
import org.jhotdraw8.css.converter.ListCssConverter;
import org.jhotdraw8.draw.css.value.CssDimension2D;
import org.jhotdraw8.draw.io.BitmapExportOutputFormat;
import org.jhotdraw8.fxbase.beans.AbstractPropertyBean;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXPreciseRotate;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXSvgPaths;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.SvgPaths;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.svg.io.SvgSceneGraphWriter;
import org.jhotdraw8.svg.text.SvgPaintCssConverter;
import org.jhotdraw8.svg.text.SvgTransformConverter;
import org.jhotdraw8.xml.IndentingXMLStreamWriter;
import org.jhotdraw8.xml.converter.DoubleXmlConverter;
import org.jhotdraw8.xml.converter.FloatXmlConverter;
import org.jhotdraw8.xml.converter.IntegerXmlConverter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class AbstractFXSvgWriter
extends AbstractPropertyBean
implements SvgSceneGraphWriter {
    public static final @NonNull String SVG_MIME_TYPE = "image/svg+xml";
    public static final @NonNull String SVG_NS = "http://www.w3.org/2000/svg";
    protected static final @NonNull String XLINK_NS = "http://www.w3.org/1999/xlink";
    protected static final @NonNull String XLINK_PREFIX = "xlink";
    protected final @NonNull DoubleXmlConverter nb = new DoubleXmlConverter();
    protected final @NonNull IntegerXmlConverter nbi = new IntegerXmlConverter();
    protected final @NonNull FloatXmlConverter nbf = new FloatXmlConverter();
    private final @Nullable Object imageUriKey;
    private final @NonNull Converter<ImmutableList<Double>> doubleList = new ListCssConverter((CssConverter)new DoubleCssConverter(false));
    private final @NonNull Converter<Paint> paintConverter = new SvgPaintCssConverter(true);
    private final @Nullable Object skipKey;
    private final @NonNull Converter<ImmutableList<Transform>> tx = new ListCssConverter((CssConverter)new SvgTransformConverter(false));
    protected final @NonNull IdFactory idFactory = new SimpleIdFactory();

    public AbstractFXSvgWriter(@Nullable Object imageUriKey, @Nullable Object skipKey) {
        this.imageUriKey = imageUriKey;
        this.skipKey = skipKey;
    }

    private @NonNull Rectangle2D.Double drawParagraph(@NonNull XMLStreamWriter w, FontRenderContext frc, @NonNull String paragraph, @NonNull AttributedCharacterIterator styledText, float verticalPos, float maxVerticalPos, float leftMargin, float rightMargin, float @NonNull [] tabStops, int tabCount, @NonNull TextAlignment textAlignment, float lineSpacing) throws XMLStreamException {
        Rectangle2D.Double paragraphBounds = new Rectangle2D.Double(leftMargin, verticalPos, 0.0, 0.0);
        int[] tabLocations = new int[tabCount + 1];
        int i = 0;
        char c = styledText.first();
        while (c != '\uffff') {
            if (c == '\t') {
                tabLocations[i++] = styledText.getIndex();
            }
            c = styledText.next();
        }
        tabLocations[tabCount] = styledText.getEndIndex() - 1;
        LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);
        int currentTab = 0;
        int textIndex = 0;
        while (measurer.getPosition() < styledText.getEndIndex() && verticalPos <= maxVerticalPos) {
            boolean lineContainsText = false;
            boolean lineComplete = false;
            float maxAscent = 0.0f;
            float maxDescent = 0.0f;
            float horizontalPos = leftMargin;
            ArrayList<TextLayout> layouts = new ArrayList<TextLayout>();
            ArrayList<Float> penPositions = new ArrayList<Float>();
            int first = 0;
            while (!lineComplete && verticalPos <= maxVerticalPos) {
                float wrappingWidth = rightMargin - horizontalPos;
                TextLayout layout = measurer.nextLayout(wrappingWidth, tabLocations[currentTab] + 1, lineContainsText);
                if (layout != null) {
                    layouts.add(layout);
                    penPositions.add(Float.valueOf(horizontalPos));
                    horizontalPos += layout.getAdvance();
                    maxAscent = Math.max(maxAscent, layout.getAscent());
                    maxDescent = Math.max(maxDescent, layout.getDescent() + layout.getLeading());
                } else {
                    lineComplete = true;
                }
                lineContainsText = true;
                if (measurer.getPosition() == tabLocations[currentTab] + 1) {
                    ++currentTab;
                }
                if (measurer.getPosition() == styledText.getEndIndex()) {
                    lineComplete = true;
                } else if (tabStops.length == 0 || horizontalPos >= tabStops[tabStops.length - 1]) {
                    lineComplete = true;
                }
                if (lineComplete) continue;
                int j = 0;
                while (horizontalPos >= tabStops[j]) {
                    ++j;
                }
                horizontalPos = tabStops[j];
            }
            if (first == layouts.size() - 1) {
                switch (textAlignment) {
                    case RIGHT: {
                        penPositions.set(first, Float.valueOf(rightMargin - ((TextLayout)layouts.get(first)).getVisibleAdvance() - 1.0f));
                        break;
                    }
                    case CENTER: {
                        penPositions.set(first, Float.valueOf((rightMargin - 1.0f - leftMargin) * 0.5f + leftMargin));
                        break;
                    }
                    case JUSTIFY: {
                        break;
                    }
                }
            }
            verticalPos += maxAscent;
            Iterator positionEnum = penPositions.iterator();
            styledText.first();
            for (TextLayout nextLayout : layouts) {
                float nextPosition = ((Float)positionEnum.next()).floatValue();
                w.writeStartElement("tspan");
                int characterCount = nextLayout.getCharacterCount();
                w.writeAttribute("x", this.nbf.toString((Object)Float.valueOf(nextPosition)));
                w.writeAttribute("y", this.nbf.toString((Object)Float.valueOf(verticalPos)));
                w.writeCharacters(paragraph.substring(textIndex, textIndex + characterCount));
                w.writeEndElement();
                Rectangle2D layoutBounds = nextLayout.getBounds();
                paragraphBounds.add(new Rectangle2D.Double(layoutBounds.getX() + (double)nextPosition, layoutBounds.getY() + (double)verticalPos, layoutBounds.getWidth(), layoutBounds.getHeight()));
                textIndex += characterCount;
            }
            paragraphBounds.add(paragraphBounds.getX(), verticalPos += maxDescent + lineSpacing);
        }
        return paragraphBounds;
    }

    private void drawText(@NonNull XMLStreamWriter w, @Nullable String str, @NonNull Bounds textRect, @NonNull javafx.scene.text.Font tfont, int tabSize, boolean isUnderlined, boolean isStrikethrough, @NonNull TextAlignment textAlignment, double lineSpacing) throws XMLStreamException {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        Font font = new Font(tfont.getName(), 0, (int)tfont.getSize()).deriveFont((float)tfont.getSize());
        float leftMargin = (float)textRect.getMinX();
        float rightMargin = (float)Math.max((double)leftMargin, textRect.getMinX() + textRect.getWidth());
        float verticalPos = (float)textRect.getMinY();
        float maxVerticalPos = (float)(textRect.getMinY() + textRect.getHeight());
        if (leftMargin < rightMargin) {
            float tabWidth = (float)((double)tabSize * font.getStringBounds("m", frc).getWidth());
            float[] tabStops = new float[(int)(textRect.getWidth() / (double)tabWidth)];
            for (int i = 0; i < tabStops.length; ++i) {
                tabStops[i] = (float)(textRect.getMinX() + (double)((int)(tabWidth * (float)(i + 1))));
            }
            if (str != null) {
                String[] paragraphs = str.split("\n");
                for (int i = 0; i < paragraphs.length; ++i) {
                    if (paragraphs[i].isEmpty()) {
                        paragraphs[i] = " ";
                    }
                    AttributedString as = new AttributedString(paragraphs[i]);
                    as.addAttribute(TextAttribute.FONT, font);
                    if (isUnderlined) {
                        as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                    }
                    if (isStrikethrough) {
                        as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                    }
                    int tabCount = paragraphs[i].split("\t").length - 1;
                    Rectangle2D.Double paragraphBounds = this.drawParagraph(w, frc, paragraphs[i], as.getIterator(), verticalPos, maxVerticalPos, leftMargin, rightMargin, tabStops, tabCount, textAlignment, (float)lineSpacing);
                    verticalPos = (float)(paragraphBounds.y + paragraphBounds.height + lineSpacing);
                    if (verticalPos > maxVerticalPos) break;
                }
            }
        }
    }

    protected abstract List<String> getAdditionalNodeClasses(@NonNull Node var1);

    protected abstract String getSvgBaseProfile();

    protected abstract String getSvgVersion();

    private void initIdFactoryRecursively(@NonNull Node node) {
        String id = node.getId();
        if (id != null && this.idFactory.getObject(id) == null) {
            this.idFactory.putIdAndObject(id, (Object)node);
        } else {
            this.idFactory.createId((Object)node, node.getTypeSelector().toLowerCase());
        }
        if (node instanceof Parent) {
            Parent pp = (Parent)node;
            for (Node child : pp.getChildrenUnmodifiable()) {
                this.initIdFactoryRecursively(child);
            }
        }
    }

    public boolean isExportInvisibleElements() {
        return (Boolean)this.getNonNull((NonNullMapAccessor)EXPORT_INVISIBLE_ELEMENTS_KEY);
    }

    public void setExportInvisibleElements(boolean newValue) {
        this.setNonNull((NonNullMapAccessor)EXPORT_INVISIBLE_ELEMENTS_KEY, newValue);
    }

    public boolean isRelativizePaths() {
        return (Boolean)this.getNonNull((NonNullMapAccessor)RELATIVIZE_PATHS_KEY);
    }

    public void setRelativizePaths(boolean relativizePaths) {
        this.setNonNull((NonNullMapAccessor)RELATIVIZE_PATHS_KEY, relativizePaths);
    }

    public boolean isConvertTextToPath() {
        return (Boolean)this.getNonNull((NonNullMapAccessor)CONVERT_TEXT_TO_PATH_KEY);
    }

    public void setConvertTextToPath(boolean newValue) {
        this.setNonNull((NonNullMapAccessor)CONVERT_TEXT_TO_PATH_KEY, newValue);
    }

    private boolean shouldWriteDefs(Node drawingNode) {
        return this.shouldWriteDefsRecursively(drawingNode);
    }

    private boolean shouldWriteDefsRecursively(Node node) {
        if (this.shouldWriteNode(node)) {
            if (node.getClip() != null) {
                return true;
            }
            if (node instanceof Shape) {
                Shape shape = (Shape)node;
                Paint fill = shape.getFill();
                Paint stroke = shape.getStroke();
                return fill instanceof LinearGradient || fill instanceof RadialGradient || stroke instanceof LinearGradient || stroke instanceof RadialGradient;
            }
            if (node instanceof Parent) {
                Parent pp = (Parent)node;
                for (Node child : pp.getChildrenUnmodifiable()) {
                    if (!this.shouldWriteDefsRecursively(child)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldWriteNode(@NonNull Node node) {
        if (this.skipKey != null && Objects.equals(Boolean.TRUE, node.getProperties().get(this.skipKey))) {
            return false;
        }
        if (!this.isExportInvisibleElements()) {
            if (!node.isVisible()) {
                return false;
            }
            if (node instanceof Shape) {
                Shape s = (Shape)node;
                if ((s.getFill() == null || s.getFill() instanceof Color && ((Color)s.getFill()).getOpacity() == 0.0) && (s.getStroke() == null || s.getStroke() instanceof Color && ((Color)s.getStroke()).getOpacity() == 0.0)) {
                    return false;
                }
                Node node2 = node;
                Objects.requireNonNull(node2);
                Node node3 = node2;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Path.class, Polyline.class, Polygon.class}, (Object)node3, n)) {
                    case 0: {
                        Path p = (Path)node3;
                        return !p.getElements().isEmpty();
                    }
                    case 1: {
                        Polyline p = (Polyline)node3;
                        return !p.getPoints().isEmpty();
                    }
                    case 2: {
                        Polygon p = (Polygon)node3;
                        return !p.getPoints().isEmpty();
                    }
                }
            } else if (node instanceof Group) {
                Group g = (Group)node;
                return !g.getChildren().isEmpty();
            }
        }
        return true;
    }

    public Document toDocument(@NonNull Node drawingNode, @Nullable CssDimension2D size) throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            Document doc = builder.newDocument();
            DOMResult result = new DOMResult(doc);
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = xmlOutputFactory.createXMLStreamWriter(result);
            this.writeDocument(w, drawingNode, size);
            w.close();
            return doc;
        }
        catch (ParserConfigurationException | XMLStreamException e) {
            throw new IOException("Error writing to DOM.", e);
        }
    }

    public void write(@NonNull OutputStream out, @NonNull Node drawingNode, @Nullable CssDimension2D size) throws IOException {
        IndentingXMLStreamWriter w = new IndentingXMLStreamWriter(out);
        try {
            this.writeDocument((XMLStreamWriter)w, drawingNode, size);
            w.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to Writer.", e);
        }
    }

    public void write(@NonNull Writer out, @NonNull Node drawingNode, @Nullable CssDimension2D size) throws IOException {
        IndentingXMLStreamWriter w = new IndentingXMLStreamWriter(out);
        try {
            this.writeDocument((XMLStreamWriter)w, drawingNode, size);
            w.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException("Error writing to Writer.", e);
        }
    }

    private void writeArcStartElement(@NonNull XMLStreamWriter w, @NonNull Arc node) throws XMLStreamException {
        w.writeStartElement("path");
        StringBuilder buf = new StringBuilder();
        double centerX = node.getCenterX();
        double centerY = node.getCenterY();
        double radiusX = node.getRadiusX();
        double radiusY = node.getRadiusY();
        double startAngle = Math.toRadians(-node.getStartAngle());
        double endAngle = Math.toRadians(-node.getStartAngle() - node.getLength());
        double length = node.getLength();
        double startX = radiusX * Math.cos(startAngle);
        double startY = radiusY * Math.sin(startAngle);
        double endX = centerX + radiusX * Math.cos(endAngle);
        double endY = centerY + radiusY * Math.sin(endAngle);
        int xAxisRot = 0;
        boolean largeArc = length > 180.0;
        boolean sweep = length < 0.0;
        buf.append('M').append(this.nb.toString((Object)centerX)).append(',').append(this.nb.toString((Object)centerY)).append(' ');
        if (ArcType.ROUND == node.getType()) {
            buf.append('l').append(startX).append(',').append(startY).append(' ');
        }
        buf.append('A').append(this.nb.toString((Object)radiusX)).append(',').append(this.nb.toString((Object)radiusY)).append(',').append(this.nbi.toString((Object)xAxisRot)).append(',').append(largeArc ? (char)'1' : '0').append(',').append(sweep ? (char)'1' : '0').append(',').append(this.nb.toString((Object)endX)).append(',').append(this.nb.toString((Object)endY)).append(',');
        if (ArcType.CHORD == node.getType() || ArcType.ROUND == node.getType()) {
            buf.append('Z');
        }
        w.writeAttribute("d", buf.toString());
    }

    private void writeCircleStartElement(@NonNull XMLStreamWriter w, @NonNull Circle node) throws XMLStreamException {
        w.writeStartElement("circle");
        if (node.getCenterX() != 0.0) {
            w.writeAttribute("cx", this.nb.toString((Object)node.getCenterX()));
        }
        if (node.getCenterY() != 0.0) {
            w.writeAttribute("cy", this.nb.toString((Object)node.getCenterY()));
        }
        if (node.getRadius() != 0.0) {
            w.writeAttribute("r", this.nb.toString((Object)node.getRadius()));
        }
    }

    private void writeClassAttribute(@NonNull XMLStreamWriter w, @NonNull Node node) throws XMLStreamException {
        ArrayList<String> styleClass = new ArrayList<String>((Collection<String>)node.getStyleClass());
        styleClass.addAll(this.getAdditionalNodeClasses(node));
        if (!styleClass.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (String clazz : styleClass) {
                if (!buf.isEmpty()) {
                    buf.append(' ');
                }
                buf.append(clazz);
            }
            w.writeAttribute("class", buf.toString());
        }
    }

    protected abstract void writeClipAttributes(@NonNull XMLStreamWriter var1, @NonNull Node var2) throws XMLStreamException;

    protected abstract void writeClipPathDefs(XMLStreamWriter var1, Node var2) throws XMLStreamException, IOException;

    protected abstract void writeCompositingAttributes(@NonNull XMLStreamWriter var1, @NonNull Node var2) throws XMLStreamException;

    private void writeCubicCurveStartElement(@NonNull XMLStreamWriter w, @NonNull CubicCurve node) throws XMLStreamException {
        w.writeStartElement("path");
        StringBuilder buf = new StringBuilder();
        buf.append('M').append(this.nb.toString((Object)node.getStartX())).append(',').append(this.nb.toString((Object)node.getStartY())).append(' ').append('C').append(this.nb.toString((Object)node.getControlX1())).append(',').append(this.nb.toString((Object)node.getControlY1())).append(',').append(this.nb.toString((Object)node.getControlX2())).append(',').append(this.nb.toString((Object)node.getControlY2())).append(',').append(this.nb.toString((Object)node.getEndX())).append(',').append(this.nb.toString((Object)node.getEndY()));
        w.writeAttribute("d", buf.substring(0));
    }

    private void writeDefs(XMLStreamWriter w, Node drawingNode) throws XMLStreamException, IOException {
        w.writeStartElement("defs");
        this.writeDefsRecursively(w, drawingNode);
        w.writeEndElement();
    }

    private void writeDefsRecursively(XMLStreamWriter w, Node node) throws IOException, XMLStreamException {
        if (!this.shouldWriteNode(node)) {
            return;
        }
        this.writeClipPathDefs(w, node);
        if (node instanceof Shape) {
            Shape shape = (Shape)node;
            this.writePaintDefs(w, shape.getFill());
            this.writePaintDefs(w, shape.getStroke());
        }
        if (node instanceof Parent) {
            Parent pp = (Parent)node;
            for (Node child : pp.getChildrenUnmodifiable()) {
                this.writeDefsRecursively(w, child);
            }
        }
    }

    protected void writeDescElement(@NonNull XMLStreamWriter w, @NonNull Node node) throws XMLStreamException {
        String desc;
        Object descObj = node.getProperties().get((Object)"desc");
        if (descObj instanceof String && !(desc = ((String)descObj).trim()).isEmpty()) {
            w.writeStartElement("desc");
            w.writeCharacters(desc);
            w.writeEndElement();
        }
    }

    private void writeDocument(XMLStreamWriter w, Node drawingNode, CssDimension2D size) throws XMLStreamException, IOException {
        this.idFactory.reset();
        this.initIdFactoryRecursively(drawingNode);
        w.writeStartDocument();
        w.setDefaultNamespace(SVG_NS);
        w.writeStartElement("svg");
        w.writeDefaultNamespace(SVG_NS);
        w.writeNamespace(XLINK_PREFIX, XLINK_NS);
        this.writeDocumentElementAttributes(w, drawingNode, size);
        if (this.shouldWriteDefs(drawingNode)) {
            this.writeDefs(w, drawingNode);
        }
        this.writeNodeRecursively(w, drawingNode, 1);
        w.writeEndElement();
        w.writeEndDocument();
    }

    protected abstract void writeDocumentElementAttributes(@NonNull XMLStreamWriter var1, Node var2, @Nullable CssDimension2D var3) throws XMLStreamException;

    private void writeEllipseStartElement(@NonNull XMLStreamWriter w, @NonNull Ellipse node) throws XMLStreamException {
        w.writeStartElement("ellipse");
        if (node.getCenterX() != 0.0) {
            w.writeAttribute("cx", this.nb.toString((Object)node.getCenterX()));
        }
        if (node.getCenterY() != 0.0) {
            w.writeAttribute("cy", this.nb.toString((Object)node.getCenterY()));
        }
        if (node.getRadiusX() != 0.0) {
            w.writeAttribute("rx", this.nb.toString((Object)node.getRadiusX()));
        }
        if (node.getRadiusY() != 0.0) {
            w.writeAttribute("ry", this.nb.toString((Object)node.getRadiusY()));
        }
    }

    private void writeFillAttributes(@NonNull XMLStreamWriter w, @NonNull Shape shape) throws XMLStreamException {
        FillRule fillRule;
        Paint fill = shape.getFill();
        String id = this.idFactory.getId((Object)fill);
        double fillOpacity = shape.getOpacity();
        if (id != null) {
            w.writeAttribute("fill", "url(#" + id + ")");
        } else {
            Color c;
            w.writeAttribute("fill", this.paintConverter.toString((Object)fill));
            if (fill instanceof Color && !(c = (Color)fill).isOpaque()) {
                fillOpacity *= c.getOpacity();
            }
        }
        if (fillOpacity != 1.0) {
            w.writeAttribute("fill-opacity", this.nb.toString((Object)fillOpacity));
        }
        if (shape instanceof Path) {
            Path path = (Path)shape;
            fillRule = path.getFillRule();
        } else if (shape instanceof SVGPath) {
            SVGPath path = (SVGPath)shape;
            fillRule = path.getFillRule();
        } else {
            fillRule = FillRule.NON_ZERO;
        }
        switch (fillRule) {
            case EVEN_ODD: {
                w.writeAttribute("fill-rule", "evenodd");
                break;
            }
        }
    }

    protected void writeGroupStartElement(@NonNull XMLStreamWriter w, @NonNull Group node) throws XMLStreamException {
        w.writeStartElement("g");
        this.writeClipAttributes(w, (Node)node);
    }

    protected void writeIdAttribute(@NonNull XMLStreamWriter w, @NonNull Node node) throws XMLStreamException {
        String id = node.getId();
        if (id != null && !id.isEmpty()) {
            w.writeAttribute("id", id);
        }
    }

    private void writeImageViewStartElement(@NonNull XMLStreamWriter w, @NonNull ImageView node) throws IOException, XMLStreamException {
        w.writeStartElement("image");
        w.writeAttribute("x", this.nb.toString((Object)node.getX()));
        w.writeAttribute("y", this.nb.toString((Object)node.getY()));
        w.writeAttribute("width", this.nb.toString((Object)node.getFitWidth()));
        w.writeAttribute("height", this.nb.toString((Object)node.getFitHeight()));
        w.writeAttribute("preserveAspectRatio", node.isPreserveRatio() ? "xMidYMid" : "none");
        URI uri = (URI)node.getProperties().get(this.imageUriKey);
        Object href = null;
        if (uri != null) {
            href = this.idFactory.relativize(uri).toString();
        } else if (node.getImage() != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BufferedImage im = BitmapExportOutputFormat.fromFXImage((Image)node.getImage(), null);
            if (im == null) {
                throw new IOException("Could not create an AWT image.");
            }
            ImageIO.write((RenderedImage)im, "PNG", bout);
            bout.close();
            byte[] imageData = bout.toByteArray();
            href = "data:image;base64," + Base64.getEncoder().encodeToString(imageData);
        }
        if (href != null) {
            w.writeAttribute(XLINK_PREFIX, XLINK_NS, "href", (String)href);
        }
    }

    private void writeLineStartElement(@NonNull XMLStreamWriter w, @NonNull Line node) throws XMLStreamException {
        w.writeStartElement("line");
        if (node.getStartX() != 0.0) {
            w.writeAttribute("x1", this.nb.toString((Object)node.getStartX()));
        }
        if (node.getStartY() != 0.0) {
            w.writeAttribute("y1", this.nb.toString((Object)node.getStartY()));
        }
        if (node.getEndX() != 0.0) {
            w.writeAttribute("x2", this.nb.toString((Object)node.getEndX()));
        }
        if (node.getEndY() != 0.0) {
            w.writeAttribute("y2", this.nb.toString((Object)node.getEndY()));
        }
    }

    private void writeLinearGradientDef(@NonNull XMLStreamWriter w, LinearGradient g) throws IOException, XMLStreamException {
        String id = this.idFactory.createId((Object)g, "linearGradient");
        w.writeStartElement("linearGradient");
        w.writeAttribute("id", id);
        if (g.isProportional()) {
            w.writeAttribute("x1", this.nb.toString((Object)(g.getStartX() * 100.0)) + "%");
            w.writeAttribute("y1", this.nb.toString((Object)(g.getStartY() * 100.0)) + "%");
            w.writeAttribute("x2", this.nb.toString((Object)(g.getEndX() * 100.0)) + "%");
            w.writeAttribute("y2", this.nb.toString((Object)(g.getEndY() * 100.0)) + "%");
            w.writeAttribute("gradientUnits", "objectBoundingBox");
        } else {
            w.writeAttribute("x1", this.nb.toString((Object)g.getStartX()));
            w.writeAttribute("y1", this.nb.toString((Object)g.getStartY()));
            w.writeAttribute("x2", this.nb.toString((Object)g.getEndX()));
            w.writeAttribute("y2", this.nb.toString((Object)g.getEndY()));
            w.writeAttribute("gradientUnits", "userSpaceOnUse");
        }
        switch (g.getCycleMethod()) {
            case NO_CYCLE: {
                w.writeAttribute("spreadMethod", "pad");
                break;
            }
            case REFLECT: {
                w.writeAttribute("spreadMethod", "reflect");
                break;
            }
            case REPEAT: {
                w.writeAttribute("spreadMethod", "repeat");
                break;
            }
            default: {
                throw new IOException("unsupported cycle method:" + String.valueOf(g.getCycleMethod()));
            }
        }
        for (Stop s : g.getStops()) {
            w.writeStartElement("stop");
            w.writeAttribute("offset", this.nb.toString((Object)(s.getOffset() * 100.0)) + "%");
            Color c = s.getColor();
            w.writeAttribute("stop-color", this.paintConverter.toString((Object)c));
            if (!c.isOpaque()) {
                w.writeAttribute("stop-opacity", this.nb.toString((Object)c.getOpacity()));
            }
            w.writeEndElement();
        }
        w.writeEndElement();
    }

    private void writeMetadataChildElements(@NonNull XMLStreamWriter w, Node node) throws XMLStreamException {
        this.writeTitleElement(w, node);
        this.writeDescElement(w, node);
    }

    protected void writeNodeRecursively(@NonNull XMLStreamWriter w, @NonNull Node node, int depth) throws IOException, XMLStreamException {
        if (!this.shouldWriteNode(node)) {
            return;
        }
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Shape.class, Group.class, Region.class, ImageView.class}, (Object)node3, n)) {
            case 0: {
                Shape shape = (Shape)node3;
                this.writeShapeStartElement(w, shape);
                this.writeFillAttributes(w, shape);
                if (shape.getStrokeType() == StrokeType.CENTERED) {
                    this.writeStrokeAttributes(w, (Shape)node);
                }
                this.writeClipAttributes(w, node);
                break;
            }
            case 1: {
                Group group = (Group)node3;
                this.writeGroupStartElement(w, group);
                break;
            }
            case 2: {
                Region region = (Region)node3;
                this.writeRegionStartElement(w, region);
                break;
            }
            case 3: {
                ImageView imageView = (ImageView)node3;
                this.writeImageViewStartElement(w, imageView);
                break;
            }
            default: {
                throw new IOException("not yet implemented for " + String.valueOf(node));
            }
        }
        this.writeStyleAttributes(w, node);
        this.writeTransformAttributes(w, node);
        this.writeCompositingAttributes(w, node);
        this.writeMetadataChildElements(w, node);
        if (node instanceof Shape) {
            this.writeShapeChildElements(w, (Shape)node);
        } else if (node instanceof Region) {
            this.writeRegionChildElements(w, (Region)node);
        }
        if (node instanceof Parent) {
            Parent pp = (Parent)node;
            for (Node child : pp.getChildrenUnmodifiable()) {
                this.writeNodeRecursively(w, child, depth + 1);
            }
        }
        w.writeEndElement();
        if (node instanceof Shape && ((Shape)node).getStrokeType() != StrokeType.CENTERED) {
            this.writeStrokedShapeElement(w, (Shape)node);
        }
    }

    private void writePaintDefs(@NonNull XMLStreamWriter w, Paint paint) throws IOException, XMLStreamException {
        if (this.idFactory.getId((Object)paint) == null) {
            if (paint instanceof LinearGradient) {
                LinearGradient g = (LinearGradient)paint;
                this.writeLinearGradientDef(w, g);
            } else if (paint instanceof RadialGradient) {
                RadialGradient g = (RadialGradient)paint;
                this.writeRadialGradientDef(w, g);
            }
        }
    }

    protected void writePathStartElement(@NonNull XMLStreamWriter w, @NonNull Path node) throws XMLStreamException {
        w.writeStartElement("path");
        String d = this.isRelativizePaths() ? SvgPaths.awtPathIteratorToDoubleRelativeSvgString((PathIterator)FXShapes.fxPathELementsToAwtShape((Iterable)node.getElements(), (FillRule)node.getFillRule()).getPathIterator(null)) : FXSvgPaths.pathElementsToDoubleSvgString((Iterable)node.getElements());
        w.writeAttribute("d", d);
    }

    protected void writeStrokedShapeElement(@NonNull XMLStreamWriter w, @NonNull Shape fxShape) throws XMLStreamException, IOException {
        w.writeStartElement("path");
        java.awt.Shape shape = FXShapes.fxShapeToAwtShape((Shape)fxShape);
        int cap = switch (fxShape.getStrokeLineCap()) {
            case StrokeLineCap.SQUARE -> 2;
            default -> 0;
            case StrokeLineCap.ROUND -> 1;
        };
        int join = switch (fxShape.getStrokeLineJoin()) {
            default -> 0;
            case StrokeLineJoin.BEVEL -> 2;
            case StrokeLineJoin.ROUND -> 1;
        };
        ObservableList strokeDashArray = fxShape.getStrokeDashArray();
        float[] dashes = new float[strokeDashArray.size()];
        for (int i = 0; i < strokeDashArray.size(); ++i) {
            dashes[i] = ((Double)strokeDashArray.get(i)).floatValue();
        }
        java.awt.Shape strokedShape = new BasicStroke((float)(fxShape.getStrokeWidth() * (double)(fxShape.getStrokeType() == StrokeType.CENTERED ? 1 : 2)), cap, join, (float)fxShape.getStrokeMiterLimit(), dashes.length == 0 ? null : dashes, (float)fxShape.getStrokeDashOffset()).createStrokedShape(shape);
        Area area = new Area(strokedShape);
        switch (fxShape.getStrokeType()) {
            case INSIDE: {
                area.intersect(new Area(shape));
                break;
            }
            case OUTSIDE: {
                area.subtract(new Area(shape));
                break;
            }
        }
        String d = this.isRelativizePaths() ? SvgPaths.awtPathIteratorToDoubleRelativeSvgString((PathIterator)area.getPathIterator(null)) : SvgPaths.awtPathIteratorToDoubleSvgString((PathIterator)area.getPathIterator(null));
        w.writeAttribute("d", d);
        this.writeStrokedShapeAttributes(w, fxShape);
        w.writeEndElement();
    }

    private void writePolygonStartElement(@NonNull XMLStreamWriter w, @NonNull Polygon node) throws XMLStreamException {
        w.writeStartElement("polygon");
        StringBuilder buf = new StringBuilder();
        ObservableList ps = node.getPoints();
        int n = ps.size();
        for (int i = 0; i < n; i += 2) {
            if (i != 0) {
                buf.append(' ');
            }
            buf.append(this.nb.toString((Object)((Double)ps.get(i)))).append(',').append(this.nb.toString((Object)((Double)ps.get(i + 1))));
        }
        w.writeAttribute("points", buf.toString());
    }

    private void writePolylineStartElement(@NonNull XMLStreamWriter w, @NonNull Polyline node) throws XMLStreamException {
        w.writeStartElement("polyline");
        StringBuilder buf = new StringBuilder();
        ObservableList ps = node.getPoints();
        int n = ps.size();
        for (int i = 0; i < n; i += 2) {
            if (i != 0) {
                buf.append(' ');
            }
            buf.append(this.nb.toString((Object)((Double)ps.get(i)))).append(',').append(this.nb.toString((Object)((Double)ps.get(i + 1))));
        }
        w.writeAttribute("points", buf.toString());
    }

    private void writeQuadCurveStartElement(@NonNull XMLStreamWriter w, @NonNull QuadCurve node) throws XMLStreamException {
        w.writeStartElement("path");
        StringBuilder buf = new StringBuilder();
        buf.append('M').append(this.nb.toString((Object)node.getStartX())).append(',').append(this.nb.toString((Object)node.getStartY())).append(' ').append('Q').append(this.nb.toString((Object)node.getControlX())).append(',').append(this.nb.toString((Object)node.getControlY())).append(',').append(this.nb.toString((Object)node.getEndX())).append(',').append(this.nb.toString((Object)node.getEndY()));
        w.writeAttribute("d", buf.substring(0));
    }

    private void writeRadialGradientDef(@NonNull XMLStreamWriter w, RadialGradient g) throws IOException, XMLStreamException {
        String id = this.idFactory.createId((Object)g, "radialGradient");
        w.writeStartElement("radialGradient");
        w.writeAttribute("id", id);
        if (g.isProportional()) {
            w.writeAttribute("cx", this.nb.toString((Object)(g.getCenterX() * 100.0)) + "%");
            w.writeAttribute("cy", this.nb.toString((Object)(g.getCenterY() * 100.0)) + "%");
            w.writeAttribute("r", this.nb.toString((Object)(g.getRadius() * 100.0)) + "%");
            w.writeAttribute("fx", this.nb.toString((Object)((g.getCenterX() + Math.cos(g.getFocusAngle() / 180.0 * Math.PI) * g.getFocusDistance() * g.getRadius()) * 100.0)) + "%");
            w.writeAttribute("fy", this.nb.toString((Object)((g.getCenterY() + Math.sin(g.getFocusAngle() / 180.0 * Math.PI) * g.getFocusDistance() * g.getRadius()) * 100.0)) + "%");
            w.writeAttribute("gradientUnits", "objectBoundingBox");
        } else {
            w.writeAttribute("cx", this.nb.toString((Object)g.getCenterX()));
            w.writeAttribute("cy", this.nb.toString((Object)g.getCenterY()));
            w.writeAttribute("r", this.nb.toString((Object)g.getRadius()));
            w.writeAttribute("fx", this.nb.toString((Object)(g.getCenterX() + Math.cos(g.getFocusAngle() / 180.0 * Math.PI) * g.getFocusDistance() * g.getRadius())));
            w.writeAttribute("fy", this.nb.toString((Object)(g.getCenterY() + Math.sin(g.getFocusAngle() / 180.0 * Math.PI) * g.getFocusDistance() * g.getRadius())));
            w.writeAttribute("gradientUnits", "userSpaceOnUse");
        }
        switch (g.getCycleMethod()) {
            case NO_CYCLE: {
                w.writeAttribute("spreadMethod", "pad");
                break;
            }
            case REFLECT: {
                w.writeAttribute("spreadMethod", "reflect");
                break;
            }
            case REPEAT: {
                w.writeAttribute("spreadMethod", "repeat");
                break;
            }
            default: {
                throw new IOException("unsupported cycle method:" + String.valueOf(g.getCycleMethod()));
            }
        }
        for (Stop s : g.getStops()) {
            w.writeStartElement("stop");
            w.writeAttribute("offset", this.nb.toString((Object)(s.getOffset() * 100.0)) + "%");
            Color c = s.getColor();
            w.writeAttribute("stop-color", this.paintConverter.toString((Object)c));
            if (!c.isOpaque()) {
                w.writeAttribute("stop-opacity", this.nb.toString((Object)c.getOpacity()));
            }
            w.writeEndElement();
        }
        w.writeEndElement();
    }

    private void writeRectangleStartElement(@NonNull XMLStreamWriter w, @NonNull Rectangle node) throws XMLStreamException {
        if (!node.getStrokeDashArray().isEmpty()) {
            // empty if block
        }
        w.writeStartElement("rect");
        if (node.getX() != 0.0) {
            w.writeAttribute("x", this.nb.toString((Object)node.getX()));
        }
        if (node.getY() != 0.0) {
            w.writeAttribute("y", this.nb.toString((Object)node.getY()));
        }
        if (node.getWidth() != 0.0) {
            w.writeAttribute("width", this.nb.toString((Object)node.getWidth()));
        }
        if (node.getHeight() != 0.0) {
            w.writeAttribute("height", this.nb.toString((Object)node.getHeight()));
        }
        if (node.getArcWidth() != 0.0) {
            w.writeAttribute("rx", this.nb.toString((Object)(node.getArcWidth() * 0.5)));
        }
        if (node.getArcHeight() != 0.0) {
            w.writeAttribute("ry", this.nb.toString((Object)(node.getArcHeight() * 0.5)));
        }
    }

    private void writeRegionStartElement(@NonNull XMLStreamWriter w, @NonNull Region region) throws XMLStreamException {
        w.writeStartElement("g");
    }

    private void writeRegionChildElements(@NonNull XMLStreamWriter w, @NonNull Region region) throws IOException, XMLStreamException {
        double x = region.getLayoutX();
        double y = region.getLayoutY();
        double width = region.getWidth();
        double height = region.getHeight();
        if (region.getBackground() != null && !region.getBackground().isEmpty() || region.getBorder() != null && !region.getBorder().isEmpty()) {
            CornerRadii radii;
            Bounds sb;
            Shape s = region.getShape();
            Bounds bounds = sb = s != null ? s.getLayoutBounds() : null;
            if (region.getBackground() != null) {
                for (BackgroundFill bgf : region.getBackground().getFills()) {
                    Shape bgs;
                    Insets insets;
                    Color fill = bgf.getFill() == null ? Color.TRANSPARENT : bgf.getFill();
                    radii = bgf.getRadii() == null ? CornerRadii.EMPTY : bgf.getRadii();
                    Insets insets2 = insets = bgf.getInsets() == null ? Insets.EMPTY : bgf.getInsets();
                    if (s != null) {
                        if (region.isScaleShape()) {
                            java.awt.Shape awtShape = FXShapes.fxShapeToAwtShape((Shape)s);
                            Translate tx = Transform.translate((double)(-sb.getMinX()), (double)(-sb.getMinY()));
                            tx = FXTransforms.concat((Transform[])new Transform[]{tx, Transform.translate((double)(x + insets.getLeft()), (double)(y + insets.getTop()))});
                            tx = FXTransforms.concat((Transform[])new Transform[]{tx, Transform.scale((double)((width - insets.getLeft() - insets.getRight()) / sb.getWidth()), (double)((height - insets.getTop() - insets.getBottom()) / sb.getHeight()))});
                            bgs = FXShapes.awtShapeToFXShape((java.awt.Shape)awtShape, (Transform)tx);
                        } else {
                            bgs = s;
                        }
                    } else {
                        if (radii != CornerRadii.EMPTY) {
                            throw new IOException("radii not yet implemented");
                        }
                        bgs = new Rectangle(x + insets.getLeft(), y + insets.getTop(), width - insets.getLeft() - insets.getRight(), height - insets.getTop() - insets.getBottom());
                    }
                    bgs.setFill((Paint)fill);
                    this.writeShapeStartElement(w, bgs);
                    this.writeFillAttributes(w, bgs);
                    w.writeAttribute("stroke", "none");
                    w.writeEndElement();
                }
                if (!region.getBackground().getImages().isEmpty()) {
                    throw new IOException("background image not yet implemented");
                }
            }
            if (region.getBorder() != null) {
                if (region.getBorder().getImages().isEmpty() || s == null) {
                    for (BorderStroke bs : region.getBorder().getStrokes()) {
                        Shape bgs;
                        Insets insets = bs.getInsets();
                        CornerRadii cornerRadii = radii = bs.getRadii() == null ? CornerRadii.EMPTY : bs.getRadii();
                        if (s != null) {
                            if (region.isScaleShape()) {
                                java.awt.Shape awtShape = FXShapes.fxShapeToAwtShape((Shape)s);
                                Translate tx = Transform.translate((double)(-sb.getMinX()), (double)(-sb.getMinY()));
                                tx = FXTransforms.concat((Transform[])new Transform[]{tx, Transform.translate((double)(x + insets.getLeft()), (double)(y + insets.getTop()))});
                                tx = FXTransforms.concat((Transform[])new Transform[]{tx, Transform.scale((double)((width - insets.getLeft() - insets.getRight()) / sb.getWidth()), (double)((height - insets.getTop() - insets.getBottom()) / sb.getHeight()))});
                                bgs = FXShapes.awtShapeToFXShape((java.awt.Shape)awtShape, (Transform)tx);
                            } else {
                                bgs = s;
                            }
                        } else {
                            if (radii != CornerRadii.EMPTY) {
                                throw new IOException("radii not yet implemented");
                            }
                            bgs = new Rectangle(x + insets.getLeft(), y + insets.getTop(), width - insets.getLeft() - insets.getRight(), height - insets.getTop() - insets.getBottom());
                        }
                        this.writeShapeStartElement(w, bgs);
                        this.writeBorderStrokeAttributes(w, bs);
                        w.writeAttribute("fill", "none");
                        w.writeEndElement();
                    }
                }
                if (s != null && !region.getBorder().getImages().isEmpty()) {
                    throw new IOException("border image not yet implemented");
                }
            }
        }
    }

    private void writeSVGPathStartElement(@NonNull XMLStreamWriter w, @NonNull SVGPath node) throws XMLStreamException {
        w.writeStartElement("path");
        w.writeAttribute("d", node.getContent());
        switch (node.getFillRule()) {
            case NON_ZERO: {
                break;
            }
            case EVEN_ODD: {
                w.writeAttribute("fill-rule", "evenodd");
            }
        }
    }

    private void writeShapeChildElements(@NonNull XMLStreamWriter w, Shape node) throws XMLStreamException {
        if (node instanceof Text && !this.isConvertTextToPath()) {
            this.writeTextChildElements(w, (Text)node);
        }
    }

    private void writeShapeStartElement(@NonNull XMLStreamWriter w, Shape node) throws IOException, XMLStreamException {
        Shape shape = node;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arc.class, Circle.class, CubicCurve.class, Ellipse.class, Line.class, Path.class, Polygon.class, Polyline.class, QuadCurve.class, Rectangle.class, SVGPath.class, Text.class}, (Object)shape, n)) {
            case 0: {
                Arc arc = (Arc)shape;
                this.writeArcStartElement(w, arc);
                break;
            }
            case 1: {
                Circle circle = (Circle)shape;
                this.writeCircleStartElement(w, circle);
                break;
            }
            case 2: {
                CubicCurve cubicCurve = (CubicCurve)shape;
                this.writeCubicCurveStartElement(w, cubicCurve);
                break;
            }
            case 3: {
                Ellipse ellipse = (Ellipse)shape;
                this.writeEllipseStartElement(w, ellipse);
                break;
            }
            case 4: {
                Line line = (Line)shape;
                this.writeLineStartElement(w, line);
                break;
            }
            case 5: {
                Path path = (Path)shape;
                this.writePathStartElement(w, path);
                break;
            }
            case 6: {
                Polygon polygon = (Polygon)shape;
                this.writePolygonStartElement(w, polygon);
                break;
            }
            case 7: {
                Polyline polyline = (Polyline)shape;
                this.writePolylineStartElement(w, polyline);
                break;
            }
            case 8: {
                QuadCurve quadCurve = (QuadCurve)shape;
                this.writeQuadCurveStartElement(w, quadCurve);
                break;
            }
            case 9: {
                Rectangle rectangle = (Rectangle)shape;
                this.writeRectangleStartElement(w, rectangle);
                break;
            }
            case 10: {
                SVGPath svgPath = (SVGPath)shape;
                this.writeSVGPathStartElement(w, svgPath);
                break;
            }
            case 11: {
                Text text = (Text)shape;
                this.writeTextStartElement(w, text);
                break;
            }
            default: {
                throw new IOException("unknown shape type " + String.valueOf(node));
            }
        }
    }

    private void writeStrokeAttributes(@NonNull XMLStreamWriter w, @NonNull Shape shape) throws XMLStreamException {
        Paint stroke = shape.getStroke();
        if (stroke == null) {
            return;
        }
        double strokeOpacity = shape.getOpacity();
        String id = this.idFactory.getId((Object)stroke);
        if (id != null) {
            w.writeAttribute("stroke", "url(#" + id + ")");
        } else {
            Color c;
            w.writeAttribute("stroke", this.paintConverter.toString((Object)stroke));
            if (stroke instanceof Color && !(c = (Color)stroke).isOpaque()) {
                strokeOpacity *= c.getOpacity();
            }
        }
        if (strokeOpacity != 1.0) {
            w.writeAttribute("stroke-opacity", this.nb.toString((Object)strokeOpacity));
        }
        if (shape.getStrokeWidth() != 1.0) {
            w.writeAttribute("stroke-width", this.nb.toString((Object)shape.getStrokeWidth()));
        }
        if (shape.getStrokeLineCap() != StrokeLineCap.BUTT) {
            w.writeAttribute("stroke-linecap", shape.getStrokeLineCap().toString().toLowerCase());
        }
        if (shape.getStrokeLineJoin() != StrokeLineJoin.MITER) {
            w.writeAttribute("stroke-linejoin", shape.getStrokeLineJoin().toString().toLowerCase());
        }
        if (shape.getStrokeMiterLimit() != 4.0) {
            w.writeAttribute("stroke-miterlimit", this.nb.toString((Object)shape.getStrokeMiterLimit()));
        }
        if (!shape.getStrokeDashArray().isEmpty()) {
            w.writeAttribute("stroke-dasharray", this.doubleList.toString((Object)VectorList.copyOf((Iterable)shape.getStrokeDashArray())));
        }
        if (shape.getStrokeDashOffset() != 0.0) {
            w.writeAttribute("stroke-dashoffset", this.nb.toString((Object)shape.getStrokeDashOffset()));
        }
    }

    private void writeStrokedShapeAttributes(@NonNull XMLStreamWriter w, @NonNull Shape shape) throws XMLStreamException {
        Paint stroke = shape.getStroke();
        if (stroke == null) {
            return;
        }
        String id = this.idFactory.getId((Object)stroke);
        if (id != null) {
            w.writeAttribute("fill", "url(#" + id + ")");
        } else {
            Color c;
            w.writeAttribute("fill", this.paintConverter.toString((Object)stroke));
            if (stroke instanceof Color && !(c = (Color)stroke).isOpaque()) {
                w.writeAttribute("fill-opacity", this.nb.toString((Object)c.getOpacity()));
            }
        }
    }

    private void writeBorderStrokeAttributes(@NonNull XMLStreamWriter w, @NonNull BorderStroke shape) throws XMLStreamException {
        BorderStrokeStyle style;
        if (shape.getTopStroke() != null) {
            w.writeAttribute("stroke", this.paintConverter.toString((Object)shape.getTopStroke()));
        }
        if (shape.getWidths().getTop() != 1.0) {
            w.writeAttribute("stroke-width", this.nb.toString((Object)shape.getWidths().getTop()));
        }
        if ((style = shape.getTopStyle()).getLineCap() != StrokeLineCap.BUTT) {
            w.writeAttribute("stroke-linecap", style.getLineCap().toString().toLowerCase());
        }
        if (style.getLineJoin() != StrokeLineJoin.MITER) {
            w.writeAttribute("stroke-linejoin", style.getLineJoin().toString().toLowerCase());
        }
        if (style.getMiterLimit() != 4.0) {
            w.writeAttribute("stroke-miterlimit", this.nb.toString((Object)style.getMiterLimit()));
        }
        if (!style.getDashArray().isEmpty()) {
            w.writeAttribute("stroke-dasharray", this.doubleList.toString((Object)VectorList.copyOf((Iterable)style.getDashArray())));
        }
        if (style.getDashOffset() != 0.0) {
            w.writeAttribute("stroke-dashoffset", this.nb.toString((Object)style.getDashOffset()));
        }
    }

    protected void writeStyleAttributes(@NonNull XMLStreamWriter w, @NonNull Node node) throws XMLStreamException {
        this.writeIdAttribute(w, node);
        this.writeClassAttribute(w, node);
        this.writeVisibleAttribute(w, node);
    }

    private void writeTextAttributes(@NonNull XMLStreamWriter w, @NonNull Text node) throws XMLStreamException {
        String weight;
        String style;
        javafx.scene.text.Font ft = node.getFont();
        w.writeAttribute("font-family", ft.getFamily().equals(ft.getName()) ? "'" + ft.getName() + "'" : "'" + ft.getName() + "', '" + ft.getFamily() + "'");
        w.writeAttribute("font-size", this.nb.toString((Object)ft.getSize()));
        String string = style = ft.getStyle().contains("Italic") ? "italic" : "normal";
        if (!style.equals("normal")) {
            w.writeAttribute("font-style", style);
        }
        String string2 = weight = ft.getStyle().contains("Bold") || ft.getName().toLowerCase().contains("bold") ? "bold" : "normal";
        if (!weight.equals("normal")) {
            w.writeAttribute("font-weight", weight);
        }
        if (node.isUnderline()) {
            w.writeAttribute("text-decoration", "underline");
        } else if (node.isStrikethrough()) {
            w.writeAttribute("text-decoration", "line-through ");
        }
        switch (node.getTextAlignment()) {
            case JUSTIFY: 
            case LEFT: {
                break;
            }
            case CENTER: {
                w.writeAttribute("text-anchor", "middle");
                break;
            }
            case RIGHT: {
                w.writeAttribute("text-anchor", "end");
            }
        }
        if (this.hasNoWrapping(node)) {
            Bounds bounds = node.getLayoutBounds();
            switch (node.getTextAlignment()) {
                case JUSTIFY: 
                case LEFT: {
                    w.writeAttribute("x", this.nb.toString((Object)node.getX()));
                    break;
                }
                case CENTER: {
                    w.writeAttribute("x", this.nb.toString((Object)(node.getX() + bounds.getWidth() * 0.5)));
                    break;
                }
                case RIGHT: {
                    w.writeAttribute("x", this.nb.toString((Object)(node.getX() + bounds.getWidth())));
                }
            }
            double y = bounds.getMinY() + node.getBaselineOffset();
            w.writeAttribute("y", this.nb.toString((Object)y));
        }
    }

    private void writeTextChildElements(@NonNull XMLStreamWriter w, @NonNull Text node) throws XMLStreamException {
        double lineSpacing = node.getLineSpacing();
        Bounds textRect = node.getLayoutBounds();
        if (this.hasNoWrapping(node)) {
            w.writeCharacters(node.getText());
        } else {
            this.drawText(w, node.getText(), textRect, node.getFont(), 8, node.isUnderline(), node.isStrikethrough(), node.getTextAlignment(), lineSpacing);
        }
    }

    private boolean hasNoWrapping(@NonNull Text node) {
        String text = node.getText();
        return node.getWrappingWidth() <= 0.0 && text == null || text.indexOf(10) < 0;
    }

    private void writeTextStartElement(@NonNull XMLStreamWriter w, @NonNull Text node) throws XMLStreamException {
        if (this.isConvertTextToPath()) {
            w.writeStartElement("path");
            w.writeAttribute("d", SvgPaths.awtPathIteratorToDoubleRelativeSvgString((PathIterator)FXShapes.fxShapeToAwtShape((Shape)node).getPathIterator(null)));
        } else {
            w.writeStartElement("text");
            this.writeTextAttributes(w, node);
        }
    }

    protected void writeTitleElement(@NonNull XMLStreamWriter w, @NonNull Node node) throws XMLStreamException {
        String title;
        Object titleObj = node.getProperties().get((Object)"title");
        if (titleObj instanceof String && !(title = ((String)titleObj).trim()).isEmpty()) {
            w.writeStartElement("title");
            w.writeCharacters(title);
            w.writeEndElement();
        }
    }

    private void writeTransformAttributes(@NonNull XMLStreamWriter w, @NonNull Node node) throws XMLStreamException {
        ArrayList<Transform> txs = new ArrayList<Transform>();
        Point2D pivot = FXRectangles.center((Bounds)node.getBoundsInLocal());
        if (node.getTranslateX() != 0.0 || node.getTranslateY() != 0.0) {
            txs.add((Transform)new Translate(node.getTranslateX(), node.getTranslateY()));
        }
        if (node.getRotate() != 0.0) {
            txs.add((Transform)new FXPreciseRotate(node.getRotate(), pivot.getX(), pivot.getY()));
        }
        if (node.getScaleX() != 1.0 || node.getScaleY() != 1.0) {
            txs.add((Transform)new Scale(node.getScaleX(), node.getScaleY(), pivot.getX(), pivot.getY()));
        }
        txs.addAll((Collection<Transform>)node.getTransforms());
        this.writeTransformAttributes(w, txs);
    }

    private void writeTransformAttributes(@NonNull XMLStreamWriter w, @NonNull List<Transform> txs) throws XMLStreamException {
        String value;
        if (!txs.isEmpty() && !(value = this.tx.toString((Object)VectorList.copyOf(txs))).isEmpty()) {
            w.writeAttribute("transform", value);
        }
    }

    private void writeVisibleAttribute(@NonNull XMLStreamWriter w, @NonNull Node node) throws XMLStreamException {
        if (!node.isVisible()) {
            w.writeAttribute("display", "none");
        }
    }
}

