/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.DataFormat;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdFactory;
import org.jhotdraw8.base.converter.NumberConverter;
import org.jhotdraw8.base.converter.SimpleIdFactory;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssDimension2D;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.ImageFigure;
import org.jhotdraw8.draw.figure.Page;
import org.jhotdraw8.draw.figure.PageFigure;
import org.jhotdraw8.draw.figure.Slice;
import org.jhotdraw8.draw.input.ClipboardOutputFormat;
import org.jhotdraw8.draw.io.AbstractExportOutputFormat;
import org.jhotdraw8.draw.io.OutputFormat;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.draw.render.SimpleDrawingRenderer;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullObjectKey;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.TransformFlattener;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;
import org.jhotdraw8.svg.io.AbstractFXSvgWriter;
import org.jhotdraw8.svg.io.FXSvgFullWriter;
import org.jhotdraw8.svg.io.SvgSceneGraphWriter;
import org.jhotdraw8.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgExportOutputFormat
extends AbstractExportOutputFormat
implements ClipboardOutputFormat,
OutputFormat {
    private static final Logger LOGGER = Logger.getLogger(SvgExportOutputFormat.class.getName());
    public static final NonNullObjectKey<Boolean> RELATIVIZE_PATHS = new NonNullObjectKey("relativizePaths", Boolean.class, (Object)Boolean.FALSE);
    public static final DataFormat SVG_FORMAT;
    public static final String SVG_MIME_TYPE = "image/svg+xml";
    private static final String SKIP_KEY = "skip";
    private final NumberConverter nb = new NumberConverter();
    private final SizeCssConverter sc = new SizeCssConverter(false);
    private final Converter<CssSize> sznb = new SizeCssConverter(false);
    private final @NonNull IdFactory idFactory = new SimpleIdFactory();
    private BiFunction<Object, Object, AbstractFXSvgWriter> exporterFactory = FXSvgFullWriter::new;

    public void setExporterFactory(BiFunction<Object, Object, AbstractFXSvgWriter> exporterFactory) {
        this.exporterFactory = exporterFactory;
    }

    private @NonNull AbstractFXSvgWriter createExporter() {
        AbstractFXSvgWriter exporter = this.exporterFactory.apply(ImageFigure.IMAGE_URI, SKIP_KEY);
        exporter.setExportInvisibleElements((Boolean)SvgSceneGraphWriter.EXPORT_INVISIBLE_ELEMENTS_KEY.getNonNull((ReadOnlyMap)this.getOptions()));
        return exporter;
    }

    protected @NonNull String getExtension() {
        return "svg";
    }

    protected boolean isResolutionIndependent() {
        return true;
    }

    private void markNodesOutsideBoundsWithSkip(@NonNull Node node, Bounds sceneBounds) {
        boolean intersects = node.intersects(node.sceneToLocal(sceneBounds));
        if (intersects) {
            node.getProperties().put((Object)SKIP_KEY, (Object)false);
            if (node instanceof Parent) {
                Parent parent = (Parent)node;
                for (Node child : parent.getChildrenUnmodifiable()) {
                    this.markNodesOutsideBoundsWithSkip(child, sceneBounds);
                }
            }
        } else {
            node.getProperties().put((Object)SKIP_KEY, (Object)true);
        }
    }

    public Document toDocument(@Nullable URI documentHome, @NonNull Drawing external, @NonNull Collection<Figure> selection) throws IOException {
        HashMap hints = new HashMap();
        this.idFactory.setDocumentHome(documentHome);
        RenderContext.RENDERING_INTENT.put(hints, (Object)RenderingIntent.EXPORT);
        Node drawingNode = SimpleDrawingRenderer.toNode((Drawing)external, selection, hints);
        AbstractFXSvgWriter exporter = this.createExporter();
        exporter.setRelativizePaths(this.isRelativizePaths());
        Document doc = exporter.toDocument(drawingNode, new CssDimension2D((CssSize)external.getNonNull((NonNullMapAccessor)Drawing.WIDTH), (CssSize)external.getNonNull((NonNullMapAccessor)Drawing.HEIGHT)));
        this.writeDrawingElementAttributes(doc.getDocumentElement(), external);
        return doc;
    }

    public void write(@NonNull Map<DataFormat, Object> clipboard, @NonNull Drawing drawing, @NonNull Collection<Figure> selection) throws IOException {
        this.idFactory.reset();
        this.idFactory.setDocumentHome(null);
        StringWriter out = new StringWriter();
        HashMap hints = new HashMap();
        RenderContext.RENDERING_INTENT.put(hints, (Object)RenderingIntent.EXPORT);
        Node drawingNode = SimpleDrawingRenderer.toNode((Drawing)drawing, selection, hints);
        AbstractFXSvgWriter exporter = this.createExporter();
        exporter.setRelativizePaths(this.isRelativizePaths());
        exporter.write(out, drawingNode, new CssDimension2D((CssSize)drawing.getNonNull((NonNullMapAccessor)Drawing.WIDTH), (CssSize)drawing.getNonNull((NonNullMapAccessor)Drawing.HEIGHT)));
        clipboard.put(SVG_FORMAT, out.toString());
    }

    public void write(@NonNull Path file, @NonNull Drawing drawing, @NonNull WorkState<Void> workState) throws IOException {
        this.idFactory.reset();
        this.idFactory.setDocumentHome(null);
        if (this.isExportDrawing()) {
            HashMap hints = new HashMap();
            RenderContext.RENDERING_INTENT.put(hints, (Object)RenderingIntent.EXPORT);
            try (OutputStream w = Files.newOutputStream(file, new OpenOption[0]);){
                AbstractFXSvgWriter exporter = this.createExporter();
                exporter.setRelativizePaths(this.isRelativizePaths());
                Node drawingNode = SimpleDrawingRenderer.toNode((Drawing)drawing, Collections.singletonList(drawing), hints);
                exporter.write(w, drawingNode, new CssDimension2D((CssSize)drawing.getNonNull((NonNullMapAccessor)Drawing.WIDTH), (CssSize)drawing.getNonNull((NonNullMapAccessor)Drawing.HEIGHT)));
            }
        }
        if (this.isExportSlices()) {
            this.writeSlices(file.getParent(), drawing);
        }
        if (this.isExportPages()) {
            String basename = file.getFileName().toString();
            int p = basename.lastIndexOf(46);
            if (p != -1) {
                basename = basename.substring(0, p);
            }
            this.writePages(file.getParent(), basename, drawing);
        }
    }

    public void write(@NonNull OutputStream out, @Nullable URI documentHome, @NonNull Drawing drawing, @NonNull WorkState<Void> workState) throws IOException {
        this.write(documentHome, out, drawing, (Collection<Figure>)drawing.getChildren());
    }

    protected void write(@Nullable URI documentHome, @NonNull OutputStream out, @NonNull Drawing drawing, @NonNull Collection<Figure> selection) throws IOException {
        HashMap hints = new HashMap();
        this.idFactory.reset();
        this.idFactory.setDocumentHome(documentHome);
        RenderContext.RENDERING_INTENT.put(hints, (Object)RenderingIntent.EXPORT);
        Node drawingNode = SimpleDrawingRenderer.toNode((Drawing)drawing, selection, hints);
        AbstractFXSvgWriter exporter = this.createExporter();
        exporter.setRelativizePaths(this.isRelativizePaths());
        exporter.write(out, drawingNode, new CssDimension2D((CssSize)drawing.getNonNull((NonNullMapAccessor)Drawing.WIDTH), (CssSize)drawing.getNonNull((NonNullMapAccessor)Drawing.HEIGHT)));
    }

    private boolean isRelativizePaths() {
        return (Boolean)RELATIVIZE_PATHS.getNonNull((ReadOnlyMap)this.getOptions());
    }

    private void writeDrawingElementAttributes(@NonNull Element docElement, @NonNull Drawing drawing) {
        docElement.setAttribute("width", this.sc.toString((Object)((CssSize)drawing.get((MapAccessor)Drawing.WIDTH))));
        docElement.setAttribute("height", this.sc.toString((Object)((CssSize)drawing.get((MapAccessor)Drawing.HEIGHT))));
    }

    protected void writePage(@NonNull Path file, @NonNull Page page, @NonNull Node node, int pageCount, int pageNumber, int internalPageNumber) throws IOException {
        CssSize pw = (CssSize)page.getNonNull((NonNullMapAccessor)PageFigure.PAPER_WIDTH);
        CssSize ph = (CssSize)page.getNonNull((NonNullMapAccessor)PageFigure.PAPER_HEIGHT);
        this.markNodesOutsideBoundsWithSkip(node, FXTransforms.transform((Transform)page.getLocalToWorld(), (Bounds)page.getPageBounds(internalPageNumber)));
        node.getTransforms().setAll((Object[])new Transform[]{page.getWorldToLocal()});
        AbstractFXSvgWriter exporter = this.createExporter();
        Document doc = exporter.toDocument(node, new CssDimension2D(pw, ph));
        this.writePageElementAttributes(doc.getDocumentElement(), page, internalPageNumber);
        node.getTransforms().clear();
        XmlUtil.write((Path)file, (Document)doc);
    }

    private void writePageElementAttributes(@NonNull Element docElement, @NonNull Page page, int internalPageNumber) {
        Bounds pb = page.getPageBounds(internalPageNumber);
        docElement.setAttribute("width", this.sznb.toString((Object)((CssSize)page.get((MapAccessor)PageFigure.PAPER_WIDTH))));
        docElement.setAttribute("height", this.sznb.toString((Object)((CssSize)page.get((MapAccessor)PageFigure.PAPER_HEIGHT))));
        docElement.setAttribute("viewBox", this.nb.toString((Object)pb.getMinX()) + " " + this.nb.toString((Object)pb.getMinY()) + " " + this.nb.toString((Object)pb.getWidth()) + " " + this.nb.toString((Object)pb.getHeight()));
    }

    protected boolean writeSlice(@NonNull Path file, @NonNull Slice slice, @NonNull Node node, double dpi) throws IOException {
        LOGGER.info("Writing slice " + String.valueOf(file));
        this.markNodesOutsideBoundsWithSkip(node, slice.getLayoutBounds());
        Transform worldToLocal = slice.getWorldToLocal();
        Point2D sliceOrigin = slice.getSliceOrigin();
        worldToLocal = FXTransforms.concat((Transform[])new Transform[]{worldToLocal, new Translate(-sliceOrigin.getX(), -sliceOrigin.getY())});
        if (!worldToLocal.isIdentity()) {
            node.getTransforms().setAll((Object[])new Transform[]{worldToLocal});
        }
        new TransformFlattener().flattenTranslates(node);
        AbstractFXSvgWriter exporter = this.createExporter();
        Bounds bounds = slice.getBoundsInLocal();
        Document doc = exporter.toDocument(node, new CssDimension2D(bounds.getWidth(), bounds.getHeight()));
        this.writeSliceElementAttributes(doc.getDocumentElement(), slice);
        node.getTransforms().clear();
        XmlUtil.write((Path)file, (Document)doc);
        return true;
    }

    private void writeSliceElementAttributes(@NonNull Element docElement, @NonNull Slice slice) {
        Bounds b = slice.getLayoutBounds();
        Point2D sliceOrigin = slice.getSliceOrigin();
        Transform tx = slice.getWorldToLocal();
        docElement.setAttribute("width", this.nb.toString((Object)b.getWidth()));
        docElement.setAttribute("height", this.nb.toString((Object)b.getHeight()));
        docElement.setAttribute("viewBox", this.nb.toString((Object)(b.getMinX() - sliceOrigin.getX())) + " " + this.nb.toString((Object)(b.getMinY() - sliceOrigin.getY())) + " " + this.nb.toString((Object)b.getWidth()) + " " + this.nb.toString((Object)b.getHeight()));
    }

    static {
        DataFormat fmt = DataFormat.lookupMimeType((String)SVG_MIME_TYPE);
        if (fmt == null) {
            fmt = new DataFormat(new String[]{SVG_MIME_TYPE});
        }
        SVG_FORMAT = fmt;
    }
}

