/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.css.text;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.svg.css.SvgDefaultablePaint;
import org.jhotdraw8.svg.css.SvgPaintDefaulting;
import org.jspecify.annotations.Nullable;

public class SvgDefaultablePaintConverter<T extends Paintable>
implements CssConverter<SvgDefaultablePaint<T>> {
    public static final String CURRENT_COLOR = "currentColor";
    private final CssConverter<T> valueConverter;

    public SvgDefaultablePaintConverter(CssConverter<T> valueConverter) {
        this.valueConverter = valueConverter;
    }

    public @Nullable SvgDefaultablePaint<T> parse(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() == -2) {
            switch (tt.currentStringNonNull()) {
                case "inherit": {
                    return new SvgDefaultablePaint<Object>(SvgPaintDefaulting.INHERIT, null);
                }
                case "currentColor": {
                    return new SvgDefaultablePaint<Object>(SvgPaintDefaulting.CURRENT_COLOR, null);
                }
            }
        }
        tt.pushBack();
        return new SvgDefaultablePaint<Paintable>(null, (Paintable)this.valueConverter.parse(tt, idResolver));
    }

    public <TT extends SvgDefaultablePaint<T>> void produceTokens(@Nullable TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) throws IOException {
        if (value == null) {
            out.accept(new CssToken(-2, "none"));
            return;
        }
        SvgPaintDefaulting defaulting = value.getDefaulting();
        if (defaulting != null) {
            switch (defaulting) {
                case CURRENT_COLOR: {
                    out.accept(new CssToken(-2, CURRENT_COLOR));
                    break;
                }
                case INHERIT: {
                    out.accept(new CssToken(-2, "inherit"));
                }
            }
            return;
        }
        this.valueConverter.produceTokens(value.getValue(), idSupplier, out);
    }

    public @Nullable SvgDefaultablePaint<T> getDefaultValue() {
        return new SvgDefaultablePaint<Object>(SvgPaintDefaulting.INHERIT, null);
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8DefaultableValue\u27e9: \u27e8Value\u27e9\uff5cinherit\uff5cinitial\uff5cunset\uff5crevert\uff5c\nWith \u27e8Value\u27e9:\n  " + this.valueConverter.getHelpText();
    }

    public boolean isNullable() {
        return this.valueConverter.isNullable();
    }
}

