/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.svg.figure.SvgDefaultableFigure;
import org.jhotdraw8.svg.figure.SvgElementFigure;
import org.jhotdraw8.svg.figure.SvgPathLengthFigure;
import org.jhotdraw8.svg.figure.SvgTransformableFigure;
import org.jspecify.annotations.Nullable;

public class SvgCircleFigure
extends AbstractLeafFigure
implements StyleableFigure,
LockableFigure,
SvgTransformableFigure,
PathIterableFigure,
HideableFigure,
SvgPathLengthFigure,
SvgDefaultableFigure,
SvgElementFigure {
    public static final String TYPE_SELECTOR = "circle";
    public static final CssSizeStyleableKey CX = new CssSizeStyleableKey("cx", CssSize.ZERO);
    public static final CssSizeStyleableKey CY = new CssSizeStyleableKey("cy", CssSize.ZERO);
    public static final CssSizeStyleableKey R = new CssSizeStyleableKey("r", CssSize.ONE);

    public Node createNode(RenderContext ctx) {
        Group g = new Group();
        Circle n0 = new Circle();
        Circle n1 = new Circle();
        n0.setManaged(false);
        n1.setManaged(false);
        g.getChildren().addAll((Object[])new Node[]{n0, n1});
        return g;
    }

    public PathIterator getPathIterator(RenderContext ctx, @Nullable AffineTransform tx) {
        UnitConverter unit = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double r = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)R)).getConvertedValue(unit);
        Ellipse2D.Double shape = new Ellipse2D.Double(((CssSize)this.getStyledNonNull((NonNullMapAccessor)CX)).getConvertedValue(unit) - r, ((CssSize)this.getStyledNonNull((NonNullMapAccessor)CY)).getConvertedValue(unit) - r, r * 2.0, r * 2.0);
        return shape.getPathIterator(tx);
    }

    public Bounds getBoundsInLocal() {
        return this.getCssLayoutBounds().getConvertedBoundsValue();
    }

    public Bounds getLayoutBounds() {
        double r = ((CssSize)this.getNonNull((NonNullMapAccessor)R)).getConvertedValue();
        double cx = ((CssSize)this.getNonNull((NonNullMapAccessor)CX)).getConvertedValue();
        double cy = ((CssSize)this.getNonNull((NonNullMapAccessor)CY)).getConvertedValue();
        return new BoundingBox(cx - r, cy - r, r * 2.0, r * 2.0);
    }

    public CssRectangle2D getCssLayoutBounds() {
        CssSize r = (CssSize)this.getNonNull((NonNullMapAccessor)R);
        return new CssRectangle2D(((CssSize)this.getNonNull((NonNullMapAccessor)CX)).subtract(r), ((CssSize)this.getNonNull((NonNullMapAccessor)CY)).subtract(r), r.multiply(2.0), r.multiply(2.0));
    }

    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
        CssSize rx = CssSize.max((CssSize)width.multiply(0.5), (CssSize)CssSize.ZERO);
        CssSize ry = CssSize.max((CssSize)height.multiply(0.5), (CssSize)CssSize.ZERO);
        CssSize r = rx.getConvertedValue() > ry.getConvertedValue() ? ry : rx;
        this.set((MapAccessor)CX, x.add(rx));
        this.set((MapAccessor)CY, y.add(ry));
        this.set((MapAccessor)R, r);
    }

    public void reshapeInLocal(double x, double y, double width, double height) {
        this.reshapeInLocal(FXTransforms.createReshapeTransform((Bounds)this.getLayoutBounds(), (double)x, (double)y, (double)width, (double)height));
    }

    public void updateNode(RenderContext ctx, Node node) {
        Group g = (Group)node;
        UnitConverter unit = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double r = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)R)).getConvertedValue(unit);
        if (r <= 0.0) {
            g.setVisible(false);
            return;
        }
        Circle n0 = (Circle)g.getChildren().get(0);
        Circle n1 = (Circle)g.getChildren().get(1);
        this.applyHideableFigureProperties(ctx, (Node)g);
        this.applyStyleableFigureProperties(ctx, (Node)g);
        this.applyTransformableFigureProperties(ctx, (Node)g);
        this.applySvgDefaultableCompositingProperties(ctx, (Node)g);
        this.applySvgShapeProperties(ctx, (Shape)n0, (Shape)n1);
        double cx = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)CX)).getConvertedValue(unit);
        double cy = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)CY)).getConvertedValue(unit);
        n0.setCenterX(cx);
        n0.setCenterY(cy);
        n0.setRadius(r);
        n0.applyCss();
        n1.setCenterX(cx);
        n1.setCenterY(cy);
        n1.setRadius(r);
        n1.applyCss();
    }

    public String getTypeSelector() {
        return TYPE_SELECTOR;
    }
}

