/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Shape;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.svg.figure.SvgCircleFigure;
import org.jhotdraw8.svg.figure.SvgDefaultableFigure;
import org.jhotdraw8.svg.figure.SvgElementFigure;
import org.jhotdraw8.svg.figure.SvgPathLengthFigure;
import org.jhotdraw8.svg.figure.SvgTransformableFigure;
import org.jspecify.annotations.Nullable;

public class SvgEllipseFigure
extends AbstractLeafFigure
implements StyleableFigure,
LockableFigure,
SvgTransformableFigure,
PathIterableFigure,
HideableFigure,
SvgPathLengthFigure,
SvgElementFigure,
SvgDefaultableFigure {
    public static final String TYPE_SELECTOR = "ellipse";
    public static final CssSizeStyleableKey CX = SvgCircleFigure.CX;
    public static final CssSizeStyleableKey CY = SvgCircleFigure.CY;
    public static final CssSizeStyleableKey RX = new CssSizeStyleableKey("rx", CssSize.ONE);
    public static final CssSizeStyleableKey RY = new CssSizeStyleableKey("ry", CssSize.ONE);

    public Node createNode(RenderContext ctx) {
        Group g = new Group();
        Ellipse n0 = new Ellipse();
        Ellipse n1 = new Ellipse();
        n0.setManaged(false);
        n1.setManaged(false);
        g.getChildren().addAll((Object[])new Node[]{n0, n1});
        return g;
    }

    public PathIterator getPathIterator(RenderContext ctx, @Nullable AffineTransform tx) {
        UnitConverter unit = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double rx = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)RX)).getConvertedValue(unit);
        double ry = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)RY)).getConvertedValue(unit);
        Ellipse2D.Double shape = new Ellipse2D.Double(((CssSize)this.getStyledNonNull((NonNullMapAccessor)CX)).getConvertedValue(unit) - rx, ((CssSize)this.getStyledNonNull((NonNullMapAccessor)CY)).getConvertedValue(unit) - ry, rx * 2.0, ry * 2.0);
        return shape.getPathIterator(tx);
    }

    public Bounds getBoundsInLocal() {
        return this.getCssLayoutBounds().getConvertedBoundsValue();
    }

    public Bounds getLayoutBounds() {
        double rx = ((CssSize)this.getNonNull((NonNullMapAccessor)RX)).getConvertedValue();
        double ry = ((CssSize)this.getNonNull((NonNullMapAccessor)RY)).getConvertedValue();
        double cx = ((CssSize)this.getNonNull((NonNullMapAccessor)CX)).getConvertedValue();
        double cy = ((CssSize)this.getNonNull((NonNullMapAccessor)CY)).getConvertedValue();
        return new BoundingBox(cx - rx, cy - ry, rx * 2.0, ry * 2.0);
    }

    public CssRectangle2D getCssLayoutBounds() {
        CssSize rx = (CssSize)this.getNonNull((NonNullMapAccessor)RX);
        CssSize ry = (CssSize)this.getNonNull((NonNullMapAccessor)RY);
        return new CssRectangle2D(((CssSize)this.getNonNull((NonNullMapAccessor)CX)).subtract(rx), ((CssSize)this.getNonNull((NonNullMapAccessor)CY)).subtract(ry), rx.multiply(2.0), ry.multiply(2.0));
    }

    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
        CssSize rx = CssSize.max((CssSize)width.multiply(0.5), (CssSize)CssSize.ZERO);
        CssSize ry = CssSize.max((CssSize)height.multiply(0.5), (CssSize)CssSize.ZERO);
        this.set((MapAccessor)CX, x.add(rx));
        this.set((MapAccessor)CY, y.add(ry));
        this.set((MapAccessor)RX, rx);
        this.set((MapAccessor)RY, ry);
    }

    public void reshapeInLocal(double x, double y, double width, double height) {
        this.reshapeInLocal(FXTransforms.createReshapeTransform((Bounds)this.getLayoutBounds(), (double)x, (double)y, (double)width, (double)height));
    }

    public void updateNode(RenderContext ctx, Node node) {
        Group g = (Group)node;
        UnitConverter unit = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double rx = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)RX)).getConvertedValue(unit);
        double ry = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)RY)).getConvertedValue(unit);
        if (rx <= 0.0 || ry <= 0.0) {
            g.setVisible(false);
            return;
        }
        Ellipse n0 = (Ellipse)g.getChildren().get(0);
        Ellipse n1 = (Ellipse)g.getChildren().get(1);
        this.applyHideableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyTransformableFigureProperties(ctx, node);
        this.applySvgDefaultableCompositingProperties(ctx, node);
        this.applySvgShapeProperties(ctx, (Shape)n0, (Shape)n1);
        double cx = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)CX)).getConvertedValue(unit);
        double cy = ((CssSize)this.getStyledNonNull((NonNullMapAccessor)CY)).getConvertedValue(unit);
        n0.setCenterX(cx);
        n0.setCenterY(cy);
        n0.setRadiusX(rx);
        n0.setRadiusY(ry);
        n0.applyCss();
        n1.setCenterX(cx);
        n1.setCenterY(cy);
        n1.setRadiusX(rx);
        n1.setRadiusY(ry);
        n1.applyCss();
    }

    public String getTypeSelector() {
        return TYPE_SELECTOR;
    }
}

