/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.key.DoubleListStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.svg.figure.SvgDefaultableFigure;
import org.jhotdraw8.svg.figure.SvgElementFigure;
import org.jhotdraw8.svg.figure.SvgPathLengthFigure;
import org.jhotdraw8.svg.figure.SvgTransformableFigure;
import org.jspecify.annotations.Nullable;

public class SvgPolylineFigure
extends AbstractLeafFigure
implements StyleableFigure,
LockableFigure,
SvgTransformableFigure,
PathIterableFigure,
HideableFigure,
SvgPathLengthFigure,
SvgDefaultableFigure,
SvgElementFigure {
    public static final String TYPE_SELECTOR = "polyline";
    public static final DoubleListStyleableKey POINTS = new DoubleListStyleableKey("points");

    public Node createNode(RenderContext ctx) {
        Group g = new Group();
        Polyline n0 = new Polyline();
        Polyline n1 = new Polyline();
        n0.setManaged(false);
        n1.setManaged(false);
        g.getChildren().addAll((Object[])new Node[]{n0, n1});
        return g;
    }

    public PathIterator getPathIterator(RenderContext ctx, @Nullable AffineTransform tx) {
        Path2D.Double p = new Path2D.Double();
        ImmutableList points = (ImmutableList)this.get((MapAccessor)POINTS);
        if (points != null) {
            int n = points.size();
            for (int i = 0; i < n - 1; i += 2) {
                if (i == 0) {
                    p.moveTo((Double)points.get(0), (Double)points.get(1));
                    continue;
                }
                p.lineTo((Double)points.get(i), (Double)points.get(i + 1));
            }
            p.closePath();
        }
        return p.getPathIterator(tx);
    }

    public Bounds getBoundsInLocal() {
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        ImmutableList points = (ImmutableList)this.get((MapAccessor)POINTS);
        if (points != null) {
            int n = points.size();
            for (int i = 0; i < n - 1; i += 2) {
                double x = (Double)points.get(i);
                double y = (Double)points.get(i + 1);
                minx = Math.min(minx, x);
                miny = Math.min(miny, y);
                maxx = Math.max(maxx, x);
                maxy = Math.max(maxy, y);
            }
        }
        return new BoundingBox(minx, miny, maxx - minx, maxy - miny);
    }

    public CssRectangle2D getCssLayoutBounds() {
        Bounds b = this.getBoundsInLocal();
        return new CssRectangle2D(b);
    }

    @Override
    public void reshapeInLocal(Transform transform) {
        ImmutableList points = (ImmutableList)this.get((MapAccessor)POINTS);
        if (points != null) {
            ArrayList<Double> t = new ArrayList<Double>(points.size());
            int n = points.size();
            for (int i = 0; i < n - 1; i += 2) {
                Point2D transformed = transform.transform(((Double)points.get(i)).doubleValue(), ((Double)points.get(i + 1)).doubleValue());
                t.add(transformed.getX());
                t.add(transformed.getY());
            }
            this.set((MapAccessor)POINTS, VectorList.copyOf(t));
        }
    }

    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
        this.reshapeInLocal(x.getConvertedValue(), y.getConvertedValue(), width.getConvertedValue(), height.getConvertedValue());
    }

    public void reshapeInLocal(double x, double y, double width, double height) {
        this.reshapeInLocal(FXTransforms.createReshapeTransform((Bounds)this.getLayoutBounds(), (double)x, (double)y, (double)width, (double)height));
    }

    public void updateNode(RenderContext ctx, Node node) {
        Group g = (Group)node;
        UnitConverter unit = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        ImmutableList points = (ImmutableList)this.get((MapAccessor)POINTS);
        if (points == null || points.isEmpty() || points.size() % 2 == 1) {
            g.setVisible(false);
            return;
        }
        Polyline n0 = (Polyline)g.getChildren().get(0);
        Polyline n1 = (Polyline)g.getChildren().get(1);
        this.applyHideableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyTransformableFigureProperties(ctx, node);
        this.applySvgDefaultableCompositingProperties(ctx, node);
        this.applySvgShapeProperties(ctx, (Shape)n0, (Shape)n1);
        n0.getPoints().setAll((Collection)(points == null ? Collections.emptyList() : points.asList()));
        n1.getPoints().setAll((Collection)(points == null ? Collections.emptyList() : points.asList()));
    }

    public String getTypeSelector() {
        return TYPE_SELECTOR;
    }
}

