/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.UnitConverter;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.AbstractLeafFigure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.PathIterableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.key.CssSizeStyleableKey;
import org.jhotdraw8.draw.key.NullableCssSizeStyleableKey;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.svg.figure.SvgDefaultableFigure;
import org.jhotdraw8.svg.figure.SvgElementFigure;
import org.jhotdraw8.svg.figure.SvgPathLengthFigure;
import org.jhotdraw8.svg.figure.SvgTransformableFigure;
import org.jspecify.annotations.Nullable;

public class SvgRectFigure
extends AbstractLeafFigure
implements StyleableFigure,
LockableFigure,
SvgTransformableFigure,
PathIterableFigure,
HideableFigure,
SvgPathLengthFigure,
SvgDefaultableFigure,
SvgElementFigure {
    public static final String TYPE_SELECTOR = "rect";
    public static final CssSizeStyleableKey X = new CssSizeStyleableKey("x", CssSize.ZERO);
    public static final CssSizeStyleableKey Y = new CssSizeStyleableKey("y", CssSize.ZERO);
    public static final NullableCssSizeStyleableKey RX = new NullableCssSizeStyleableKey("rx", null);
    public static final NullableCssSizeStyleableKey RY = new NullableCssSizeStyleableKey("ry", null);
    public static final CssSizeStyleableKey WIDTH = new CssSizeStyleableKey("width", CssSize.ZERO);
    public static final CssSizeStyleableKey HEIGHT = new CssSizeStyleableKey("height", CssSize.ZERO);

    public Node createNode(RenderContext ctx) {
        Group g = new Group();
        Path n0 = new Path();
        Path n1 = new Path();
        n0.setManaged(false);
        n1.setManaged(false);
        g.getChildren().addAll((Object[])new Node[]{n0, n1});
        return g;
    }

    private Point2D getRxRy(RenderContext ctx) {
        double rx;
        double ry;
        CssSize rxNullable = (CssSize)this.get((MapAccessor)RX);
        CssSize ryNullable = (CssSize)this.get((MapAccessor)RY);
        UnitConverter unit = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        if (rxNullable == null && ryNullable == null) {
            ry = 0.0;
            rx = 0.0;
        } else if (rxNullable == null) {
            rx = ry = ryNullable.getConvertedValue(unit);
        } else if (ryNullable == null) {
            rx = ry = rxNullable.getConvertedValue(unit);
        } else {
            rx = rxNullable.getConvertedValue(unit);
            ry = ryNullable.getConvertedValue(unit);
        }
        return new Point2D(rx, ry);
    }

    public PathIterator getPathIterator(RenderContext ctx, @Nullable AffineTransform tx) {
        UnitConverter unit = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        Point2D rxRy = this.getRxRy(ctx);
        RoundRectangle2D.Double p = new RoundRectangle2D.Double(((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue(unit), ((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue(unit), ((CssSize)this.getNonNull((NonNullMapAccessor)WIDTH)).getConvertedValue(unit), ((CssSize)this.getNonNull((NonNullMapAccessor)HEIGHT)).getConvertedValue(unit), rxRy.getX() * 2.0, rxRy.getY() * 2.0);
        return p.getPathIterator(tx);
    }

    public Bounds getBoundsInLocal() {
        return this.getCssLayoutBounds().getConvertedBoundsValue();
    }

    public CssRectangle2D getCssLayoutBounds() {
        CssSize x = (CssSize)this.getNonNull((NonNullMapAccessor)X);
        CssSize y = (CssSize)this.getNonNull((NonNullMapAccessor)Y);
        CssSize w = (CssSize)this.getNonNull((NonNullMapAccessor)WIDTH);
        CssSize h = (CssSize)this.getNonNull((NonNullMapAccessor)HEIGHT);
        return new CssRectangle2D(x, y, w, h);
    }

    @Override
    public void reshapeInLocal(Transform transform) {
        CssSize x = (CssSize)this.getNonNull((NonNullMapAccessor)X);
        CssSize y = (CssSize)this.getNonNull((NonNullMapAccessor)Y);
        CssSize w = (CssSize)this.getNonNull((NonNullMapAccessor)WIDTH);
        CssSize h = (CssSize)this.getNonNull((NonNullMapAccessor)HEIGHT);
        CssPoint2D txy = new CssPoint2D(transform.transform(x.getConvertedValue(), y.getConvertedValue()));
        CssPoint2D twh = new CssPoint2D(transform.deltaTransform(w.getConvertedValue(), h.getConvertedValue()));
        this.set((MapAccessor)X, txy.getX());
        this.set((MapAccessor)Y, txy.getY());
        this.set((MapAccessor)WIDTH, twh.getX());
        this.set((MapAccessor)HEIGHT, twh.getY());
    }

    public void reshapeInLocal(CssSize x, CssSize y, CssSize width, CssSize height) {
        this.reshapeInLocal(x.getConvertedValue(), y.getConvertedValue(), width.getConvertedValue(), height.getConvertedValue());
    }

    public void reshapeInLocal(double x, double y, double width, double height) {
        this.reshapeInLocal(FXTransforms.createReshapeTransform((Bounds)this.getLayoutBounds(), (double)x, (double)y, (double)width, (double)height));
    }

    public void updateNode(RenderContext ctx, Node node) {
        Group g = (Group)node;
        UnitConverter unit = (UnitConverter)ctx.getNonNull((NonNullMapAccessor)RenderContext.UNIT_CONVERTER_KEY);
        double width = ((CssSize)this.getNonNull((NonNullMapAccessor)WIDTH)).getConvertedValue(unit);
        double height = ((CssSize)this.getNonNull((NonNullMapAccessor)HEIGHT)).getConvertedValue(unit);
        if (width <= 0.0 || height <= 0.0) {
            g.setVisible(false);
            return;
        }
        Path n0 = (Path)g.getChildren().get(0);
        Path n1 = (Path)g.getChildren().get(1);
        this.applyHideableFigureProperties(ctx, node);
        this.applyStyleableFigureProperties(ctx, node);
        this.applyTransformableFigureProperties(ctx, node);
        this.applySvgDefaultableCompositingProperties(ctx, node);
        this.applySvgShapeProperties(ctx, (Shape)n0, (Shape)n1);
        double x = ((CssSize)this.getNonNull((NonNullMapAccessor)X)).getConvertedValue(unit);
        double y = ((CssSize)this.getNonNull((NonNullMapAccessor)Y)).getConvertedValue(unit);
        Point2D rxRy = this.getRxRy(ctx);
        double rx = Math.min(rxRy.getX(), width * 0.5);
        double ry = Math.min(rxRy.getY(), height * 0.5);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(new MoveTo(x + rx, y));
        l.add(new LineTo(x + width - rx, y));
        if (rx > 0.0 || ry > 0.0) {
            l.add(new MoveTo(x + rx, y));
            l.add(new LineTo(x + width - rx, y));
            l.add(new ArcTo(rx, ry, 0.0, x + width, y + ry, false, true));
            l.add(new LineTo(x + width, y + height - ry));
            l.add(new ArcTo(rx, ry, 0.0, x + width - rx, y + height, false, true));
            l.add(new LineTo(x + rx, y + height));
            l.add(new ArcTo(rx, ry, 0.0, x, y + height - ry, false, true));
            l.add(new LineTo(x, y + ry));
            l.add(new ArcTo(rx, ry, 0.0, x + rx, y, false, true));
            l.add(new ClosePath());
        } else {
            l.add(new MoveTo(x, y));
            l.add(new LineTo(x + width, y));
            l.add(new LineTo(x + width, y + height));
            l.add(new LineTo(x, y + height));
            l.add(new ClosePath());
        }
        n0.getElements().setAll(l);
        n1.getElements().setAll(l);
        n0.applyCss();
        n1.applyCss();
    }

    public String getTypeSelector() {
        return TYPE_SELECTOR;
    }
}

