/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.gui;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.SequencedMap;
import java.util.Set;
import java.util.prefs.Preferences;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.converter.NumberCssConverter;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.io.ExportOutputFormat;
import org.jhotdraw8.fxbase.clipboard.DataFormats;
import org.jhotdraw8.fxbase.control.InputDialog;
import org.jhotdraw8.fxbase.converter.StringConverterAdapter;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.svg.io.SvgSceneGraphWriter;

public class SvgDrawingExportOptionsPane
extends GridPane {
    @FXML
    private TextField drawingDpiField;
    private final TextFormatter<Number> drawingDpiFormatter = new TextFormatter((StringConverter)new StringConverterAdapter((Converter)new NumberCssConverter(false)));
    @FXML
    private Label drawingDpiLabel;
    @FXML
    private CheckBox exportDrawingCheckBox;
    @FXML
    private CheckBox exportPagesCheckBox;
    @FXML
    private CheckBox exportSlicesCheckBox;
    @FXML
    private URL location;
    @FXML
    private TextField pagesDpiField;
    private final TextFormatter<Number> pagesDpiFormatter = new TextFormatter((StringConverter)new StringConverterAdapter((Converter)new NumberCssConverter(false)));
    @FXML
    private Label pagesDpiLabel;
    @FXML
    private ResourceBundle resources;
    @FXML
    private TextField slicesDpiField;
    private final TextFormatter<Number> slicesDpiFormatter = new TextFormatter((StringConverter)new StringConverterAdapter((Converter)new NumberCssConverter(false)));
    @FXML
    private Label slicesDpiLabel;
    @FXML
    private CheckBox slicesResolution2xCheckBox;
    @FXML
    private CheckBox slicesResolution3xCheckBox;
    @FXML
    private CheckBox exportInvisibleElements;
    @FXML
    private Label optionsLabel;
    private DataFormat format;
    private final Set<DataFormat> dpiFormats = new HashSet<DataFormat>();
    private final Set<DataFormat> invisiblesFormats;

    public static Dialog<SequencedMap<Key<?>, Object>> createDialog(DataFormat format) {
        Resources labels = ApplicationLabels.getResources();
        SvgDrawingExportOptionsPane pane = new SvgDrawingExportOptionsPane();
        pane.setFormat(format);
        return new InputDialog(labels.getString("file.export.dialog.title"), labels.getString("file.export.dialog.headerText"), (Node)pane, pane::getExportOptions);
    }

    public SvgDrawingExportOptionsPane() {
        this.dpiFormats.add(DataFormat.IMAGE);
        this.dpiFormats.add(DataFormats.registerDataFormat((String)"image/png"));
        this.dpiFormats.add(DataFormats.registerDataFormat((String)"image/jpeg"));
        this.invisiblesFormats = new HashSet<DataFormat>();
        this.invisiblesFormats.add(DataFormats.registerDataFormat((String)"image/svg+xml"));
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        loader.setResources(DrawLabels.getResources().asResourceBundle());
        try {
            loader.load(((Object)((Object)this)).getClass().getResourceAsStream("DrawingExportOptionsPane.fxml"));
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
    }

    public SequencedMap<Key<?>, Object> getExportOptions() {
        LinkedHashMap map = new LinkedHashMap();
        ExportOutputFormat.EXPORT_DRAWING_KEY.put(map, (Object)this.exportDrawingCheckBox.isSelected());
        ExportOutputFormat.EXPORT_PAGES_KEY.put(map, (Object)this.exportPagesCheckBox.isSelected());
        ExportOutputFormat.EXPORT_SLICES_KEY.put(map, (Object)this.exportSlicesCheckBox.isSelected());
        ExportOutputFormat.EXPORT_DRAWING_DPI_KEY.putNonNull(map, (Object)((Number)this.drawingDpiFormatter.getValue()).doubleValue());
        ExportOutputFormat.EXPORT_PAGES_DPI_KEY.put(map, (Object)((Number)this.pagesDpiFormatter.getValue()).doubleValue());
        ExportOutputFormat.EXPORT_SLICES_DPI_KEY.put(map, (Object)((Number)this.slicesDpiFormatter.getValue()).doubleValue());
        ExportOutputFormat.EXPORT_SLICES_RESOLUTION_2X_KEY.put(map, (Object)this.slicesResolution2xCheckBox.isSelected());
        ExportOutputFormat.EXPORT_SLICES_RESOLUTION_3X_KEY.put(map, (Object)this.slicesResolution3xCheckBox.isSelected());
        SvgSceneGraphWriter.EXPORT_INVISIBLE_ELEMENTS_KEY.put(map, (Object)this.exportInvisibleElements.isSelected());
        return map;
    }

    public DataFormat getFormat() {
        return this.format;
    }

    public void setFormat(DataFormat format) {
        this.format = format;
        this.updateFormat();
    }

    @FXML
    void initialize() {
        assert (this.exportDrawingCheckBox != null) : "fx:id=\"exportDrawingCheckBox\" was not injected: check your FXML file 'ExportDialog.fxml'.";
        assert (this.exportPagesCheckBox != null) : "fx:id=\"exportPagesCheckBox\" was not injected: check your FXML file 'ExportDialog.fxml'.";
        assert (this.exportSlicesCheckBox != null) : "fx:id=\"exportSlicesCheckBox\" was not injected: check your FXML file 'ExportDialog.fxml'.";
        assert (this.drawingDpiField != null) : "fx:id=\"drawingDpiField\" was not injected: check your FXML file 'ExportDialog.fxml'.";
        assert (this.pagesDpiField != null) : "fx:id=\"pagesDpiField\" was not injected: check your FXML file 'ExportDialog.fxml'.";
        assert (this.slicesDpiField != null) : "fx:id=\"slicesDpiField\" was not injected: check your FXML file 'ExportDialog.fxml'.";
        assert (this.slicesResolution2xCheckBox != null) : "fx:id=\"slicesResolution2xCheckBox\" was not injected: check your FXML file 'ExportDialog.fxml'.";
        assert (this.slicesResolution3xCheckBox != null) : "fx:id=\"slicesResolution3xCheckBox\" was not injected: check your FXML file 'ExportDialog.fxml'.";
        assert (this.drawingDpiLabel != null) : "fx:id=\"drawingDpiLabel\" was not injected: check your FXML file 'DrawingExportOptionsPane.fxml'.";
        assert (this.pagesDpiLabel != null) : "fx:id=\"pagesDpiLabel\" was not injected: check your FXML file 'DrawingExportOptionsPane.fxml'.";
        assert (this.slicesDpiLabel != null) : "fx:id=\"slicesDpiLabel\" was not injected: check your FXML file 'DrawingExportOptionsPane.fxml'.";
        assert (this.exportInvisibleElements != null) : "fx:id=\"exportInvisibleElements\" was not injected: check your FXML file 'DrawingExportOptionsPane.fxml'.";
        assert (this.optionsLabel != null) : "fx:id=\"optionsLabel\" was not injected: check your FXML file 'DrawingExportOptionsPane.fxml'.";
        this.drawingDpiField.setTextFormatter(this.drawingDpiFormatter);
        this.pagesDpiField.setTextFormatter(this.pagesDpiFormatter);
        this.slicesDpiField.setTextFormatter(this.slicesDpiFormatter);
        Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        this.exportDrawingCheckBox.setSelected(prefs.getBoolean("exportDrawing", true));
        this.exportPagesCheckBox.setSelected(prefs.getBoolean("exportPages", true));
        this.exportSlicesCheckBox.setSelected(prefs.getBoolean("exportSlices", true));
        this.drawingDpiFormatter.setValue((Object)prefs.getDouble("exportDrawingDpi", 72.0));
        this.pagesDpiFormatter.setValue((Object)prefs.getDouble("exporPagesDpi", 300.0));
        this.slicesDpiFormatter.setValue((Object)prefs.getDouble("exportSlicesDpi", 72.0));
        this.slicesResolution2xCheckBox.setSelected(prefs.getBoolean("exporSlicesResolution2x", false));
        this.slicesResolution3xCheckBox.setSelected(prefs.getBoolean("exporSlicesResolution3x", false));
        this.exportInvisibleElements.setSelected(prefs.getBoolean("exportInvisibleElements", false));
        this.exportDrawingCheckBox.selectedProperty().addListener((o, oldv, newv) -> prefs.putBoolean("exportDrawing", (boolean)newv));
        this.exportPagesCheckBox.selectedProperty().addListener((o, oldv, newv) -> prefs.putBoolean("exportPages", (boolean)newv));
        this.exportSlicesCheckBox.selectedProperty().addListener((o, oldv, newv) -> prefs.putBoolean("exportSlices", (boolean)newv));
        this.slicesResolution2xCheckBox.selectedProperty().addListener((o, oldv, newv) -> prefs.putBoolean("exporSlicesResolution2x", (boolean)newv));
        this.slicesResolution3xCheckBox.selectedProperty().addListener((o, oldv, newv) -> prefs.putBoolean("exporSlicesResolution3x", (boolean)newv));
        this.exportInvisibleElements.selectedProperty().addListener((o, oldv, newv) -> prefs.putBoolean("exportInvisibleElements", (boolean)newv));
        this.drawingDpiFormatter.valueProperty().addListener((o, oldv, newv) -> prefs.putDouble("exportDrawingDpi", newv == null ? 72.0 : newv.doubleValue()));
        this.pagesDpiFormatter.valueProperty().addListener((o, oldv, newv) -> prefs.putDouble("exporPagesDpi", newv == null ? 72.0 : newv.doubleValue()));
        this.slicesDpiFormatter.valueProperty().addListener((o, oldv, newv) -> prefs.putDouble("exportSlicesDpi", newv == null ? 72.0 : newv.doubleValue()));
        this.drawingDpiLabel.disableProperty().bind((ObservableValue)this.exportDrawingCheckBox.selectedProperty().not());
        this.drawingDpiField.disableProperty().bind((ObservableValue)this.exportDrawingCheckBox.selectedProperty().not());
        this.pagesDpiLabel.disableProperty().bind((ObservableValue)this.exportPagesCheckBox.selectedProperty().not());
        this.pagesDpiField.disableProperty().bind((ObservableValue)this.exportPagesCheckBox.selectedProperty().not());
        this.slicesDpiLabel.disableProperty().bind((ObservableValue)this.exportSlicesCheckBox.selectedProperty().not());
        this.slicesDpiField.disableProperty().bind((ObservableValue)this.exportSlicesCheckBox.selectedProperty().not());
        this.slicesResolution2xCheckBox.disableProperty().bind((ObservableValue)this.exportSlicesCheckBox.selectedProperty().not());
        this.slicesResolution3xCheckBox.disableProperty().bind((ObservableValue)this.exportSlicesCheckBox.selectedProperty().not());
    }

    private void updateFormat() {
        boolean dpi = this.supportsDpi(this.format);
        boolean invisibles = this.supportsInvisibles(this.format);
        this.drawingDpiLabel.setVisible(dpi);
        this.drawingDpiField.setVisible(dpi);
        this.pagesDpiLabel.setVisible(dpi);
        this.pagesDpiField.setVisible(dpi);
        this.slicesDpiLabel.setVisible(dpi);
        this.slicesDpiField.setVisible(dpi);
        this.slicesResolution2xCheckBox.setVisible(dpi);
        this.slicesResolution3xCheckBox.setVisible(dpi);
        this.optionsLabel.setVisible(invisibles);
        this.exportInvisibleElements.setVisible(invisibles);
    }

    private boolean supportsDpi(DataFormat format) {
        return this.dpiFormats.contains(format);
    }

    private boolean supportsInvisibles(DataFormat format) {
        return this.invisiblesFormats.contains(format);
    }
}

