/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jhotdraw8.draw.css.value.CssDimension2D;
import org.jhotdraw8.svg.io.AbstractFXSvgWriter;
import org.jspecify.annotations.Nullable;

public class FXSvgFullWriter
extends AbstractFXSvgWriter {
    private static final String SVG_VERSION = "1.1";
    private static final String SVG_BASE_PROFILE = "full";
    public static final String SVG_MIME_TYPE_WITH_VERSION = "image/svg+xml;version=\"1.1\"";

    public FXSvgFullWriter(Object imageUriKey, Object skipKey) {
        super(imageUriKey, skipKey);
    }

    @Override
    protected void writeDocumentElementAttributes(XMLStreamWriter w, Node drawingNode, @Nullable CssDimension2D size) throws XMLStreamException {
        w.writeAttribute("version", this.getSvgVersion());
        w.writeAttribute("baseProfile", this.getSvgBaseProfile());
        if (size != null) {
            w.writeAttribute("width", this.nb.toString((Object)size.getWidth().getValue()) + size.getWidth().getUnits());
            w.writeAttribute("height", this.nb.toString((Object)size.getHeight().getValue()) + size.getHeight().getUnits());
        }
    }

    @Override
    protected String getSvgVersion() {
        return SVG_VERSION;
    }

    @Override
    protected String getSvgBaseProfile() {
        return SVG_BASE_PROFILE;
    }

    @Override
    protected void writeClipAttributes(XMLStreamWriter w, Node node) throws XMLStreamException {
        Node clip = node.getClip();
        if (clip == null) {
            return;
        }
        String id = this.idFactory.getId((Object)clip);
        if (id != null) {
            w.writeAttribute("clip-path", "url(#" + id + ")");
        } else {
            System.err.println("WARNING SvgExporter does not support recursive clips!");
        }
    }

    @Override
    protected void writeClipPathDefs(XMLStreamWriter w, Node node) throws IOException, XMLStreamException {
        Node clip = node.getClip();
        if (clip == null) {
            return;
        }
        if (this.idFactory.getId((Object)clip) == null) {
            String id = this.idFactory.createId((Object)clip, "clipPath");
            w.writeStartElement("clipPath");
            w.writeAttribute("id", id);
            this.writeNodeRecursively(w, clip, 2);
            w.writeEndElement();
        }
    }

    @Override
    protected void writeCompositingAttributes(XMLStreamWriter w, Node node) throws XMLStreamException {
        if (node.getOpacity() != 1.0) {
            w.writeAttribute("opacity", this.nb.toString((Object)node.getOpacity()));
        }
    }

    @Override
    protected List<String> getAdditionalNodeClasses(Node node) {
        String typeSelector = (String)node.getProperties().get((Object)"figureTypeSelector");
        if (typeSelector != null) {
            return Collections.singletonList(typeSelector);
        }
        return Collections.emptyList();
    }
}

