/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.scene.Node;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.draw.render.SimpleDrawingRenderer;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.svg.io.FigureSvgTinyReader;

public class FXSvgTinyReader {
    public Node read(Path file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            Node node = this.read(new StreamSource(in));
            return node;
        }
    }

    public Node read(URL file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(file.openStream());){
            Node node = this.read(new StreamSource(in));
            return node;
        }
    }

    public Node read(Source in) throws IOException {
        LinkedHashMap m = new LinkedHashMap();
        RenderContext.RENDERING_INTENT.put(m, (Object)RenderingIntent.EXPORT);
        return this.read(in, m);
    }

    public Node read(Source in, Map<MapAccessor<?>, Object> renderingHints) throws IOException {
        Figure figure = new FigureSvgTinyReader().read(in);
        SimpleDrawingRenderer r = new SimpleDrawingRenderer();
        renderingHints.forEach((key, value) -> r.put(key, value));
        Node node = r.render(figure);
        node.setManaged(true);
        return node;
    }
}

