/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.io;

import java.awt.geom.PathIterator;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Path;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jhotdraw8.draw.css.value.CssDimension2D;
import org.jhotdraw8.geom.FXShapes;
import org.jhotdraw8.geom.FXSvgPaths;
import org.jhotdraw8.geom.SvgPaths;
import org.jhotdraw8.svg.io.AbstractFXSvgWriter;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;

public class FXSvgTinyWriter
extends AbstractFXSvgWriter {
    private static final String SVG_VERSION = "1.2";
    private static final String SVG_BASE_PROFILE = "tiny";
    public static final String SVG_MIME_TYPE_WITH_VERSION = "image/svg+xml;version=\"1.2\"";

    public FXSvgTinyWriter(Object imageUriKey, Object skipKey) {
        super(imageUriKey, skipKey);
    }

    @Override
    protected String getSvgVersion() {
        return SVG_VERSION;
    }

    @Override
    protected String getSvgBaseProfile() {
        return SVG_BASE_PROFILE;
    }

    @Override
    protected void writeDocumentElementAttributes(XMLStreamWriter w, Node drawingNode, @Nullable CssDimension2D size) throws XMLStreamException {
        w.writeAttribute("version", this.getSvgVersion());
        w.writeAttribute("baseProfile", this.getSvgBaseProfile());
        if (size != null) {
            w.writeAttribute("width", this.nb.toString((Object)size.getWidth().getValue()) + size.getWidth().getUnits());
            w.writeAttribute("height", this.nb.toString((Object)size.getHeight().getValue()) + size.getHeight().getUnits());
        }
    }

    @Override
    protected void writeClipAttributes(XMLStreamWriter w, Node node) {
    }

    @Override
    protected void writeClipPathDefs(XMLStreamWriter w, Node node) {
    }

    @Override
    protected void writeCompositingAttributes(XMLStreamWriter w, Node node) {
    }

    private boolean isSuppressGroups() {
        return true;
    }

    @Override
    protected void writePathStartElement(XMLStreamWriter w, Path node) throws XMLStreamException {
        w.writeStartElement("path");
        String d = this.isRelativizePaths() ? SvgPaths.awtPathIteratorToFloatRelativeSvgString((PathIterator)FXShapes.fxPathELementsToAwtShape((Iterable)node.getElements(), (FillRule)node.getFillRule()).getPathIterator(null)) : FXSvgPaths.pathElementsToFloatSvgString((Iterable)node.getElements());
        w.writeAttribute("d", d);
    }

    @Override
    protected List<String> getAdditionalNodeClasses(Node node) {
        return Collections.emptyList();
    }

    protected void writeIdAttribute(Element elem, Node node) {
    }
}

