/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jhotdraw8.base.concurrent.CheckedRunnable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.SimpleIdFactory;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.value.CssDefaultableValue;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.converter.DefaultableValueCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.css.value.NamedCssColor;
import org.jhotdraw8.draw.css.value.Paintable;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.SimpleRenderContext;
import org.jhotdraw8.fxbase.styleable.ReadOnlyStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullKey;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.SimpleParameterizedType;
import org.jhotdraw8.icollection.MapEntries;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.svg.css.SvgDefaultablePaint;
import org.jhotdraw8.svg.css.text.SvgDefaultablePaintConverter;
import org.jhotdraw8.svg.figure.SvgCircleFigure;
import org.jhotdraw8.svg.figure.SvgDefsFigure;
import org.jhotdraw8.svg.figure.SvgDrawing;
import org.jhotdraw8.svg.figure.SvgElementFigure;
import org.jhotdraw8.svg.figure.SvgEllipseFigure;
import org.jhotdraw8.svg.figure.SvgGFigure;
import org.jhotdraw8.svg.figure.SvgLineFigure;
import org.jhotdraw8.svg.figure.SvgLinearGradientFigure;
import org.jhotdraw8.svg.figure.SvgPathFigure;
import org.jhotdraw8.svg.figure.SvgPolygonFigure;
import org.jhotdraw8.svg.figure.SvgPolylineFigure;
import org.jhotdraw8.svg.figure.SvgRadialGradientFigure;
import org.jhotdraw8.svg.figure.SvgRectFigure;
import org.jhotdraw8.svg.figure.SvgStop;
import org.jhotdraw8.svg.figure.SvgTextFigure;
import org.jhotdraw8.svg.text.SvgXmlPaintableConverter;
import org.jhotdraw8.xml.converter.StringXmlConverter;
import org.jhotdraw8.xml.converter.WordSetXmlConverter;
import org.jspecify.annotations.Nullable;

public class FigureSvgTinyReader {
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final Map<String, Map<String, MapAccessor<?>>> accessorMap;
    private static final Map<QName, Supplier<Figure>> figureMap;
    private final SizeCssConverter sizeConverter = new SizeCssConverter(true);
    private final DefaultableValueCssConverter<CssSize> defaultableSizeConverter = new DefaultableValueCssConverter((CssConverter)new SizeCssConverter(false));
    private final SvgDefaultablePaintConverter<CssColor> colorConverter = new SvgDefaultablePaintConverter(new ColorCssConverter(true));
    private static final Map<Type, Converter<?>> converterMap;
    private final Key<String> textKey = SvgTextFigure.TEXT;
    private boolean bestEffort;
    private final NonNullKey<ImmutableList<SvgStop>> stopsKey = SvgLinearGradientFigure.STOPS;
    private final List<String> errors = Collections.synchronizedList(new ArrayList());

    public boolean isBestEffort() {
        return this.bestEffort;
    }

    public void setBestEffort(boolean bestEffort) {
        this.bestEffort = bestEffort;
    }

    private String toLocationString(@Nullable Location location) {
        return location == null ? "" : location.getSystemId() + " at [row,col]:[" + location.getLineNumber() + "," + location.getColumnNumber() + "]";
    }

    private void handleError(XMLStreamReader r, String message) throws XMLStreamException {
        this.handleError(r.getLocation(), message);
    }

    private void handleError(@Nullable Location r, String message) throws XMLStreamException {
        this.handleError(r, message, null);
    }

    private void handleError(@Nullable Location r, String message, @Nullable Throwable cause) throws XMLStreamException {
        if (!this.bestEffort) {
            if (r == null) {
                throw new XMLStreamException(message, cause);
            }
            throw new XMLStreamException(message, r, cause);
        }
        this.errors.add(message + " " + this.toLocationString(r));
    }

    public Figure read(Path file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            Figure figure = this.read(new StreamSource(in));
            return figure;
        }
    }

    public Figure read(URL file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(file.openStream());){
            Figure figure = this.read(new StreamSource(in));
            return figure;
        }
    }

    public Figure read(Source in) throws IOException {
        try {
            XMLInputFactory dbf = XMLInputFactory.newInstance();
            dbf.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            dbf.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            dbf.setProperty("javax.xml.stream.supportDTD", false);
            dbf.setXMLResolver((publicID, systemID, baseURI, namespace) -> null);
            XMLStreamReader r = dbf.createXMLStreamReader(in);
            Context ctx = new Context();
            Figure root = null;
            block8: while (true) {
                switch (r.next()) {
                    case 8: {
                        break block8;
                    }
                    case 1: {
                        if (!SVG_NAMESPACE.equals(r.getNamespaceURI()) || !"svg".equals(r.getLocalName())) break block8;
                        root = this.readElement(r, null, ctx);
                        break block8;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 11: {
                        continue block8;
                    }
                    default: {
                        this.handleError(r, "Expected an <svg> element. Found: " + r.getEventType());
                        continue block8;
                    }
                }
                break;
            }
            if (root == null) {
                this.handleError(r, "Could not find an <svg> element in the file.");
            }
            for (CheckedRunnable secondPass : ctx.secondPass) {
                secondPass.run();
            }
            root.set((MapAccessor)SvgDrawing.INLINE_STYLESHEETS, (Object)VectorList.copyOf(ctx.stylesheets));
            if (!(root instanceof SvgDrawing)) {
                SvgDrawing svgDrawing = new SvgDrawing();
                svgDrawing.addChild(root);
                root = svgDrawing;
            }
            root.set((MapAccessor)SvgDrawing.BACKGROUND, (Object)NamedCssColor.TRANSPARENT);
            ((SvgDrawing)root).updateAllCss((RenderContext)new SimpleRenderContext());
            this.setSizeOfDrawing(root);
            return root;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void readAttributes(XMLStreamReader r, Figure node, Map<String, MapAccessor<?>> m, Context ctx) throws XMLStreamException {
        int n = r.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            boolean isInXmlNsOrInSvgNs;
            String namespace = r.getAttributeNamespace(i);
            String localName = r.getAttributeLocalName(i);
            String value = r.getAttributeValue(i);
            boolean isInSvgNs = namespace == null || SVG_NAMESPACE.equals(namespace);
            boolean bl = isInXmlNsOrInSvgNs = isInSvgNs || XML_NAMESPACE.equals(namespace);
            if ("id".equals(localName) && isInXmlNsOrInSvgNs) {
                ctx.idFactory.putIdAndObject(value, (Object)node);
                node.set((MapAccessor)StyleableFigure.ID, (Object)value);
                continue;
            }
            if ("class".equals(localName) && isInSvgNs) {
                try {
                    node.set((MapAccessor)StyleableFigure.STYLE_CLASS, (Object)((ImmutableSet)new WordSetXmlConverter().fromString((CharSequence)value)));
                }
                catch (ParseException e) {
                    Location location = r.getLocation();
                    this.handleError(location, "Could not read attribute \"" + localName + "\".", e);
                }
                continue;
            }
            if (isInSvgNs) {
                if (m != null) {
                    ctx.secondPass.add(() -> {
                        MapAccessor mapAccessor = (MapAccessor)m.get(localName);
                        if (mapAccessor instanceof ReadOnlyStyleableMapAccessor) {
                            ReadOnlyStyleableMapAccessor rosma = (ReadOnlyStyleableMapAccessor)mapAccessor;
                            Converter<?> converter = converterMap.get(rosma.getValueType());
                            if (converter == null) {
                                Location location = r.getLocation();
                                this.handleError(location, "No converter for attribute \"" + localName + "\".");
                            } else {
                                try {
                                    node.set(mapAccessor, converter.fromString((CharSequence)value, (IdResolver)ctx.idFactory));
                                }
                                catch (ParseException e) {
                                    Location location = r.getLocation();
                                    this.handleError(location, "Could not read attribute \"" + localName + "\".", e);
                                }
                            }
                        } else {
                            Location location = r.getLocation();
                            this.handleError(location, "Unsupported attribute " + localName + "=\"" + value + "\".");
                        }
                    });
                    continue;
                }
                this.handleError(r, "Skipping SVG attribute " + localName + "=\"" + value + "\".");
                continue;
            }
            this.handleError(r, "Skipping foreign attribute {" + namespace + "}" + localName + "=\"" + value + "\".");
        }
    }

    private void readChildElements(XMLStreamReader r, Figure parent, Context ctx) throws XMLStreamException {
        ctx.stringBuilder.setLength(0);
        boolean collectTextForTextFigure = SVG_NAMESPACE.equals(r.getNamespaceURI()) && "text".equals(r.getLocalName());
        block6: while (true) {
            switch (r.next()) {
                case 2: 
                case 8: {
                    break block6;
                }
                case 1: {
                    collectTextForTextFigure = false;
                    this.readElement(r, parent, ctx);
                    continue block6;
                }
                case 3: 
                case 5: 
                case 11: {
                    continue block6;
                }
                case 4: {
                    ctx.stringBuilder.append(r.getTextCharacters(), r.getTextStart(), r.getTextLength());
                    continue block6;
                }
                default: {
                    this.handleError(r, "Expected an element. Found: " + r.getEventType());
                    continue block6;
                }
            }
            break;
        }
        if (collectTextForTextFigure && !ctx.stringBuilder.isEmpty()) {
            parent.set(this.textKey, (Object)ctx.stringBuilder.toString());
        }
    }

    private void readDesc(XMLStreamReader r, Figure parent, Context ctx) throws XMLStreamException {
        parent.set((MapAccessor)SvgElementFigure.DESC_KEY, (Object)this.readTextContent(r, parent, ctx));
    }

    private @Nullable Figure readElement(XMLStreamReader r, Figure parent, Context ctx) throws XMLStreamException {
        String localName = r.getLocalName();
        if (SVG_NAMESPACE.equals(r.getNamespaceURI())) {
            Supplier<Figure> figureSupplier = figureMap.get(r.getName());
            if (figureSupplier != null) {
                Figure node = figureSupplier.get();
                this.readAttributes(r, node, accessorMap.get(localName), ctx);
                this.readChildElements(r, node == null ? parent : node, ctx);
                if (parent != null) {
                    parent.getChildren().add((Object)node);
                }
                return node;
            }
            switch (localName == null ? "" : localName) {
                case "title": {
                    this.readTitle(r, parent, ctx);
                    return parent;
                }
                case "desc": {
                    this.readDesc(r, parent, ctx);
                    return parent;
                }
                case "style": {
                    this.readStyle(r, parent, ctx);
                    return parent;
                }
                case "stop": {
                    this.readStop(r, parent, ctx);
                    return parent;
                }
            }
            this.handleError(r, "Don't understand SVG element: " + localName + ".");
            this.readChildElements(r, parent, ctx);
        } else {
            this.handleError(r, "Skipping foreign element: " + String.valueOf(r.getName()) + ".");
            this.skipElement(r, ctx);
        }
        return null;
    }

    private void readStop(XMLStreamReader r, Figure parent, Context ctx) throws XMLStreamException {
        SvgDefaultablePaint stopColor = null;
        CssSize offset = null;
        CssDefaultableValue stopOpacity = new CssDefaultableValue((Object)CssSize.ONE);
        int n = r.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String namespace = r.getAttributeNamespace(i);
            if (namespace == null || SVG_NAMESPACE.equals(namespace)) {
                String localName = r.getAttributeLocalName(i);
                String value = r.getAttributeValue(i);
                try {
                    switch (localName) {
                        case "stop-color": {
                            stopColor = (SvgDefaultablePaint)this.colorConverter.fromString(value);
                            break;
                        }
                        case "offset": {
                            offset = (CssSize)this.sizeConverter.fromString((CharSequence)value);
                            break;
                        }
                        case "stop-opacity": {
                            stopOpacity = (CssDefaultableValue)this.defaultableSizeConverter.fromString((CharSequence)value);
                            break;
                        }
                        default: {
                            this.handleError(r, "stop: Skipping SVG attribute " + localName + "=\"" + value + "\"W");
                            break;
                        }
                    }
                }
                catch (ParseException e) {
                    this.handleError(r, "stop: Could not parse attribute " + localName + "=\"" + value + "\"W");
                }
                continue;
            }
            this.handleError(r, "stop: Skipping foreign attribute " + String.valueOf(r.getAttributeName(i)));
        }
        if (offset != null) {
            if (!parent.getSupportedKeys().contains(this.stopsKey)) {
                this.handleError(r, "stop: Cannot add stop to parent element " + parent.getTypeSelector());
            } else {
                SvgStop stop = new SvgStop(offset.getConvertedValue(), stopColor, (CssDefaultableValue<CssSize>)stopOpacity);
                parent.put(this.stopsKey, (Object)((ImmutableList)parent.getNonNull(this.stopsKey)).add((Object)stop));
            }
        }
        this.skipElement(r, ctx);
    }

    private void readStyle(XMLStreamReader r, Figure parent, Context ctx) throws XMLStreamException {
        String id = null;
        String type = null;
        String media = null;
        int n = r.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String namespace = r.getAttributeNamespace(i);
            if (namespace == null || SVG_NAMESPACE.equals(namespace)) {
                String localName = r.getAttributeLocalName(i);
                String value = r.getAttributeValue(i);
                switch (localName) {
                    case "id": {
                        id = value;
                        break;
                    }
                    case "type": {
                        type = value;
                        break;
                    }
                    case "media": {
                        media = value;
                        break;
                    }
                    default: {
                        this.handleError(r, "Skipping SVG attribute " + localName);
                        break;
                    }
                }
                continue;
            }
            this.handleError(r, "Skipping foreign attribute " + String.valueOf(r.getAttributeName(i)));
        }
        ctx.stylesheets.add(this.readTextContent(r, parent, ctx));
    }

    /*
     * Enabled aggressive block sorting
     */
    private String readTextContent(XMLStreamReader r, Figure parent, Context ctx) throws XMLStreamException {
        StringBuilder buf = new StringBuilder();
        int depth = 1;
        int eventType = r.next();
        while (eventType != 8) {
            switch (eventType) {
                case 4: 
                case 6: 
                case 12: {
                    if (depth != 1) break;
                    buf.append(r.getText());
                    break;
                }
                case 1: {
                    this.readElement(r, parent, ctx);
                    ++depth;
                    break;
                }
                case 2: {
                    if (--depth != 0) break;
                    return buf.toString();
                }
            }
            eventType = r.next();
        }
        return buf.toString();
    }

    private void readTitle(XMLStreamReader r, Figure parent, Context ctx) throws XMLStreamException {
        parent.set((MapAccessor)SvgElementFigure.TITLE_KEY, (Object)this.readTextContent(r, parent, ctx));
    }

    private void setSizeOfDrawing(Figure root) {
        CssSize w = (CssSize)root.getNonNull((NonNullMapAccessor)SvgDrawing.WIDTH);
        CssSize h = (CssSize)root.getNonNull((NonNullMapAccessor)SvgDrawing.HEIGHT);
        CssRectangle2D viewBox = (CssRectangle2D)root.get(SvgDrawing.SVG_VIEW_BOX);
        if ("%".equals(w.getUnits())) {
            root.set((MapAccessor)SvgDrawing.WIDTH, (Object)(viewBox == null || "%".equals(viewBox.getWidth().getUnits()) ? CssSize.of((double)640.0) : viewBox.getWidth()));
        }
        if ("%".equals(h.getUnits())) {
            root.set((MapAccessor)SvgDrawing.HEIGHT, (Object)(viewBox == null || "%".equals(viewBox.getHeight().getUnits()) ? CssSize.of((double)480.0) : viewBox.getHeight()));
        }
    }

    private void skipElement(XMLStreamReader r, Context ctx) throws XMLStreamException {
        int depth = 1;
        block4: while (true) {
            switch (r.next()) {
                case 1: {
                    if (SVG_NAMESPACE.equals(r.getNamespaceURI())) {
                        this.handleError(r, "Skipping element " + String.valueOf(r.getName()) + ".");
                    }
                    ++depth;
                    continue block4;
                }
                case 2: {
                    if (--depth != 0) continue block4;
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public List<String> getCopyOfErrors() {
        return new ArrayList<String>(this.errors);
    }

    static {
        LinkedHashMap<String, SequencedMap> mutableAccessorMap = new LinkedHashMap<String, SequencedMap>();
        LinkedHashMap<QName, Supplier<Figure>> mutableFigureMap = new LinkedHashMap<QName, Supplier<Figure>>();
        LinkedHashMap<Object, Object> mutableConverterMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry e : Arrays.asList(MapEntries.entry((Object)"svg", SvgDrawing.class), MapEntries.entry((Object)"g", SvgGFigure.class), MapEntries.entry((Object)"rect", SvgRectFigure.class), MapEntries.entry((Object)"defs", SvgDefsFigure.class), MapEntries.entry((Object)"circle", SvgCircleFigure.class), MapEntries.entry((Object)"ellipse", SvgEllipseFigure.class), MapEntries.entry((Object)"line", SvgLineFigure.class), MapEntries.entry((Object)"path", SvgPathFigure.class), MapEntries.entry((Object)"polygon", SvgPolygonFigure.class), MapEntries.entry((Object)"polyline", SvgPolylineFigure.class), MapEntries.entry((Object)"text", SvgTextFigure.class), MapEntries.entry((Object)"linearGradient", SvgLinearGradientFigure.class), MapEntries.entry((Object)"radialGradient", SvgRadialGradientFigure.class))) {
            SequencedMap m;
            String elem = (String)e.getKey();
            Class figureClass = (Class)e.getValue();
            Map m0 = Figure.getDeclaredAndInheritedMapAccessors((Class)figureClass).stream().collect(Collectors.toMap(MapAccessor::getName, Function.identity()));
            if (!m0.equals(m = (SequencedMap)Figure.getDeclaredAndInheritedMapAccessors((Class)figureClass).stream().collect(Collectors.toMap(MapAccessor::getName, Function.identity(), (a, b) -> a, LinkedHashMap::new)))) {
                throw new RuntimeException("m0!=m");
            }
            mutableAccessorMap.put(elem, m);
            for (MapAccessor acc : m.values()) {
                if (!(acc instanceof ReadOnlyStyleableMapAccessor)) continue;
                ReadOnlyStyleableMapAccessor rosma = (ReadOnlyStyleableMapAccessor)acc;
                mutableConverterMap.put(acc.getValueType(), rosma.getCssConverter());
            }
            mutableFigureMap.put(new QName(SVG_NAMESPACE, (String)e.getKey()), () -> {
                try {
                    return (Figure)figureClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        mutableConverterMap.put(String.class, new StringXmlConverter());
        mutableConverterMap.put(new SimpleParameterizedType(CssDefaultableValue.class, new Type[]{Paintable.class}), new DefaultableValueCssConverter((CssConverter)new SvgXmlPaintableConverter()));
        converterMap = Collections.unmodifiableMap(mutableConverterMap);
        figureMap = Collections.unmodifiableMap(mutableFigureMap);
        accessorMap = Collections.unmodifiableMap(mutableAccessorMap);
    }

    private static class Context {
        final SimpleIdFactory idFactory = new SimpleIdFactory();
        final List<CheckedRunnable> secondPass = new ArrayList<CheckedRunnable>();
        final List<String> stylesheets = new ArrayList<String>();
        final StringBuilder stringBuilder = new StringBuilder();

        private Context() {
        }
    }
}

