/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.text;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class SvgTransformConverter
extends AbstractCssConverter<Transform> {
    public SvgTransformConverter(boolean nullable) {
        super(nullable);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected <TT extends Transform> void produceTokensNonNull(TT tx, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        if (tx instanceof Translate) {
            Translate tr = (Translate)tx;
            out.accept(new CssToken(-18, "translate"));
            out.accept(new CssToken(-9, (Number)tr.getTx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tr.getTy()));
            out.accept(new CssToken(41));
            return;
        }
        if (tx instanceof Scale) {
            Scale ts = (Scale)tx;
            if (((Scale)tx).getPivotX() == 0.0 && ((Scale)tx).getPivotY() == 0.0) {
                out.accept(new CssToken(-18, "scale"));
                out.accept(new CssToken(-9, (Number)ts.getX()));
                if (ts.getY() != ts.getX() || ts.getZ() != 1.0 || ts.getPivotX() != 0.0 || ts.getPivotY() != 0.0) {
                    out.accept(new CssToken(44));
                    out.accept(new CssToken(-9, (Number)ts.getY()));
                }
                out.accept(new CssToken(41));
                return;
            }
        }
        if (!(tx instanceof Rotate)) {
            if (!tx.isType2D()) throw new UnsupportedOperationException("Unsupported transformation " + String.valueOf(tx));
            out.accept(new CssToken(-18, "matrix"));
            out.accept(new CssToken(-9, (Number)tx.getMxx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMyx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMxy()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getMyy()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getTx()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tx.getTy()));
            out.accept(new CssToken(41));
            return;
        }
        Rotate tr = (Rotate)tx;
        out.accept(new CssToken(-18, "rotate"));
        out.accept(new CssToken(-9, (Number)tr.getAngle()));
        if (tr.getPivotX() != 0.0 || tr.getPivotY() != 0.0) {
            out.accept(new CssToken(44));
            out.accept(new CssToken(-16, " "));
            out.accept(new CssToken(-9, (Number)tr.getPivotX()));
            out.accept(new CssToken(44));
            out.accept(new CssToken(-9, (Number)tr.getPivotY()));
        }
        out.accept(new CssToken(41));
    }

    public @Nullable String getHelpText() {
        return "Format of \u27e8Transform\u27e9: \u27e8Translate\u27e9\uff5c\u27e8Scale\u27e9\uff5c\u27e8Rotate\u27e9\uff5c\u27e8SkewX\u27e9\uff5c\u27e8SkewY\u27e9\uff5c\u27e8Matrix\u27e9\nFormat of \u27e8Translate\u27e9: translate(\u27e8tx\u27e9,\u27e8ty\u27e9)\nFormat of \u27e8Scale\u27e9: scale(\u27e8sx\u27e9,\u27e8sy\u27e9)\nFormat of \u27e8Rotate\u27e9: rotate(\u27e8angle\u27e9\uff3b,\u27e8pivotx\u27e9,\u27e8pivoty\u27e9\uff3d)\nFormat of \u27e8SkewX\u27e9: skewX(\u27e8skew-angle\u27e9)\nFormat of \u27e8SkewY\u27e9: skewY(\u27e8skew-angle\u27e9)\nFormat of \u27e8Matrix\u27e9: matrix(\u27e8xx\u27e9,\u27e8yx\u27e9, \u27e8xy\u27e9,\u27e8yy\u27e9, \u27e8tx\u27e9,\u27e8ty\u27e9)";
    }

    public Transform parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        tt.requireNextToken(-18, "\u27e8Transform\u27e9: function expected");
        String func = tt.currentStringNonNull();
        int funcPos = tt.getStartPosition();
        ArrayList<Double> m = new ArrayList<Double>();
        while (tt.next() != 41 && tt.current() != -1) {
            if (tt.current() != 44) {
                tt.pushBack();
            }
            if (tt.next() != -9) {
                throw new ParseException("coefficient nb " + m.size() + " expected: \"" + tt.currentString() + "\"", tt.getStartPosition());
            }
            m.add(tt.currentNumberNonNull().doubleValue());
        }
        if (tt.current() != 41) {
            throw new ParseException("')' expected: \"" + tt.currentString() + "\"", tt.getStartPosition());
        }
        switch (func) {
            case "matrix": {
                return switch (m.size()) {
                    case 0 -> new Affine(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
                    case 6 -> new Affine(((Double)m.get(0)).doubleValue(), ((Double)m.get(2)).doubleValue(), ((Double)m.get(4)).doubleValue(), ((Double)m.get(1)).doubleValue(), ((Double)m.get(3)).doubleValue(), ((Double)m.get(5)).doubleValue());
                    default -> throw new ParseException("6 or 12 coefficients expected, but found " + m.size(), tt.getStartPosition());
                };
            }
            case "skewX": {
                return switch (m.size()) {
                    case 0 -> Transform.translate((double)0.0, (double)0.0);
                    case 1 -> {
                        double a = (Double)m.getFirst();
                        yield Transform.affine((double)1.0, (double)0.0, (double)Math.tan(a), (double)1.0, (double)0.0, (double)0.0);
                    }
                    default -> throw new ParseException("1 coefficient expected, but found " + m.size(), tt.getStartPosition());
                };
            }
            case "skewY": {
                return switch (m.size()) {
                    case 0 -> Transform.translate((double)0.0, (double)0.0);
                    case 1 -> {
                        double a = (Double)m.getFirst();
                        yield Transform.affine((double)1.0, (double)Math.tan(a), (double)0.0, (double)1.0, (double)0.0, (double)0.0);
                    }
                    default -> throw new ParseException("1 coefficient expected, but found " + m.size(), tt.getStartPosition());
                };
            }
            case "translate": {
                return switch (m.size()) {
                    case 0 -> Transform.translate((double)0.0, (double)0.0);
                    case 1 -> Transform.translate((double)((Double)m.get(0)), (double)0.0);
                    case 2 -> Transform.translate((double)((Double)m.get(0)), (double)((Double)m.get(1)));
                    default -> throw new ParseException("1, 2 or 3 coefficients expected, but found " + m.size(), tt.getStartPosition());
                };
            }
            case "scale": {
                return switch (m.size()) {
                    case 0 -> Transform.scale((double)1.0, (double)1.0);
                    case 1 -> Transform.scale((double)((Double)m.get(0)), (double)((Double)m.get(0)));
                    case 2 -> Transform.scale((double)((Double)m.get(0)), (double)((Double)m.get(1)));
                    default -> throw new ParseException("1, 2, or 3 coefficients expected, but found " + m.size(), tt.getStartPosition());
                };
            }
            case "rotate": {
                return switch (m.size()) {
                    case 0 -> Transform.rotate((double)0.0, (double)0.0, (double)0.0);
                    case 1 -> Transform.rotate((double)((Double)m.get(0)), (double)0.0, (double)0.0);
                    case 3 -> Transform.rotate((double)((Double)m.get(0)), (double)((Double)m.get(1)), (double)((Double)m.get(2)));
                    default -> throw new ParseException("1 or 3 coefficients expected, but found " + m.size(), tt.getStartPosition());
                };
            }
        }
        throw new ParseException("unsupported function: \"" + func + "\"", funcPos);
    }
}

