/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.theme;

import javafx.application.Application;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.paint.Color;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.theme.SimpleThemeParameters;
import org.jhotdraw8.theme.Theme;
import org.jhotdraw8.theme.ThemeManager;
import org.jhotdraw8.theme.ThemeParameters;

public class SimpleThemeManager
implements ThemeManager {
    private final @NonNull ObjectProperty<Theme> theme = new SimpleObjectProperty((Object)this, "theme", null);
    private final @NonNull ObjectProperty<ThemeParameters> themeParameters = new SimpleObjectProperty((Object)this, "themeParameters", (Object)new SimpleThemeParameters());
    private final @NonNull ReadOnlyListWrapper<Theme> themes = new ReadOnlyListWrapper((Object)this, "themes", FXCollections.observableArrayList());
    private final @NonNull ObservableValue<Number> viaFontSize = CustomBinding.via(this.themeParameters, ThemeParameters::fontSizeProperty);
    private final @NonNull ObservableValue<Color> viaAccentColor = CustomBinding.via(this.themeParameters, ThemeParameters::accentColorProperty);

    public SimpleThemeManager() {
        InvalidationListener invalidationListener = o -> this.updateUserAgentStylesheet();
        this.theme.addListener(invalidationListener);
        this.viaFontSize.addListener(invalidationListener);
        this.viaAccentColor.addListener(invalidationListener);
    }

    @Override
    public void updateUserAgentStylesheet() {
        Theme theme = this.getTheme();
        if (theme == null) {
            Application.setUserAgentStylesheet(null);
        } else {
            Application.setUserAgentStylesheet((String)theme.createUserAgentStylesheet(this.getThemeParameters()));
        }
    }

    @Override
    public @NonNull ReadOnlyListProperty<Theme> themesProperty() {
        return this.themes;
    }

    @Override
    public @NonNull ObjectProperty<Theme> themeProperty() {
        return this.theme;
    }

    @Override
    public @NonNull ObjectProperty<ThemeParameters> themeParametersProperty() {
        return this.themeParameters;
    }
}

