/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.theme.atlantafx;

import javafx.scene.paint.Color;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.color.FXColorUtil;
import org.jhotdraw8.color.OKLchColorSpace;
import org.jhotdraw8.theme.AbstractTheme;
import org.jhotdraw8.theme.Theme;
import org.jhotdraw8.theme.ThemeParameters;

public abstract class AbstractAtlantaFXTheme
extends AbstractTheme {
    private final String uaStylesheetUrl;

    protected AbstractAtlantaFXTheme(String name, String appearance, String uaStylesheetUrl) {
        super(name, appearance);
        this.uaStylesheetUrl = uaStylesheetUrl;
    }

    @Override
    public String createUserAgentStylesheet(@NonNull ThemeParameters params) {
        StringBuilder buf = new StringBuilder();
        buf.append("@import \"").append(this.uaStylesheetUrl).append("\";\n");
        buf.append(".root {\n");
        buf.append("-fx-font-size:").append(params.getFontSize()).append("px;\n");
        Color accentColor = params.getAccentColor() == null ? Color.BLACK : params.getAccentColor();
        OKLchColorSpace cs = new OKLchColorSpace();
        float[] lch = cs.fromRGB(new float[]{(float)accentColor.getRed(), (float)accentColor.getGreen(), (float)accentColor.getBlue()});
        float[] rgb = new float[3];
        switch (this.getAppearance()) {
            case "Light": {
                if (!(lch[0] > 0.4f)) break;
                lch[0] = 0.4f;
                cs.toRGB(lch, rgb);
                accentColor = new Color((double)rgb[0], (double)rgb[1], (double)rgb[2], 1.0);
                break;
            }
            case "Dark": {
                if (!(lch[0] < 0.6f)) break;
                lch[0] = 0.6f;
                cs.toRGB(lch, rgb);
                accentColor = new Color((double)rgb[0], (double)rgb[1], (double)rgb[2], 1.0);
            }
        }
        Color accentColorMuted = new Color(accentColor.getRed(), accentColor.getGreen(), accentColor.getBlue(), 0.4);
        Color accentColorSubtle = new Color(accentColor.getRed(), accentColor.getGreen(), accentColor.getBlue(), 0.2);
        String accentColorStr = FXColorUtil.toWebColor((Color)accentColor);
        buf.append("-fx-accent:").append(accentColorStr).append(";\n");
        int count = 10;
        for (int idx = 0; idx < count; ++idx) {
            lch[0] = (float)(count + 1 - idx) / (float)(count + 2);
            cs.toRGB(lch, rgb);
            Color cc = new Color((double)rgb[0], (double)rgb[1], (double)rgb[2], 1.0);
            buf.append("-color-accent-").append(idx).append(":").append(FXColorUtil.toWebColor((Color)cc)).append(";\n");
        }
        buf.append("-color-accent-fg:").append(accentColorStr).append(";\n");
        buf.append("-color-accent-emphasis:").append(accentColorStr).append(";\n");
        buf.append("-color-accent-muted:").append(FXColorUtil.toWebColor((Color)accentColorMuted)).append(";\n");
        buf.append("-color-accent-subtle:").append(FXColorUtil.toWebColor((Color)accentColorSubtle)).append(";\n");
        buf.append("}\n");
        String customCss = params.getApplicationSpecificCss();
        if (customCss != null) {
            buf.append(customCss);
        }
        return Theme.toDataUrl(buf.toString());
    }
}

