/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;

public class FloatXmlConverter
implements Converter<Float> {
    private final boolean usesScientificNotation = true;
    private final @NonNull DecimalFormat decimalFormat = new DecimalFormat("#################0.#######", new DecimalFormatSymbols(Locale.ENGLISH));
    private final @NonNull DecimalFormat scientificFormat = new DecimalFormat("0.0########E0", new DecimalFormatSymbols(Locale.ENGLISH));
    private final int minNegativeExponent = -3;
    private final int minPositiveExponent = 7;
    private final boolean nullable;

    public FloatXmlConverter(boolean nullable) {
        this.nullable = nullable;
    }

    public FloatXmlConverter() {
        this(false);
    }

    public boolean getAllowsNullValue() {
        return this.nullable;
    }

    public @Nullable Float fromString(@NonNull CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        String str = in.toString();
        try {
            if (str.strip().length() != str.length()) {
                throw new NumberFormatException();
            }
            Float result = switch (str) {
                case "-INF" -> Float.valueOf(Float.NEGATIVE_INFINITY);
                case "INF" -> Float.valueOf(Float.POSITIVE_INFINITY);
                case "NaN" -> Float.valueOf(Float.NaN);
                case "" -> {
                    if (!this.nullable) {
                        throw new NumberFormatException();
                    }
                    yield null;
                }
                default -> {
                    float v = Float.parseFloat(str);
                    if (!Float.isFinite(v)) {
                        throw new NumberFormatException();
                    }
                    yield Float.valueOf(v);
                }
            };
            in.position(in.length());
            return result;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Illegal float value: \"" + str + "\"", 0);
        }
    }

    public <TT extends Float> void toString(Appendable buf, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (value == null) {
            return;
        }
        float v = value.floatValue();
        if (Float.isInfinite(v)) {
            if ((double)v < 0.0) {
                buf.append('-');
            }
            buf.append("INF");
        } else if (Float.isNaN(v)) {
            buf.append("NaN");
        } else {
            String str;
            double exponent;
            double d = exponent = v == 0.0f ? 0.0 : Math.log10(Math.abs(v));
            if (exponent > -3.0 && exponent < 7.0) {
                str = Float.toString(v);
                int exponentIndex = str.indexOf(69);
                int pointIndex = str.indexOf(46);
                int fractionDigits = (exponentIndex == -1 ? str.length() : exponentIndex) - pointIndex;
                if (str.endsWith(".0")) {
                    str = str.substring(0, str.length() - 2);
                }
                if (exponentIndex >= 0 || fractionDigits > this.decimalFormat.getMaximumFractionDigits()) {
                    str = this.decimalFormat.format(v);
                }
            } else {
                str = this.scientificFormat.format(v);
            }
            buf.append(str);
        }
    }

    public @Nullable Float getDefaultValue() {
        return Float.valueOf(0.0f);
    }
}

