/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import java.util.logging.Logger;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;

public class ObjectReferenceXmlConverter<T>
implements Converter<T> {
    private static final @NonNull Logger LOGGER = Logger.getLogger(ObjectReferenceXmlConverter.class.getName());
    private final @NonNull Class<T> clazz;

    public ObjectReferenceXmlConverter(@NonNull Class<T> clazz) {
        this.clazz = clazz;
    }

    public <TT extends T> void toString(@NonNull Appendable out, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (idSupplier == null) {
            throw new IllegalArgumentException("IdSupplier is required for this converter");
        }
        out.append(value == null ? "none" : idSupplier.getId(value));
    }

    public @Nullable T fromString(@NonNull CharBuffer buf, @Nullable IdResolver idResolver) throws ParseException {
        return this.fromString(buf.toString(), idResolver);
    }

    public @Nullable T fromString(@Nullable CharSequence buf, @Nullable IdResolver idResolver) {
        Object value;
        String str;
        if (idResolver == null) {
            throw new IllegalArgumentException("IdResolver is required for this converter");
        }
        String string = str = buf == null ? "none" : buf.toString();
        if ("none".equals(str)) {
            return null;
        }
        Object obj = idResolver.getObject(str);
        Object object = value = this.clazz.isInstance(obj) ? obj : null;
        if (value == null) {
            LOGGER.warning("Could not find an object with id=\"" + str + "\".");
        }
        return (T)value;
    }

    public @Nullable T getDefaultValue() {
        return null;
    }

    public boolean needsIdResolver() {
        return true;
    }
}

