/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class WordListXmlConverter
implements Converter<ImmutableList<String>> {
    public static final Comparator<String> NFD_COMPARATOR = Comparator.comparing(o -> Normalizer.normalize(o, Normalizer.Form.NFD));

    public <TT extends ImmutableList<String>> void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (value == null) {
            return;
        }
        TreeSet<String> tree = new TreeSet<String>(NFD_COMPARATOR);
        tree.addAll(value.asList());
        boolean isFirst = true;
        for (String s : tree) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.append(" ");
            }
            out.append(s);
        }
    }

    public ImmutableList<String> fromString(@NonNull CharBuffer buf, @Nullable IdResolver idResolver) {
        TreeSet<String> tree = new TreeSet<String>(NFD_COMPARATOR);
        tree.addAll(Arrays.asList(buf.toString().split("\\s+")));
        buf.position(buf.length());
        return VectorList.copyOf(tree);
    }

    public @Nullable ImmutableList<String> getDefaultValue() {
        return VectorList.of();
    }
}

