/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class IndentingXMLStreamWriter
implements XMLStreamWriter,
AutoCloseable {
    public static final String DEFAULT_NAMESPACE = "";
    public static final String DEFAULT_PREFIX = "";
    public static final String END_CHAR_REF = ";";
    public static final String END_ENTITY_REF = ";";
    public static final String END_PROCESSING_INSTRUCTION = "?>";
    public static final String START_CHAR_REF = "&#x";
    public static final String START_ENTITY_REF = "&";
    public static final String START_PROCESSING_INSTRUCTION = "<?";
    private static final String CLOSE_EMPTY_ELEMENT = "/>";
    private static final String CLOSE_END_TAG = ">";
    private static final String CLOSE_START_TAG = ">";
    private static final String DEFAULT_XML_VERSION = "1.0";
    private static final String END_ATTRIBUTE_VALUE = "\"";
    private static final String END_CDATA = "]]>";
    private static final String END_COMMENT = "-->";
    private static final String END_ENCODING = "\"";
    private static final String END_VERSION = "\"";
    private static final String END_XML_DECLARATION = "?>";
    private static final String OPEN_END_TAG = "</";
    private static final String OPEN_START_TAG = "<";
    private static final String PREFIX_SEPARATOR = ":";
    private static final String SPACE = " ";
    private static final String STANDALONE = " standalone=\"no\"";
    private static final String START_ATTRIBUTE_VALUE = "=\"";
    private static final String START_CDATA = "<![CDATA[";
    private static final String START_COMMENT = "<!--";
    private static final String START_ENCODING = " encoding=\"";
    private static final String START_VERSION = " version=\"";
    private static final String START_XML_DECLARATION = "<?xml";
    private static final String XMLNS_NAMESPACE = "https://www.w3.org/TR/REC-xml-names/";
    private static final String XMLNS_PREFIX = "xmlns";
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XML_SPACE_ATTRIBUTE = "space";
    private static final String XML_SPACE_PRESERVE_VALUE = "preserve";
    private final StringBuffer charBuffer = new StringBuffer();
    private final CharsetEncoder encoder;
    private final Deque<Element> stack = new ArrayDeque<Element>();
    private final Writer w;
    private Set<Attribute> attributes = new TreeSet<Attribute>(Comparator.comparing(Attribute::namespace).thenComparing(Attribute::localName));
    private boolean escapeClosingAngleBracket = true;
    private boolean escapeLineBreak = true;
    private boolean hasContent;
    private String indentation = "  ";
    private boolean isFirstWrite = true;
    private boolean isStartTagOpen = false;
    private String lineSeparator = "\n";

    public IndentingXMLStreamWriter(@NonNull Writer w) {
        this.w = w;
        this.encoder = StandardCharsets.UTF_8.newEncoder();
        this.stack.push(new Element("", "", "<root>", false));
    }

    public IndentingXMLStreamWriter(OutputStream out) {
        this(out, StandardCharsets.UTF_8);
    }

    public IndentingXMLStreamWriter(OutputStream out, Charset charset) {
        this.w = new BufferedWriter(new OutputStreamWriter(out, charset));
        this.encoder = charset.newEncoder();
        this.stack.push(new Element("", "", "<root>", false));
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.w.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void closeStartTagOrCloseEmptyElemTag() throws XMLStreamException {
        this.charBuffer.setLength(0);
        if (this.isStartTagOpen) {
            this.isStartTagOpen = false;
            this.doWriteAttributes();
            Element peeked = this.stack.peek();
            if (peeked != null) {
                if (peeked.isEmpty()) {
                    this.write(CLOSE_EMPTY_ELEMENT);
                    this.stack.pop();
                } else {
                    this.write(">");
                }
            }
        }
    }

    private void doWriteAttribute(@NonNull Attribute attribute) throws XMLStreamException {
        String prefix;
        this.write(SPACE);
        String string = prefix = attribute.prefix() == null ? this.getPrefixNonNull(attribute.namespace()) : attribute.prefix();
        if (!prefix.equals("")) {
            this.write(prefix);
            this.write(PREFIX_SEPARATOR);
        }
        this.write(attribute.localName());
        this.write(START_ATTRIBUTE_VALUE);
        this.writeXmlContent(attribute.value, true, false);
        this.write("\"");
    }

    private void doWriteAttributes() throws XMLStreamException {
        for (Attribute attribute : this.attributes) {
            this.doWriteAttribute(attribute);
        }
        this.attributes.clear();
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.w.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public String getIndentation() {
        return this.indentation;
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.stack.getLast().namespaceContext;
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) {
        this.stack.getLast().namespaceContext = context;
    }

    private MyNamespaceContext getOrCreateNamespaceContext() {
        MyNamespaceContext ctx;
        Element element = this.stack.getFirst();
        if (element.namespaceContext instanceof MyNamespaceContext) {
            ctx = (MyNamespaceContext)element.namespaceContext;
        } else {
            ctx = new MyNamespaceContext();
            element.namespaceContext = ctx;
        }
        return ctx;
    }

    @Override
    public @Nullable String getPrefix(@NonNull String uri) {
        Objects.requireNonNull(uri, "uri");
        for (Element element : this.stack) {
            String prefix;
            if (element.namespaceContext == null || (prefix = element.namespaceContext.getPrefix(uri)) == null) continue;
            return prefix;
        }
        return null;
    }

    private @NonNull String getPrefixNonNull(@NonNull String uri) {
        String prefix = this.getPrefix(uri);
        return prefix == null ? "" : prefix;
    }

    @Override
    public @Nullable Object getProperty(@NonNull String name) throws IllegalArgumentException {
        Objects.requireNonNull(name, "name");
        throw new IllegalArgumentException("unsupported property: " + name);
    }

    private boolean hasContent() {
        return this.hasContent;
    }

    private boolean isBlank(char[] text, int start, int length) {
        char ch;
        int left;
        for (left = 0; left < length && Character.isWhitespace(ch = text[start + left]); ++left) {
        }
        return left == length;
    }

    public boolean isEscapeClosingAngleBracket() {
        return this.escapeClosingAngleBracket;
    }

    public void setEscapeClosingAngleBracket(boolean b) {
        this.escapeClosingAngleBracket = b;
    }

    public boolean isEscapeLineBreak() {
        return this.escapeLineBreak;
    }

    public void setEscapeLineBreak(boolean escapeLineBreak) {
        this.escapeLineBreak = escapeLineBreak;
    }

    public boolean isPreserveSpace() {
        return this.stack.getFirst().isPreserveSpace();
    }

    public void setPreserveSpace(boolean preserveSpace) {
        this.stack.getFirst().setPreserveSpace(preserveSpace);
    }

    public boolean isSortAttributes() {
        return this.attributes instanceof SortedSet;
    }

    public void setSortAttributes(boolean b) {
        this.attributes = b ? new TreeSet<Attribute>(Comparator.comparing(Attribute::namespace).thenComparing(Attribute::localName)) : new LinkedHashSet();
    }

    private void requireStartTagOpened() {
        if (!this.isStartTagOpen) {
            throw new IllegalStateException("There is currently no open start tag.");
        }
    }

    @Override
    public void setDefaultNamespace(String uri) {
        this.getOrCreateNamespaceContext().setNamespace(uri, "");
    }

    public void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        this.requireStartTagOpened();
        this.getOrCreateNamespaceContext().setNamespace(uri, prefix);
    }

    private void write(String str) throws XMLStreamException {
        try {
            this.isFirstWrite = false;
            this.w.write(str);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void write(char ch) throws XMLStreamException {
        try {
            this.isFirstWrite = false;
            this.w.write(ch);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) {
        this.requireStartTagOpened();
        this.attributes.add(new Attribute("", "", localName, value));
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.requireStartTagOpened();
        if (!this.attributes.add(new Attribute(prefix, namespaceURI, localName, value))) {
            throw new XMLStreamException("Attribute already added: " + localName);
        }
        if (XML_NAMESPACE.equals(namespaceURI) && XML_SPACE_ATTRIBUTE.equals(localName)) {
            this.setPreserveSpace(XML_SPACE_PRESERVE_VALUE.equals(value));
        }
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.requireStartTagOpened();
        if (!this.attributes.add(new Attribute("", namespaceURI, localName, value))) {
            throw new XMLStreamException("Attribute already added: " + localName);
        }
        if (XML_NAMESPACE.equals(namespaceURI) && XML_SPACE_ATTRIBUTE.equals(localName)) {
            this.setPreserveSpace(XML_SPACE_PRESERVE_VALUE.equals(value));
        }
    }

    @Override
    public void writeCData(@NonNull String data) throws XMLStreamException {
        Objects.requireNonNull(data, "data");
        if (data.contains(END_CDATA)) {
            throw new XMLStreamException("CData must not contain \"]]>\", CData: " + data);
        }
        this.setHasContent(true);
        this.closeStartTagOrCloseEmptyElemTag();
        this.write(START_CDATA);
        this.write(data);
        this.write(END_CDATA);
    }

    private void writeCharRef(int codePoint) throws XMLStreamException {
        this.write(START_CHAR_REF);
        this.write(Integer.toHexString(codePoint).toUpperCase());
        this.write(";");
    }

    @Override
    public void writeCharacters(@NonNull String text) throws XMLStreamException {
        Objects.requireNonNull(text, "text");
        this.closeStartTagOrCloseEmptyElemTag();
        if (!this.isPreserveSpace() && !this.hasContent() && text.trim().isEmpty()) {
            this.charBuffer.append(text);
            return;
        }
        this.setHasContent(true);
        if (!this.charBuffer.isEmpty()) {
            this.writeXmlContent(this.charBuffer.toString(), false, false);
            this.charBuffer.setLength(0);
        }
        this.writeXmlContent(text, false, false);
    }

    @Override
    public void writeCharacters(char @NonNull [] text, int start, int len) throws XMLStreamException {
        Objects.requireNonNull(text, "text");
        Objects.checkFromIndexSize(start, len, text.length);
        this.closeStartTagOrCloseEmptyElemTag();
        if (!this.isPreserveSpace() && !this.hasContent() && this.isBlank(text, start, len)) {
            this.charBuffer.append(text, start, len);
            return;
        }
        this.setHasContent(true);
        if (!this.charBuffer.isEmpty()) {
            this.writeXmlContent(this.charBuffer.toString(), false, false);
            this.charBuffer.setLength(0);
        }
        this.writeXmlContent(text, start, len, false, false);
    }

    @Override
    public void writeComment(@NonNull String data) throws XMLStreamException {
        Objects.requireNonNull(data, "data");
        int n = this.charBuffer.length();
        for (int i = 0; i < n; ++i) {
            if (this.charBuffer.charAt(i) != '\n') continue;
            this.write('\n');
        }
        this.charBuffer.setLength(0);
        this.closeStartTagOrCloseEmptyElemTag();
        this.stack.push(new Element("", "", START_COMMENT, true));
        if (!this.hasContent && !this.isFirstWrite) {
            this.writeLineBreakAndIndentation();
        }
        this.write(START_COMMENT);
        this.writeXmlContent(data, false, true);
        this.write(END_COMMENT);
        this.setHasContent(false);
        this.stack.pop();
    }

    @Override
    public void writeDTD(@NonNull String dtd) throws XMLStreamException {
        Objects.requireNonNull(dtd, "dtd");
        this.closeStartTagOrCloseEmptyElemTag();
        this.write(dtd);
    }

    @Override
    public void writeDefaultNamespace(@Nullable String namespaceURI) {
        this.requireStartTagOpened();
        if (namespaceURI == null || namespaceURI.isEmpty()) {
            this.setPrefix("", "");
        } else {
            this.setPrefix("", namespaceURI);
            this.attributes.add(new Attribute("", XMLNS_NAMESPACE, XMLNS_PREFIX, namespaceURI));
        }
    }

    @Override
    public void writeEmptyElement(@NonNull String namespaceURI, @NonNull String localName) throws XMLStreamException {
        this.writeEmptyElement(this.getPrefixNonNull(namespaceURI), localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(@NonNull String prefix, @NonNull String localName, @NonNull String namespaceURI) throws XMLStreamException {
        this.closeStartTagOrCloseEmptyElemTag();
        Element e = new Element(prefix, namespaceURI, localName, true);
        this.stack.push(e);
        this.isStartTagOpen = true;
        this.setPrefix(prefix, namespaceURI);
        this.writeLineBreakAndIndentation();
        this.write(OPEN_START_TAG);
        if (!prefix.equals("")) {
            this.write(prefix);
            this.write(PREFIX_SEPARATOR);
        }
        this.write(localName);
    }

    @Override
    public void writeEmptyElement(@NonNull String localName) throws XMLStreamException {
        this.writeEmptyElement("", localName, "");
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.closeStartTagOrCloseEmptyElemTag();
        while (this.stack.size() > 1) {
            this.writeEndElement();
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this.stack.size() <= 1) {
            throw new XMLStreamException("no such element");
        }
        this.charBuffer.setLength(0);
        Element element = this.stack.pop();
        if (element.isEmpty()) {
            this.write(CLOSE_EMPTY_ELEMENT);
            element = this.stack.pop();
        }
        if (this.isStartTagOpen) {
            this.doWriteAttributes();
            this.write(CLOSE_EMPTY_ELEMENT);
            this.isStartTagOpen = false;
        } else {
            if (!this.hasContent) {
                this.writeEndElementLineBreakAndIndentation();
            }
            this.write(OPEN_END_TAG);
            String prefix = element.getPrefix();
            if (!prefix.isEmpty()) {
                this.write(prefix);
                this.write(PREFIX_SEPARATOR);
            }
            this.write(element.getLocalName());
            this.write(">");
        }
        this.hasContent = false;
    }

    private void writeEndElementLineBreakAndIndentation() throws XMLStreamException {
        this.write(this.lineSeparator);
        for (int i = this.stack.size() - 2; i >= 0; --i) {
            this.write(this.indentation);
        }
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        Objects.requireNonNull(name, "name");
        this.closeStartTagOrCloseEmptyElemTag();
        this.write(START_ENTITY_REF);
        this.write(name);
        this.write(";");
    }

    private void writeLineBreakAndIndentation() throws XMLStreamException {
        this.write(this.lineSeparator);
        for (int i = this.stack.size() - 3; i >= 0; --i) {
            this.write(this.indentation);
        }
    }

    @Override
    public void writeNamespace(@NonNull String prefix, @NonNull String namespaceURI) {
        Objects.requireNonNull(prefix, "prefix");
        Objects.requireNonNull(namespaceURI, "namespaceURI");
        this.requireStartTagOpened();
        this.attributes.add(new Attribute(prefix.isEmpty() || XMLNS_PREFIX.equals(prefix) ? "" : XMLNS_PREFIX, XMLNS_NAMESPACE, prefix.isEmpty() ? XMLNS_PREFIX : prefix, namespaceURI));
    }

    @Override
    public void writeProcessingInstruction(@NonNull String target) throws XMLStreamException {
        Objects.requireNonNull(target, "target");
        this.closeStartTagOrCloseEmptyElemTag();
        this.write(START_PROCESSING_INSTRUCTION);
        this.write(target);
        this.write("?>");
    }

    @Override
    public void writeProcessingInstruction(@NonNull String target, @NonNull String data) throws XMLStreamException {
        Objects.requireNonNull(target, "target");
        this.closeStartTagOrCloseEmptyElemTag();
        this.write(START_PROCESSING_INSTRUCTION);
        this.write(target);
        this.write(SPACE);
        this.write(data);
        this.write("?>");
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(this.encoder.charset().name(), DEFAULT_XML_VERSION);
    }

    @Override
    public void writeStartDocument(@NonNull String version) throws XMLStreamException {
        this.writeStartDocument(this.encoder.charset().name(), version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.write(START_XML_DECLARATION);
        this.write(START_VERSION);
        this.write(version);
        this.write("\"");
        this.write(START_ENCODING);
        this.write(encoding);
        this.write("\"");
        this.write(STANDALONE);
        this.write("?>");
    }

    @Override
    public void writeStartElement(@NonNull String localName) throws XMLStreamException {
        this.writeStartElement("", localName, "");
    }

    @Override
    public void writeStartElement(@NonNull String namespaceURI, @NonNull String localName) throws XMLStreamException {
        this.writeStartElement(this.getPrefixNonNull(namespaceURI), localName, namespaceURI);
    }

    @Override
    public void writeStartElement(@NonNull String prefix, @NonNull String localName, @NonNull String namespaceURI) throws XMLStreamException {
        this.closeStartTagOrCloseEmptyElemTag();
        Element e = new Element(prefix, namespaceURI, localName, false);
        e.setPreserveSpace(this.stack.getFirst().isPreserveSpace());
        this.stack.push(e);
        this.isStartTagOpen = true;
        this.setPrefix(prefix, namespaceURI);
        if (!this.isPreserveSpace() && !this.hasContent) {
            this.writeLineBreakAndIndentation();
        }
        this.write(OPEN_START_TAG);
        if (!prefix.equals("")) {
            this.write(prefix);
            this.write(PREFIX_SEPARATOR);
        }
        this.write(localName);
        this.hasContent = false;
    }

    private void writeXmlContent(char[] data, int start, int len, boolean isDoubleQuoted, boolean isComment) throws XMLStreamException {
        this.writeXmlContent(new String(data, start, len), isDoubleQuoted, isComment);
    }

    private void writeXmlContent(String content, boolean isDoubleQuoted, boolean isComment) throws XMLStreamException {
        int end = content.length();
        block9: for (int index = 0; index < end; ++index) {
            char ch = content.charAt(index);
            if (!this.encoder.canEncode(ch)) {
                if (index != end - 1 && Character.isSurrogatePair(ch, content.charAt(index + 1))) {
                    this.writeCharRef(Character.toCodePoint(ch, content.charAt(index + 1)));
                    ++index;
                    continue;
                }
                this.writeCharRef(ch);
                continue;
            }
            if (isDoubleQuoted && (Character.isWhitespace(ch) && ch != ' ' || Character.isISOControl(ch) || index != end - 1 && Character.isSurrogatePair(ch, content.charAt(index + 1)) && Character.isISOControl(Character.toCodePoint(ch, content.charAt(index + 1)))) && (this.escapeLineBreak || ch != '\n')) {
                this.writeCharRef(ch);
                continue;
            }
            switch (ch) {
                case '\r': {
                    this.write("&xD;");
                    continue block9;
                }
                case '\n': {
                    if (isComment) {
                        this.writeLineBreakAndIndentation();
                        while (index < end - 1 && '\n' != content.charAt(index + 1) && Character.isWhitespace(content.charAt(index + 1))) {
                            ++index;
                        }
                        continue block9;
                    }
                    this.write('\n');
                    continue block9;
                }
                case '<': {
                    if (isComment) {
                        this.write('<');
                        continue block9;
                    }
                    this.write("&lt;");
                    continue block9;
                }
                case '&': {
                    if (isComment) {
                        this.write('&');
                        continue block9;
                    }
                    this.write("&amp;");
                    continue block9;
                }
                case '-': {
                    if (isComment && index < end - 1 && content.charAt(index + 1) == '-') {
                        ++index;
                        this.writeCharRef(45);
                        this.writeCharRef(45);
                        continue block9;
                    }
                    this.write(ch);
                    continue block9;
                }
                case '>': {
                    if (isComment || !this.escapeClosingAngleBracket || isDoubleQuoted) {
                        this.write('>');
                        continue block9;
                    }
                    this.write("&gt;");
                    continue block9;
                }
                case '\"': {
                    if (isDoubleQuoted) {
                        this.write("&quot;");
                        continue block9;
                    }
                    this.write(ch);
                    continue block9;
                }
                default: {
                    this.write(ch);
                }
            }
        }
    }

    private static class Element {
        private final boolean isEmpty;
        private final @NonNull String localName;
        private final @NonNull String namespaceUri;
        private final @NonNull String prefix;
        private NamespaceContext namespaceContext = new MyNamespaceContext();
        private boolean preserveSpace;

        public Element(@NonNull String prefix, @NonNull String namespaceUri, @NonNull String localName, boolean isEmpty) {
            this.prefix = prefix;
            this.namespaceUri = namespaceUri;
            this.localName = localName;
            this.isEmpty = isEmpty;
        }

        public @NonNull String getLocalName() {
            return this.localName;
        }

        public @NonNull String getPrefix() {
            return this.prefix;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        public boolean isPreserveSpace() {
            return this.preserveSpace;
        }

        public void setPreserveSpace(boolean preserveSpace) {
            this.preserveSpace = preserveSpace;
        }
    }

    private record Attribute(@Nullable String prefix, @NonNull String namespace, @NonNull String localName, @NonNull String value) {
    }

    private static class MyNamespaceContext
    implements NamespaceContext {
        private final Map<String, List<String>> nsToPrefix = new HashMap<String, List<String>>();
        private final Map<String, String> prefixToNs = new HashMap<String, String>();

        private MyNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(@NonNull String prefix) {
            return this.prefixToNs.get(prefix);
        }

        @Override
        public @NonNull String getPrefix(@NonNull String namespaceURI) {
            Objects.requireNonNull(namespaceURI, "namespaceURI");
            List<String> prefixes = this.nsToPrefix.get(namespaceURI);
            return prefixes == null || prefixes.isEmpty() ? "" : prefixes.getFirst();
        }

        @Override
        public Iterator<String> getPrefixes(@NonNull String namespaceURI) {
            Objects.requireNonNull(namespaceURI, "namespaceURI");
            List<String> prefixes = this.nsToPrefix.get(namespaceURI);
            return prefixes == null ? Collections.emptyIterator() : prefixes.iterator();
        }

        public void setNamespace(String uri, String prefix) {
            String oldNs = this.prefixToNs.put(prefix, uri);
            if (oldNs != null) {
                this.nsToPrefix.get(oldNs).removeIf(prefix::equals);
            }
            if ("".equals(prefix)) {
                this.nsToPrefix.computeIfAbsent(uri, k -> new ArrayList()).addFirst(prefix);
            } else {
                this.nsToPrefix.computeIfAbsent(uri, k -> new ArrayList()).add(prefix);
            }
        }
    }
}

