/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;

public class IntegerXmlConverter
implements Converter<Integer> {
    private final boolean nullable;

    public IntegerXmlConverter(boolean nullable) {
        this.nullable = nullable;
    }

    public IntegerXmlConverter() {
        this(false);
    }

    public @Nullable Integer fromString(@NonNull CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        String str = in.toString();
        try {
            if (in.isEmpty() && this.nullable) {
                return null;
            }
            int result = Integer.parseInt(str);
            in.position(in.length());
            return result;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Illegal integer value=\"" + str + "\".", 0);
        }
    }

    public <TT extends Integer> void toString(Appendable buf, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (value != null) {
            buf.append(Integer.toString(value.intValue()));
        }
    }

    public @Nullable Integer getDefaultValue() {
        return 0;
    }
}

