/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;

public class LongXmlConverter
implements Converter<Long> {
    private final boolean nullable;

    public LongXmlConverter(boolean nullable) {
        this.nullable = nullable;
    }

    public LongXmlConverter() {
        this(false);
    }

    public @Nullable Long fromString(@NonNull CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        try {
            if (in.isEmpty() && this.nullable) {
                return null;
            }
            long result = Long.parseLong(in.toString());
            in.position(in.length());
            return result;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Illegal double value.", 0);
        }
    }

    public <TT extends Long> void toString(Appendable buf, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (value != null) {
            buf.append(Long.toString(value.longValue()));
        }
    }

    public @Nullable Long getDefaultValue() {
        return 0L;
    }
}

