/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jhotdraw8.xml.IndentingXMLStreamWriter;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.helpers.XMLFilterImpl;

public class XmlUtil {
    public static final String LOCATION_ATTRIBUTE = "location";
    public static final String LOCATION_NAMESPACE = "http://location.xmlutil.ch";
    private static final String QUALIFIED_LOCATION_ATTRIBUTE = "xmlutil:location";
    private static final String SEPARATOR = "\u0000";
    private static final Properties DEFAULT_PROPERTIES = new Properties();
    public static final String HTTP_XML_APACHE_ORG_XALAN_LINE_SEPARATOR = "{http://xml.apache.org/xalan}line-separator";
    public static final String HTTP_XML_APACHE_ORG_XSLT_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    public static final String CANONICAL_LINE_SEPARATOR = "\n";

    private XmlUtil() {
    }

    public static Document createDocument(@Nullable String nsURI, @Nullable String nsQualifier, String docElemName) throws IOException {
        try {
            Document doc;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            if (nsURI != null) {
                builderFactory.setNamespaceAware(true);
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                DOMImplementation domImpl = builder.getDOMImplementation();
                doc = domImpl.createDocument(nsURI, (String)(nsQualifier == null ? docElemName : nsQualifier + ":" + docElemName), null);
            } else {
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                doc = builder.newDocument();
                Element elem = doc.createElement(docElemName);
                doc.appendChild(elem);
            }
            return doc;
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex);
        }
    }

    public static Document read(Reader in, boolean namespaceAware) throws IOException {
        InputSource inputSource = new InputSource(in);
        return XmlUtil.read(inputSource, namespaceAware);
    }

    public static Document read(InputStream in, boolean namespaceAware) throws IOException {
        InputSource inputSource = new InputSource(in);
        return XmlUtil.read(inputSource, namespaceAware);
    }

    public static Document read(Path in, boolean namespaceAware) throws IOException {
        InputSource inputSource = new InputSource(in.toUri().toASCIIString());
        return XmlUtil.read(inputSource, namespaceAware);
    }

    public static Document readWithLocations(Path in, boolean namespaceAware) throws IOException {
        InputSource inputSource = new InputSource(in.toUri().toASCIIString());
        return XmlUtil.readWithLocations(inputSource, namespaceAware);
    }

    public static Document read(InputSource inputSource, boolean namespaceAware) throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(namespaceAware);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver((publicId, systemId) -> null);
            return builder.parse(inputSource);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IOException(ex);
        }
    }

    public static Document readWithLocations(InputSource inputSource, boolean namespaceAware) throws IOException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(namespaceAware);
            XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
            LocationFilter locationFilter = new LocationFilter(xmlReader);
            SAXSource saxSource = new SAXSource(locationFilter, inputSource);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMResult domResult = new DOMResult();
            transformer.transform(saxSource, domResult);
            Node root = domResult.getNode();
            return (Document)root;
        }
        catch (ParserConfigurationException | TransformerException | SAXException ex) {
            throw new IOException(ex);
        }
    }

    public static @Nullable Locator getLocator(Node node) {
        String[] parts;
        Node attrNode;
        NamedNodeMap attributes = node.getAttributes();
        Node node2 = attrNode = attributes == null ? null : attributes.getNamedItemNS(LOCATION_NAMESPACE, LOCATION_ATTRIBUTE);
        if (attrNode != null && (parts = attrNode.getNodeValue().split(SEPARATOR)).length == 4) {
            return new MyLocator(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), parts[2], parts[3]);
        }
        return null;
    }

    public static void validate(Document doc, URI schemaUri) throws IOException {
        XmlUtil.validate(doc, schemaUri.toURL());
    }

    public static void validate(Document doc, URL schemaUrl) throws IOException {
        try (InputStream schemaStream = schemaUrl.openStream();){
            XmlUtil.validate(new DOMSource(doc), new StreamSource(schemaStream));
        }
    }

    public static void validate(Source docSource, Source schemaSource) throws IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = factory.newSchema(schemaSource);
            Validator validator = schema.newValidator();
            validator.validate(docSource);
        }
        catch (SAXException e) {
            throw new IOException("The document is invalid.\n" + e.getMessage(), e);
        }
    }

    public static void validate(Path xmlPath, URI schemaUri) throws IOException {
        XmlUtil.validate(new StreamSource(xmlPath.toUri().toString()), new StreamSource(schemaUri.toString()));
    }

    public static void validate(URI xmlUri, URI schemaUri) throws IOException {
        XmlUtil.validate(new StreamSource(xmlUri.toString()), new StreamSource(schemaUri.toString()));
    }

    public static void write(OutputStream out, Document doc) throws IOException {
        StreamResult result = new StreamResult(out);
        XmlUtil.write(result, doc);
    }

    public static void write(Writer out, Document doc) throws IOException {
        StreamResult result = new StreamResult(out);
        XmlUtil.write(result, doc);
    }

    public static void write(Path out, Document doc) throws IOException {
        XmlUtil.write(out, doc, DEFAULT_PROPERTIES);
    }

    public static void write(Path out, Document doc, Properties outputProperties) throws IOException {
        StreamResult result = new StreamResult(out.toFile());
        XmlUtil.write(result, doc, outputProperties);
    }

    public static void write(Result result, Document doc) throws IOException {
        XmlUtil.write(result, doc, DEFAULT_PROPERTIES);
    }

    public static void write(Result result, Document doc, @Nullable Properties outputProperties) throws IOException {
        try {
            result = XmlUtil.replaceStreamResultByStAXResult(result, outputProperties);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer t = factory.newTransformer();
            if (outputProperties != null) {
                t.setOutputProperties(outputProperties);
            }
            DOMSource source = new DOMSource(doc);
            t.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
    }

    public static XMLStreamWriter streamWriter(Result file, @Nullable Properties outputProperties) {
        return ((StAXResult)XmlUtil.replaceStreamResultByStAXResult(file, outputProperties)).getXMLStreamWriter();
    }

    public static XMLStreamReader streamReader(Source file) throws XMLStreamException {
        XMLInputFactory dbf = XMLInputFactory.newInstance();
        dbf.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        dbf.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        dbf.setProperty("javax.xml.stream.supportDTD", false);
        dbf.setXMLResolver((publicID, systemID, baseURI, namespace) -> null);
        return dbf.createXMLStreamReader(file);
    }

    private static Result replaceStreamResultByStAXResult(Result result, @Nullable Properties outputProperties) {
        if (outputProperties == null) {
            outputProperties = new Properties();
        }
        if (result instanceof StreamResult) {
            IndentingXMLStreamWriter w;
            StreamResult sr = (StreamResult)result;
            if (sr.getOutputStream() != null) {
                w = new IndentingXMLStreamWriter(sr.getOutputStream(), Charset.forName((String)outputProperties.getOrDefault((Object)"encoding", "UTF-8")));
            } else if (sr.getWriter() != null) {
                w = new IndentingXMLStreamWriter(sr.getWriter());
            } else {
                return result;
            }
            w.setSortAttributes(true);
            try {
                int indentation = Integer.parseInt((String)outputProperties.getOrDefault((Object)HTTP_XML_APACHE_ORG_XSLT_INDENT_AMOUNT, "2"));
                w.setIndentation(" ".repeat(indentation));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            w.setLineSeparator((String)outputProperties.getOrDefault((Object)HTTP_XML_APACHE_ORG_XALAN_LINE_SEPARATOR, CANONICAL_LINE_SEPARATOR));
            result = new StAXResult(w);
        }
        return result;
    }

    public static @Nullable String readNamespaceUri(URI file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(Paths.get(file), new OpenOption[0]));){
            String string = XmlUtil.readNamespaceUri(new StreamSource(in));
            return string;
        }
    }

    public static @Nullable String readNamespaceUri(Source source) throws IOException {
        try {
            XMLStreamReader r = XmlUtil.streamReader(source);
            block6: while (r.hasNext()) {
                int next = r.next();
                switch (next) {
                    case 1: {
                        return r.getNamespaceURI();
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        continue block6;
                    }
                }
                throw new IOException("unsupported XMLStream event: " + next);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return null;
    }

    static {
        DEFAULT_PROPERTIES.put("indent", "yes");
        DEFAULT_PROPERTIES.put("encoding", "UTF-8");
        DEFAULT_PROPERTIES.put(HTTP_XML_APACHE_ORG_XSLT_INDENT_AMOUNT, "2");
        DEFAULT_PROPERTIES.put(HTTP_XML_APACHE_ORG_XALAN_LINE_SEPARATOR, CANONICAL_LINE_SEPARATOR);
    }

    private static class LocationFilter
    extends XMLFilterImpl {
        private Locator locator = null;

        LocationFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Attributes2Impl attrs = new Attributes2Impl(attributes);
            attrs.addAttribute(XmlUtil.LOCATION_NAMESPACE, XmlUtil.LOCATION_ATTRIBUTE, XmlUtil.QUALIFIED_LOCATION_ATTRIBUTE, "CDATA", this.locator.getLineNumber() + XmlUtil.SEPARATOR + this.locator.getColumnNumber() + XmlUtil.SEPARATOR + this.locator.getSystemId() + XmlUtil.SEPARATOR + this.locator.getPublicId());
            super.startElement(uri, localName, qName, attrs);
        }
    }

    private record MyLocator(int line, int column, @Nullable String systemId, @Nullable String publicId) implements Locator
    {
        @Override
        public int getColumnNumber() {
            return this.column;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public @Nullable String getPublicId() {
            return this.publicId;
        }

        @Override
        public @Nullable String getSystemId() {
            return this.systemId;
        }
    }
}

