/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jspecify.annotations.Nullable;

public class BooleanXmlConverter
implements Converter<Boolean> {
    private final String trueString = "true";
    private final String emptyString = "";
    private final String falseString = "false";
    private final String oneString = "1";
    private final String zeroString = "0";
    private final boolean nullable;

    public BooleanXmlConverter(boolean nullable) {
        this.nullable = nullable;
    }

    public BooleanXmlConverter() {
        this(false);
    }

    public void toString(Appendable buf, @Nullable IdSupplier idSupplier, Boolean value) throws IOException {
        buf.append(value != false ? "true" : "false");
    }

    public @Nullable Boolean fromString(CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        String str = in.toString();
        in.position(in.length());
        switch (str) {
            case "true": 
            case "1": {
                return true;
            }
            case "false": 
            case "0": {
                return false;
            }
            case "": {
                if (!this.nullable) break;
                return null;
            }
        }
        throw new ParseException("\"true\", \"false\"\"1\", \"0\" expected instead of \"" + str + "\".", 0);
    }

    public @Nullable Boolean getDefaultValue() {
        return Boolean.FALSE;
    }
}

