/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jspecify.annotations.Nullable;

public class DoubleXmlConverter
implements Converter<Double> {
    private final boolean usesScientificNotation = true;
    private final DecimalFormat decimalFormat = new DecimalFormat("#################0.#################", new DecimalFormatSymbols(Locale.ENGLISH));
    private final DecimalFormat scientificFormat = new DecimalFormat("0.0################E0", new DecimalFormatSymbols(Locale.ENGLISH));
    private final int minNegativeExponent = -3;
    private final int minPositiveExponent = 7;
    private final boolean nullable;

    public DoubleXmlConverter(boolean nullable) {
        this.nullable = nullable;
    }

    public DoubleXmlConverter() {
        this(false);
    }

    public boolean getAllowsNullValue() {
        return this.nullable;
    }

    public @Nullable Double fromString(CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        String str = in.toString();
        try {
            if (str.strip().length() != str.length()) {
                throw new NumberFormatException();
            }
            Double result = switch (str) {
                case "-INF" -> Double.NEGATIVE_INFINITY;
                case "INF" -> Double.POSITIVE_INFINITY;
                case "NaN" -> Double.NaN;
                case "" -> {
                    if (!this.nullable) {
                        throw new NumberFormatException();
                    }
                    yield null;
                }
                default -> {
                    double v = Double.parseDouble(str);
                    if (!Double.isFinite(v)) {
                        throw new NumberFormatException();
                    }
                    yield v;
                }
            };
            in.position(in.length());
            return result;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Illegal double value: \"" + str + "\"", 0);
        }
    }

    public <TT extends Double> void toString(Appendable buf, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (value == null) {
            return;
        }
        double v = value.doubleValue();
        if (Double.isInfinite(v)) {
            if (v < 0.0) {
                buf.append('-');
            }
            buf.append("INF");
        } else if (Double.isNaN(v)) {
            buf.append("NaN");
        } else {
            double exponent = v == 0.0 ? 1.0 : Math.log10(Math.abs(v));
            String str = exponent > -3.0 && exponent < 7.0 ? this.decimalFormat.format(v) : this.scientificFormat.format(v);
            buf.append(str);
        }
    }

    public @Nullable Double getDefaultValue() {
        return 0.0;
    }
}

