/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.icollection.ChampVectorSet;
import org.jhotdraw8.icollection.immutable.ImmutableSequencedSet;
import org.jspecify.annotations.Nullable;

public class SetXmlConverter<T>
implements Converter<ImmutableSequencedSet<T>> {
    private final Converter<T> elementConverter;
    private final @Nullable Pattern delimiterPattern;
    private final @Nullable String delimiter;
    private final @Nullable String prefix;
    private final @Nullable String suffix;

    public SetXmlConverter(Converter<T> elementConverter) {
        this(elementConverter, " ");
    }

    public SetXmlConverter(Converter<T> elementConverter, @Nullable String delimiter) {
        this(elementConverter, delimiter, null, null, null);
    }

    public SetXmlConverter(Converter<T> elementConverter, @Nullable String delimiter, @Nullable String prefix, @Nullable String suffix, @Nullable Comparator<T> comparatorForSorting) {
        this.elementConverter = elementConverter;
        String string = this.delimiter = delimiter == null ? " " : delimiter;
        this.delimiterPattern = Pattern.compile((String)(delimiter == null || delimiter.isBlank() ? "\\s+" : (delimiter.indexOf(32) == -1 ? delimiter : "\\s*" + delimiter.trim() + "\\s*")));
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public @Nullable ImmutableSequencedSet<T> fromString(CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        String str = in.toString();
        if (this.prefix != null) {
            if (!str.startsWith(this.prefix)) {
                throw new ParseException("Must start with \"" + this.prefix + "\"", 0);
            }
            str = str.substring(this.prefix.length());
        }
        if (this.suffix != null) {
            if (!str.endsWith(this.suffix)) {
                throw new ParseException("Must end with \"" + this.suffix + "\"", 0);
            }
            str = str.substring(0, str.length() - this.suffix.length());
        }
        ChampVectorSet set = ChampVectorSet.of();
        for (String elem : this.delimiterPattern.split(str)) {
            if (elem.isEmpty()) continue;
            set = set.add(this.elementConverter.fromString((CharSequence)elem, idResolver));
        }
        in.position(in.length());
        return set;
    }

    public boolean needsIdResolver() {
        return this.elementConverter.needsIdResolver();
    }

    public <TT extends ImmutableSequencedSet<T>> void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (this.prefix != null) {
            out.append(this.prefix);
        }
        if (value != null) {
            boolean first = true;
            for (Object elem : value) {
                if (first) {
                    first = false;
                } else {
                    out.append(this.delimiter);
                }
                this.elementConverter.toString(out, idSupplier, elem);
            }
        }
        if (this.suffix != null) {
            out.append(this.suffix);
        }
    }

    public @Nullable ImmutableSequencedSet<T> getDefaultValue() {
        return null;
    }
}

