/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.text.ParseException;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jspecify.annotations.Nullable;

public class UriXmlConverter
implements Converter<URI> {
    public void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable URI value) throws IOException {
        out.append(value == null ? "none" : (idSupplier == null ? value : idSupplier.relativize(value)).toString());
    }

    public @Nullable URI fromString(CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        String str = in.toString().trim();
        in.position(in.limit());
        if ("none".equals(str)) {
            return null;
        }
        try {
            return idResolver == null ? new URI(str) : idResolver.absolutize(new URI(str));
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public @Nullable URI getDefaultValue() {
        return null;
    }
}

