/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.xml.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.ChampVectorSet;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jspecify.annotations.Nullable;

public class WordSetXmlConverter
implements Converter<ImmutableSet<String>> {
    private final @Nullable Comparator<String> comparator;

    public WordSetXmlConverter() {
        this(Comparator.comparing(o -> Normalizer.normalize(o.toLowerCase(Locale.ROOT), Normalizer.Form.NFD)));
    }

    public WordSetXmlConverter(@Nullable Comparator<String> comparator) {
        this.comparator = comparator;
    }

    public <TT extends ImmutableSet<String>> void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        Object words;
        if (value == null) {
            return;
        }
        if (this.comparator != null) {
            words = new ArrayList(value.asSet());
            ((ArrayList)words).sort(this.comparator);
        } else {
            words = value;
        }
        boolean isFirst = true;
        for (String s : words) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.append(" ");
            }
            out.append(s);
        }
    }

    public ImmutableSet<String> fromString(CharBuffer buf, @Nullable IdResolver idResolver) {
        String[] strings = buf.toString().split("\\s+");
        ChampVectorSet words = this.comparator == null ? ChampVectorSet.of() : ChampSet.of();
        for (String str : strings) {
            words = words.add((Object)Normalizer.normalize(str, Normalizer.Form.NFC));
        }
        buf.position(buf.length());
        return words;
    }

    public @Nullable ImmutableSet<String> getDefaultValue() {
        return ChampVectorSet.of();
    }
}

