/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.amigabitmap;

import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.monte.media.amigabitmap.AmigaBitmapImage;
import org.monte.media.amigabitmap.AmigaHAMColorModel;
import org.monte.media.iff.MC68000OutputStream;
import org.monte.media.iff.MutableIFFChunk;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;

public class AmigaBitmapImageFactory {
    private AmigaBitmapImageFactory() {
    }

    public static BufferedImage toBufferedImage(AmigaBitmapImage bm) {
        BufferedImage image = null;
        Hashtable properties = new Hashtable();
        bm.convertToChunky();
        switch (bm.getPixelType()) {
            case 1: {
                image = new BufferedImage(bm.getWidth(), bm.getHeight(), 13, (IndexColorModel)bm.getChunkyColorModel());
                WritableRaster ras = image.getRaster();
                byte[] pixels = ((DataBufferByte)ras.getDataBuffer()).getData();
                System.arraycopy(bm.getBytePixels(), 0, pixels, 0, bm.getBytePixels().length);
                break;
            }
            case 2: {
                WritableRaster ras = Raster.createPackedRaster(3, bm.getWidth(), bm.getHeight(), 3, 8, new Point());
                image = new BufferedImage(bm.getChunkyColorModel(), ras, false, properties);
                int[] pixels = ((DataBufferInt)ras.getDataBuffer()).getData();
                System.arraycopy(bm.getIntPixels(), 0, pixels, 0, bm.getIntPixels().length);
                break;
            }
        }
        return image;
    }

    public static Image toMemoryImage(AmigaBitmapImage bm) {
        bm.convertToChunky();
        switch (bm.getPixelType()) {
            case 1: {
                MemoryImageSource mis = new MemoryImageSource(bm.getWidth(), bm.getHeight(), bm.getChunkyColorModel(), (byte[])bm.getBytePixels().clone(), 0, bm.getWidth());
                return Toolkit.getDefaultToolkit().createImage(mis);
            }
            case 2: {
                MemoryImageSource mis = new MemoryImageSource(bm.getWidth(), bm.getHeight(), bm.getChunkyColorModel(), (int[])bm.getIntPixels().clone(), 0, bm.getWidth());
                return Toolkit.getDefaultToolkit().createImage(mis);
            }
        }
        return null;
    }

    public static AmigaBitmapImage toBitmapImage(MemoryImageSource mis) {
        return null;
    }

    public static AmigaBitmapImage toBitmapImage(ColorCyclingMemoryImageSource mis) {
        return null;
    }

    public static AmigaBitmapImage toBitmapImage(BufferedImage mis) {
        return null;
    }

    public static void write(AmigaBitmapImage bm, File f) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            AmigaBitmapImageFactory.write(bm, out);
        }
    }

    public static void write(AmigaBitmapImage bm, OutputStream out) throws IOException {
        MutableIFFChunk form = new MutableIFFChunk("FORM", "ILBM");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        MC68000OutputStream struct = new MC68000OutputStream(buf);
        struct.writeUWORD(bm.getWidth());
        struct.writeUWORD(bm.getHeight());
        struct.writeWORD(0);
        struct.writeWORD(0);
        struct.writeUBYTE(bm.getDepth());
        struct.writeUBYTE(0);
        struct.writeUBYTE(1);
        struct.writeUBYTE(0);
        struct.writeUWORD(0);
        struct.writeUBYTE(10);
        struct.writeUBYTE(11);
        struct.writeWORD(bm.getWidth());
        struct.writeWORD(bm.getHeight());
        struct.close();
        form.add(new MutableIFFChunk("BMHD", buf.toByteArray()));
        ColorModel cm = bm.getPlanarColorModel();
        buf = new ByteArrayOutputStream();
        struct = new MC68000OutputStream(buf);
        int viewMode = 0;
        if (cm instanceof AmigaHAMColorModel) {
            viewMode |= 0x800;
        }
        struct.writeULONG(viewMode);
        struct.close();
        form.add(new MutableIFFChunk("CAMG", buf.toByteArray()));
        if (cm instanceof AmigaHAMColorModel) {
            AmigaHAMColorModel hcm = (AmigaHAMColorModel)cm;
            buf = new ByteArrayOutputStream();
            struct = new MC68000OutputStream(buf);
            byte[] r = new byte[hcm.getMapSize()];
            byte[] g = new byte[hcm.getMapSize()];
            byte[] b = new byte[hcm.getMapSize()];
            hcm.getReds(r);
            hcm.getGreens(g);
            hcm.getBlues(b);
            for (int i = 0; i < r.length; ++i) {
                struct.writeUBYTE(r[i]);
                struct.writeUBYTE(g[i]);
                struct.writeUBYTE(b[i]);
            }
            struct.close();
            form.add(new MutableIFFChunk("CMAP", buf.toByteArray()));
        }
        buf = new ByteArrayOutputStream();
        struct = new MC68000OutputStream(buf);
        int height = bm.getHeight();
        for (int y = 0; y < height; ++y) {
            int depth = bm.getDepth();
            for (int d = 0; d < depth; ++d) {
                struct.writeByteRun1(bm.getBitmap(), y * bm.getScanlineStride() + d * bm.getBitplaneStride(), bm.getWidth() / 8);
            }
        }
        form.add(new MutableIFFChunk("BODY", buf.toByteArray()));
        MC68000OutputStream mout = new MC68000OutputStream(out);
        form.write(mout);
        mout.flush();
    }
}

