/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.monte.media.anim.ANIMAudioCommand;
import org.monte.media.anim.ANIMDemultiplexer;
import org.monte.media.anim.ANIMFrame;
import org.monte.media.anim.ANIMMovieResources;
import org.monte.media.anim.AudioMixer;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.Track;
import org.monte.media.av.codec.audio.AudioFormatKeys;
import org.monte.media.eightsvx.EightSVXAudioClip;
import org.monte.media.math.Rational;

public class ANIMAudioTrack
implements Track {
    private Format format;
    private ANIMDemultiplexer demux;
    private AudioMixer mixer;
    private long position;
    private byte[] convertedBytes;
    private final int samplesPerSecond = 44100;
    private long sampleCount;
    private int samplesPerBuffer;

    public ANIMAudioTrack(ANIMDemultiplexer demux) {
        this(demux, false);
    }

    public ANIMAudioTrack(ANIMDemultiplexer demux, boolean swapLeftRightChannels) {
        this.samplesPerBuffer = this.samplesPerSecond = 44100;
        this.demux = demux;
        this.mixer = new AudioMixer();
        int jiffies = demux.getJiffies();
        int frameTimeInJiffies = 0;
        ANIMMovieResources res = demux.getResources();
        try {
            int n = demux.getFrameCount();
            for (int i = 0; i < n; ++i) {
                ANIMFrame frame = res.getFrame(i);
                Rational frameTime = new Rational((long)frameTimeInJiffies, (long)jiffies);
                if (frame.getAudioCommands() != null) {
                    for (ANIMAudioCommand cmd : frame.getAudioCommands()) {
                        if (cmd.getCommand() != 1) continue;
                        EightSVXAudioClip audioClip = (EightSVXAudioClip)res.getAudioClip(cmd.getSound() - 1);
                        byte[] linearPcm = audioClip.to8BitLinearPcm();
                        AudioInputStream audioInputStream = new AudioInputStream(new ByteArrayInputStream(linearPcm), this.getSourceFormat(cmd, res), linearPcm.length);
                        int pan = (int)cmd.getPan();
                        this.mixer.add(audioInputStream, frameTime, cmd.getRepeats(), (float)cmd.getVolume() / 64.0f, swapLeftRightChannels ? -pan : pan);
                    }
                }
                frameTimeInJiffies += demux.getDuration(i);
            }
            this.convertedBytes = this.mixer.toByteArray();
            this.sampleCount = this.mixer.getSampleCount();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long getSampleCount() {
        return this.mixer.getSampleCount();
    }

    public void setPosition(long pos) {
        this.position = pos;
    }

    public long getPosition() {
        return this.position;
    }

    public void read(Buffer buf) throws IOException {
        if (this.position < this.sampleCount) {
            buf.data = this.convertedBytes;
            buf.format = this.getFormat();
            buf.timeStamp = new Rational(this.position, (long)this.samplesPerBuffer);
            buf.sampleCount = (int)Math.min((long)this.samplesPerBuffer, this.sampleCount - this.position);
            buf.sampleDuration = new Rational(1L, (long)this.samplesPerBuffer);
            buf.offset = (int)(this.position * 4L);
            buf.length = buf.sampleCount * 4;
            buf.setFlagsTo(new BufferFlag[]{buf.sampleCount == 0 ? BufferFlag.DISCARD : BufferFlag.KEYFRAME});
            this.position = Math.min(this.sampleCount, this.position + (long)this.samplesPerBuffer);
        } else {
            buf.setFlagsTo(new BufferFlag[]{BufferFlag.END_OF_MEDIA, BufferFlag.DISCARD});
        }
    }

    public Format getFormat() {
        if (this.format == null) {
            this.format = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.SampleRateKey, new Rational(44100L, 1L), AudioFormatKeys.SampleSizeInBitsKey, 16, AudioFormatKeys.ChannelsKey, 2, AudioFormatKeys.FrameSizeKey, 4, FormatKeys.EncodingKey, AudioFormatKeys.ENCODING_PCM_SIGNED});
        }
        return this.format;
    }

    private AudioFormat getSourceFormat(ANIMAudioCommand cmd, ANIMMovieResources res) {
        EightSVXAudioClip eightSVXAudioClip = (EightSVXAudioClip)res.getAudioClip(cmd.getSound() - 1);
        int sampleRate = cmd.getFrequency() == 0 ? eightSVXAudioClip.getSampleRate() : cmd.getFrequency();
        float pan = cmd.getPan();
        return new AudioFormat(sampleRate, 8, 1, true, true);
    }

    private AudioFormat getTargetFormat() {
        return new AudioFormat(44100.0f, 16, 2, true, true);
    }
}

