/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.monte.media.amigabitmap.AmigaHAMColorModel;
import org.monte.media.anim.ANIMAudioCommand;
import org.monte.media.anim.ANIMDeltaFrame;
import org.monte.media.anim.ANIMFrame;
import org.monte.media.anim.ANIMKeyFrame;
import org.monte.media.anim.ANIMMovieResources;
import org.monte.media.eightsvx.AudioClip;
import org.monte.media.eightsvx.EightSVXDecoder;
import org.monte.media.exception.AbortException;
import org.monte.media.exception.ParseException;
import org.monte.media.iff.IFFChunk;
import org.monte.media.iff.IFFParser;
import org.monte.media.iff.IFFVisitor;
import org.monte.media.iff.MC68000InputStream;
import org.monte.media.ilbm.CRNGColorCycle;
import org.monte.media.ilbm.DRNGColorCycle;

public class ANIMDecoder
implements IFFVisitor {
    private static final int ILBM_ID = IFFParser.stringToID("ILBM");
    private static final int BMHD_ID = IFFParser.stringToID("BMHD");
    private static final int CMAP_ID = IFFParser.stringToID("CMAP");
    private static final int CAMG_ID = IFFParser.stringToID("CAMG");
    private static final int CCRT_ID = IFFParser.stringToID("CCRT");
    private static final int CRNG_ID = IFFParser.stringToID("CRNG");
    private static final int DRNG_ID = IFFParser.stringToID("DRNG");
    private static final int BODY_ID = IFFParser.stringToID("BODY");
    private static final int ANHD_ID = IFFParser.stringToID("ANHD");
    private static final int DLTA_ID = IFFParser.stringToID("DLTA");
    private static final int ANIM_ID = IFFParser.stringToID("ANIM");
    private static final int COPYRIGHT_ID = IFFParser.stringToID("(c) ");
    private static final int AUTH_ID = IFFParser.stringToID("AUTH");
    private static final int ANNO_ID = IFFParser.stringToID("ANNO");
    private static final int ANFI_ID = IFFParser.stringToID("ANFI");
    private static final int SCTL_ID = IFFParser.stringToID("SCTL");
    public static final int MONITOR_ID_MASK = -61440;
    public static final int DEFAULT_MONITOR_ID = 0;
    public static final int NTSC_MONITOR_ID = 69632;
    public static final int PAL_MONITOR_ID = 135168;
    public static final int MULTISCAN_MONITOR_ID = 200704;
    public static final int A2024_MONITOR_ID = 266240;
    public static final int PROTO_MONITOR_ID = 331776;
    public static final int EURO72_MONITOR_ID = 397312;
    public static final int EURO36_MONITOR_ID = 462848;
    public static final int SUPER72_MONITOR_ID = 528384;
    public static final int DBLNTSC_MONITOR_ID = 593920;
    public static final int DBLPAL_MONITOR_ID = 659456;
    protected static final int MODE_MASK = 2176;
    protected static final int HAM_MODE = 2048;
    protected static final int EHB_MODE = 128;
    private InputStream inputStream_;
    private URL location;
    private ColorModel cmapColorModel;
    private ANIMMovieResources track;
    private int animCount;
    private int index;
    private EightSVXDecoder eightSVXDecoder;
    private byte[] previousCMAPdata_;
    private boolean isInANIM;
    private boolean isInILBM;
    private int camg = 69632;

    public ANIMDecoder(InputStream inputStream) {
        this.inputStream_ = inputStream;
    }

    public ANIMDecoder(URL location) {
        this.location = location;
    }

    public void produce(ANIMMovieResources track, int n, boolean loadAudio) throws IOException {
        InputStream in = null;
        this.track = track;
        this.index = n;
        this.animCount = 0;
        in = this.inputStream_ != null ? this.inputStream_ : this.location.openStream();
        try {
            IFFParser iff = new IFFParser();
            this.registerChunks(iff, loadAudio);
            if (loadAudio) {
                this.eightSVXDecoder = new EightSVXDecoder(){

                    @Override
                    public void addAudioClip(AudioClip clip) {
                        super.addAudioClip(clip);
                        ANIMDecoder.this.track.addAudioClip(clip);
                    }
                };
                this.eightSVXDecoder.registerChunks(iff);
            }
            iff.parse(in, this);
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (AbortException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            in.close();
        }
    }

    public void registerChunks(IFFParser iff, boolean loadAudio) {
        iff.declarePropertyChunk(ILBM_ID, BMHD_ID);
        iff.declarePropertyChunk(ILBM_ID, CMAP_ID);
        iff.declarePropertyChunk(ILBM_ID, CAMG_ID);
        iff.declarePropertyChunk(ILBM_ID, ANHD_ID);
        iff.declareCollectionChunk(ILBM_ID, CCRT_ID);
        iff.declareCollectionChunk(ILBM_ID, CRNG_ID);
        iff.declareCollectionChunk(ILBM_ID, DRNG_ID);
        if (loadAudio) {
            iff.declarePropertyChunk(ILBM_ID, ANFI_ID);
            iff.declareCollectionChunk(ILBM_ID, SCTL_ID);
        }
        iff.declareGroupChunk(ANIM_ID, 1179603533);
        iff.declareGroupChunk(ILBM_ID, 1179603533);
        iff.declareDataChunk(ILBM_ID, BODY_ID);
        iff.declareDataChunk(ILBM_ID, DLTA_ID);
        iff.declareCollectionChunk(ILBM_ID, AUTH_ID);
        iff.declareCollectionChunk(ILBM_ID, ANNO_ID);
        iff.declareCollectionChunk(ILBM_ID, COPYRIGHT_ID);
    }

    @Override
    public void enterGroup(IFFChunk chunk) {
        if (chunk.getType() == ANIM_ID) {
            if (this.animCount++ == this.index) {
                this.isInANIM = true;
            }
        } else if (chunk.getType() == ILBM_ID) {
            this.isInILBM = true;
        }
        if (this.isInANIM && this.eightSVXDecoder != null) {
            this.eightSVXDecoder.enterGroup(chunk);
        }
    }

    @Override
    public void leaveGroup(IFFChunk chunk) {
        if (this.isInANIM && this.eightSVXDecoder != null) {
            this.eightSVXDecoder.leaveGroup(chunk);
        }
        if (chunk.getType() == ANIM_ID) {
            this.isInANIM = false;
        }
        if (chunk.getType() == ILBM_ID) {
            this.isInILBM = false;
        }
    }

    @Override
    public void visitChunk(IFFChunk group, IFFChunk chunk) throws ParseException, AbortException {
        if (Thread.currentThread().isInterrupted()) {
            throw new AbortException();
        }
        if (this.isInANIM) {
            if (this.eightSVXDecoder != null) {
                this.eightSVXDecoder.visitChunk(group, chunk);
            }
            if (group.getType() == ILBM_ID) {
                if (this.track.getWidth() == 0) {
                    this.decodeBMHD(group.getPropertyChunk(BMHD_ID), this.track);
                    this.decodeCAMG(group.getPropertyChunk(CAMG_ID), this.track);
                    this.decodeColorCycling(group.getCollectionChunks(CCRT_ID), group.getCollectionChunks(CRNG_ID), group.getCollectionChunks(DRNG_ID), this.track);
                    this.decodeAUTH(group.getCollectionChunks(AUTH_ID), this.track);
                    this.decodeANNO(group.getCollectionChunks(ANNO_ID), this.track);
                    this.decodeCOPYRIGHT(group.getCollectionChunks(COPYRIGHT_ID), this.track);
                }
                boolean is4BitsPerChannel = (this.camg & 0xFFFF1000) == 0;
                ColorModel cm = this.decodeCMAP(group.getPropertyChunk(CMAP_ID), this.track, is4BitsPerChannel);
                if (cm != null) {
                    this.cmapColorModel = cm;
                }
                if (chunk.getID() == BODY_ID) {
                    this.decodeBODY(this.cmapColorModel, group, chunk, this.track);
                } else if (chunk.getID() == DLTA_ID) {
                    this.decodeDLTA(this.cmapColorModel, group, chunk, this.track);
                }
            }
        } else if (this.isInILBM) {
            if (this.track.getWidth() == 0) {
                this.decodeBMHD(group.getPropertyChunk(BMHD_ID), this.track);
                this.decodeCAMG(group.getPropertyChunk(CAMG_ID), this.track);
                this.decodeColorCycling(group.getCollectionChunks(CCRT_ID), group.getCollectionChunks(CRNG_ID), group.getCollectionChunks(DRNG_ID), this.track);
                this.decodeAUTH(group.getCollectionChunks(AUTH_ID), this.track);
                this.decodeANNO(group.getCollectionChunks(ANNO_ID), this.track);
                this.decodeCOPYRIGHT(group.getCollectionChunks(COPYRIGHT_ID), this.track);
            }
            this.track.setPlayWrapupFrames(true);
            boolean is4BitsPerChannel = (this.camg & 0xFFFF1000) == 0;
            ColorModel cm = this.decodeCMAP(group.getPropertyChunk(CMAP_ID), this.track, is4BitsPerChannel);
            if (cm != null) {
                this.cmapColorModel = cm;
            }
            if (chunk.getID() == BODY_ID) {
                this.decodeBODY(this.cmapColorModel, group, chunk, this.track);
            }
        }
    }

    private void decodeBMHD(IFFChunk chunk, ANIMMovieResources track) throws ParseException {
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            track.setWidth(in.readUWORD());
            track.setHeight(in.readUWORD());
            track.setXPosition(in.readWORD());
            track.setYPosition(in.readWORD());
            track.setNbPlanes(in.readUBYTE());
            track.setMasking(in.readUBYTE());
            track.setCompression(in.readUBYTE());
            in.skip(1L);
            track.setTransparentColor(in.readUWORD());
            track.setXAspect(in.readUBYTE());
            track.setYAspect(in.readUBYTE());
            track.setPageWidth(in.readWORD());
            track.setPageHeight(in.readWORD());
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    private void decodeCAMG(IFFChunk chunk, ANIMMovieResources track) throws ParseException {
        if (chunk != null) {
            try {
                MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
                this.camg = in.readLONG();
                in.close();
            }
            catch (IOException e) {
                throw new ParseException(e.toString());
            }
        }
        switch (this.camg & 0x880) {
            case 128: {
                track.setScreenMode(2);
                break;
            }
            case 2048: {
                if (track.getNbPlanes() == 6) {
                    track.setScreenMode(3);
                    break;
                }
                if (track.getNbPlanes() == 8) {
                    track.setScreenMode(4);
                    break;
                }
                throw new ParseException("unsupported Ham Mode with " + track.getNbPlanes() + " bitplanes");
            }
            default: {
                if (track.getNbPlanes() <= 8) {
                    track.setScreenMode(0);
                    break;
                }
                track.setScreenMode(1);
            }
        }
        track.setJiffies(switch (this.camg & 0xFFFF1000) {
            case 0 -> 60;
            case 69632 -> 60;
            case 135168 -> 50;
            case 200704 -> 58;
            case 266240 -> 60;
            case 331776 -> 60;
            case 397312 -> 69;
            case 462848 -> 73;
            case 593920 -> 58;
            case 659456 -> 48;
            case 528384 -> 71;
            default -> 60;
        });
    }

    private ColorModel decodeCMAP(IFFChunk chunk, ANIMMovieResources track, boolean is4BitsPerChannel) throws ParseException {
        int i;
        int size = 0;
        int colorsToRead = 0;
        if (chunk == null) {
            return null;
        }
        byte[] cmapData = chunk.getData();
        if (this.previousCMAPdata_ != null && Arrays.equals(cmapData, this.previousCMAPdata_)) {
            return null;
        }
        this.previousCMAPdata_ = cmapData;
        switch (track.getScreenMode()) {
            case 2: {
                size = 64;
                colorsToRead = Math.min(32, (int)chunk.getSize() / 3);
                break;
            }
            case 3: 
            case 4: {
                size = 1 << track.getNbPlanes() - 2;
                colorsToRead = Math.min(size, (int)chunk.getSize() / 3);
                break;
            }
            case 0: {
                size = 1 << track.getNbPlanes();
                colorsToRead = Math.min(size, (int)chunk.getSize() / 3);
                break;
            }
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
        }
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        byte[] data = chunk.getData();
        int j = 0;
        if (is4BitsPerChannel) {
            for (i = 0; i < colorsToRead; ++i) {
                red[i] = (byte)(data[j] & 0xF0 | (data[j] & 0xF0) >>> 4);
                green[i] = (byte)(data[j + 1] & 0xF0 | (data[j + 1] & 0xF0) >>> 4);
                blue[i] = (byte)(data[j + 2] & 0xF0 | (data[j + 2] & 0xF0) >>> 4);
                j += 3;
            }
        } else {
            for (i = 0; i < colorsToRead; ++i) {
                red[i] = data[j++];
                green[i] = data[j++];
                blue[i] = data[j++];
            }
        }
        switch (track.getScreenMode()) {
            case 2: {
                j = 32;
                i = 0;
                while (i < 32) {
                    red[j] = (byte)((red[i] & 0xFF) / 2);
                    green[j] = (byte)((green[i] & 0xFF) / 2);
                    blue[j] = (byte)((blue[i] & 0xFF) / 2);
                    ++i;
                    ++j;
                }
                return new IndexColorModel(8, 64, red, green, blue, -1);
            }
            case 3: {
                return new AmigaHAMColorModel(6, 16, red, green, blue, false);
            }
            case 4: {
                return new AmigaHAMColorModel(8, 64, red, green, blue, false);
            }
            case 0: {
                return new IndexColorModel(8, Math.min(red.length, (int)chunk.getSize() / 3), red, green, blue, -1);
            }
        }
        throw new ParseException("ScreenMode not supported:" + track.getScreenMode());
    }

    protected void decodeCCRT(IFFChunk chunk, ANIMMovieResources track) throws ParseException {
        CRNGColorCycle cc;
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            short direction = in.readWORD();
            int start = in.readUBYTE();
            int end = in.readUBYTE();
            long seconds = in.readULONG();
            long microseconds = in.readULONG();
            short pad = in.readWORD();
            cc = new CRNGColorCycle(1000000 / (int)(seconds * 1000L + microseconds / 1000L), 1000, start, end, direction == 1 || direction == -1, direction == 1, track.getScreenMode() == 2);
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
        if (cc.isActive()) {
            track.addColorCycle(cc);
        }
    }

    protected void decodeCRNG(IFFChunk chunk, ANIMMovieResources track) throws ParseException {
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int pad1 = in.readUWORD();
            int rate = in.readUWORD();
            int flags = in.readUWORD();
            int low = in.readUBYTE();
            int high = in.readUBYTE();
            CRNGColorCycle cc = new CRNGColorCycle(rate, 273, low, high, (flags & 1) != 0 && rate > 36 && high > low, (flags & 2) != 0, track.getScreenMode() == 2);
            if (cc.isActive()) {
                track.addColorCycle(cc);
            }
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    protected void decodeDRNG(IFFChunk chunk, ANIMMovieResources track) throws ParseException {
        try {
            int cell;
            int i;
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int min = in.readUBYTE();
            int max = in.readUBYTE();
            int rate = in.readUWORD();
            int flags = in.readUWORD();
            int ntrue = in.readUBYTE();
            int nregs = in.readUBYTE();
            DRNGColorCycle.Cell[] cells = new DRNGColorCycle.Cell[ntrue + nregs];
            for (i = 0; i < ntrue; ++i) {
                cell = in.readUBYTE();
                int rgb = in.readUBYTE() << 16 | in.readUBYTE() << 8 | in.readUBYTE();
                cells[i] = new DRNGColorCycle.DColorCell(cell, rgb);
            }
            for (i = 0; i < nregs; ++i) {
                cell = in.readUBYTE();
                int index = in.readUBYTE();
                cells[i + ntrue] = new DRNGColorCycle.DIndexCell(cell, index);
            }
            DRNGColorCycle cc = new DRNGColorCycle(rate, 273, min, max, (flags & 1) != 0 && rate > 36 && min <= max && ntrue + nregs > 1, track.getScreenMode() == 2, cells);
            if (cc.isActive()) {
                track.addColorCycle(cc);
            }
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    protected void decodeColorCycling(IFFChunk[] ccrtChunks, IFFChunk[] crngChunks, IFFChunk[] drngChunks, ANIMMovieResources track) throws ParseException {
        boolean activeCycles = false;
        int j = 0;
        int k = 0;
        int l = 0;
        int n = ccrtChunks.length + crngChunks.length + drngChunks.length;
        for (int i = 0; i < n; ++i) {
            if (!(j >= crngChunks.length || k < drngChunks.length && crngChunks[j].getScan() >= drngChunks[k].getScan() || l < ccrtChunks.length && crngChunks[j].getScan() >= ccrtChunks[l].getScan())) {
                this.decodeCRNG(crngChunks[j], track);
                ++j;
                continue;
            }
            if (k < drngChunks.length && (l >= ccrtChunks.length || drngChunks[k].getScan() < ccrtChunks[l].getScan())) {
                this.decodeDRNG(drngChunks[k], track);
                ++k;
                continue;
            }
            this.decodeCCRT(ccrtChunks[l], track);
            ++l;
        }
        track.setProperty("colorCycling", track.getColorCyclesCount());
    }

    private void decodeBODY(ColorModel colorModel, IFFChunk group, IFFChunk body, ANIMMovieResources track) throws ParseException {
        ANIMKeyFrame frame = new ANIMKeyFrame();
        frame.setColorModel(colorModel);
        this.decodeANHD(group.getPropertyChunk(ANHD_ID), frame);
        if (group.getPropertyChunk(ANFI_ID) != null) {
            this.decodeANFI(group.getPropertyChunk(ANFI_ID), frame, track);
        }
        IFFChunk[] sctlChunks = group.getCollectionChunks(SCTL_ID);
        for (int i = 0; i < sctlChunks.length; ++i) {
            this.decodeSCTL(sctlChunks[i], frame, track);
        }
        frame.cleanUpAudioCommands();
        frame.setData(body.getData());
        frame.setCompression(track.getCompression());
        track.addFrame(frame);
    }

    private void decodeDLTA(ColorModel colorModel, IFFChunk group, IFFChunk dlta, ANIMMovieResources track) throws ParseException {
        ANIMDeltaFrame frame = new ANIMDeltaFrame();
        frame.setColorModel(colorModel);
        this.decodeANHD(group.getPropertyChunk(ANHD_ID), frame);
        if (group.getPropertyChunk(ANFI_ID) != null) {
            this.decodeANFI(group.getPropertyChunk(ANFI_ID), frame, track);
        }
        IFFChunk[] sctlChunks = group.getCollectionChunks(SCTL_ID);
        for (int i = 0; i < sctlChunks.length; ++i) {
            this.decodeSCTL(sctlChunks[i], frame, track);
        }
        frame.cleanUpAudioCommands();
        frame.setData(dlta.getData());
        track.addFrame(frame);
    }

    private void decodeANHD(IFFChunk chunk, ANIMFrame frame) throws ParseException {
        if (chunk != null) {
            try {
                MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
                frame.setOperation(in.readUBYTE());
                frame.setMask(in.readUBYTE());
                frame.setWidth(in.readUWORD());
                frame.setHeight(in.readUWORD());
                frame.setY(in.readUWORD());
                frame.setX(in.readUWORD());
                frame.setAbsTime(in.readULONG());
                frame.setRelTime(in.readULONG());
                frame.setInterleave(in.readUBYTE());
                in.skip(1L);
                frame.setBits((int)in.readULONG());
                in.close();
            }
            catch (IOException e) {
                throw new ParseException(e.toString());
            }
        }
    }

    private void decodeANFI(IFFChunk chunk, ANIMFrame frame, ANIMMovieResources track) throws ParseException {
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            for (int i = 0; i < 4; ++i) {
                int command = in.readUWORD();
                int frequency = in.readUWORD();
                int sound = in.readUBYTE();
                int channel = in.readUBYTE();
                int repeats = in.readUBYTE();
                repeats = repeats > 2 ? --repeats : 1;
                int volume = in.readUBYTE();
                if (command == 0) continue;
                ANIMAudioCommand audioCommand = new ANIMAudioCommand(1, volume, sound, repeats, 1 << channel - 1, 0, 0);
                frame.addAudioCommand(audioCommand);
                audioCommand.prepare(track);
            }
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    private void decodeSCTL(IFFChunk chunk, ANIMFrame frame, ANIMMovieResources track) throws ParseException {
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int command = in.readUBYTE();
            int volume = in.readUBYTE();
            int sound = in.readUWORD();
            int repeats = in.readUWORD();
            int channel = in.readUWORD();
            int frequency = in.readUWORD();
            int flags = in.readUWORD();
            in.close();
            ANIMAudioCommand audioCommand = new ANIMAudioCommand(command, volume, sound, repeats, channel, frequency, flags);
            frame.addAudioCommand(audioCommand);
            audioCommand.prepare(track);
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    protected void decodeCOPYRIGHT(IFFChunk[] chunks, ANIMMovieResources track) throws ParseException {
        for (int i = 0; i < chunks.length; ++i) {
            String copyright = new String(chunks[i].getData());
            this.appendProperty("copyright", copyright);
            this.appendProperty("comment", "\ufffd " + copyright);
        }
    }

    protected void decodeAUTH(IFFChunk[] chunks, ANIMMovieResources track) throws ParseException {
        for (int i = 0; i < chunks.length; ++i) {
            String author = new String(chunks[i].getData());
            this.appendProperty("author", author);
            this.appendProperty("comment", "Author " + author);
        }
    }

    protected void decodeANNO(IFFChunk[] chunks, ANIMMovieResources track) throws ParseException {
        for (int i = 0; i < chunks.length; ++i) {
            String anno = new String(chunks[i].getData());
            this.appendProperty("annotation", anno);
            this.appendProperty("comment", anno);
        }
    }

    private void appendProperty(String name, String value) {
        String oldValue = (String)this.track.getProperty(name);
        if (oldValue == null) {
            this.track.setProperty(name, value);
        } else {
            this.track.setProperty(name, oldValue + "\n" + value);
        }
    }
}

