/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.monte.media.amigabitmap.AmigaBitmapImage;
import org.monte.media.anim.ANIMDecoder;
import org.monte.media.anim.ANIMFrame;
import org.monte.media.anim.ANIMMovieResources;

public class ANIMReader {
    private ANIMMovieResources resources;
    private int fetchedEven = Integer.MAX_VALUE;
    private int fetchedOdd = Integer.MAX_VALUE;
    private AmigaBitmapImage bitmapEven;
    private AmigaBitmapImage bitmapOdd;

    public ANIMReader(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            ANIMDecoder decoder = new ANIMDecoder(in);
            this.resources = new ANIMMovieResources();
            decoder.produce(this.resources, 0, true);
        }
    }

    public ANIMReader(InputStream in) throws IOException {
        ANIMDecoder decoder = new ANIMDecoder(in);
        this.resources = new ANIMMovieResources();
        decoder.produce(this.resources, 0, true);
    }

    public void close() throws IOException {
    }

    public int getFrameCount() {
        return this.getResources().getFrameCount();
    }

    public ANIMMovieResources getResources() {
        return this.resources;
    }

    public int getTimeBase() {
        return this.getResources().getJiffies();
    }

    public AmigaBitmapImage createCompatibleBitmap() {
        return new AmigaBitmapImage(this.resources.getWidth(), this.resources.getHeight(), this.resources.getNbPlanes() + (this.resources.getMasking() == 1 ? 1 : 0), this.resources.getFrame(0).getColorModel());
    }

    public int getWidth() {
        return this.resources.getWidth();
    }

    public int getHeight() {
        return this.resources.getHeight();
    }

    public void readFrame(int index, AmigaBitmapImage image) {
        AmigaBitmapImage fetched = this.fetchFrame(index);
        System.arraycopy(fetched.getBitmap(), 0, image.getBitmap(), 0, fetched.getBitmap().length);
        image.setPlanarColorModel(this.resources.getFrame(index).getColorModel());
    }

    public int getDuration(int index) {
        return Math.max(1, (int)this.resources.getFrame(index).getRelTime());
    }

    private AmigaBitmapImage fetchFrame(int index) {
        AmigaBitmapImage bitmap;
        if (this.bitmapOdd == null || this.bitmapEven == null) {
            this.bitmapOdd = this.createCompatibleBitmap();
            this.bitmapEven = this.createCompatibleBitmap();
        }
        ANIMFrame frame = null;
        int interleave = this.resources.getInterleave();
        if (interleave == 1 || (index & 1) == 0) {
            if (this.fetchedEven == index) {
                return this.bitmapEven;
            }
            fetched = this.fetchedEven;
            bitmap = this.bitmapEven;
            this.fetchedEven = index;
            if (fetched == index + interleave && this.resources.getFrame(fetched).isBidirectional()) {
                frame = this.resources.getFrame(fetched);
                frame.decode(bitmap, this.resources);
                return bitmap;
            }
            if (fetched > index) {
                frame = this.resources.getFrame(0);
                frame.decode(bitmap, this.resources);
                fetched = 0;
            }
        } else {
            if (this.fetchedOdd == index) {
                return this.bitmapOdd;
            }
            fetched = this.fetchedOdd;
            bitmap = this.bitmapOdd;
            this.fetchedOdd = index;
            if (fetched == index + interleave && this.resources.getFrame(fetched).isBidirectional()) {
                frame = this.resources.getFrame(fetched);
                frame.decode(bitmap, this.resources);
                return bitmap;
            }
            if (fetched > index) {
                frame = this.resources.getFrame(0);
                frame.decode(bitmap, this.resources);
                frame = this.resources.getFrame(1);
                frame.decode(bitmap, this.resources);
                fetched = 1;
            }
        }
        for (int i = fetched + interleave; i <= index; i += interleave) {
            frame = this.resources.getFrame(i);
            frame.decode(bitmap, this.resources);
        }
        return bitmap;
    }

    public int getJiffies() {
        return this.resources.getJiffies();
    }

    public int getColorCyclesCount() {
        return this.resources.getColorCyclesCount();
    }
}

