/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.anim.ANIMMultiplexer;
import org.monte.media.anim.AmigaVideoFormatKeys;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieWriter;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.math.Rational;

public class ANIMWriter
extends ANIMMultiplexer
implements MovieWriter {
    public static final Format ANIM = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "x-iff/anim"});
    private ArrayList<Track> tracks = new ArrayList();

    public Format getFileFormat() throws IOException {
        return ANIM;
    }

    public Rational getDuration(int track) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ANIMWriter(File file) throws IOException {
        super(file);
    }

    public ANIMWriter(ImageOutputStream out) throws IOException {
        super(out);
    }

    @Override
    public int addTrack(Format format) throws IOException {
        if (this.tracks.size() > 0) {
            throw new UnsupportedOperationException("only 1 track supported");
        }
        Format derivedFormat = format.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "x-iff/anim", FormatKeys.EncodingKey, "op5", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, false});
        this.setCAMG(AmigaVideoFormatKeys.toCAMG(derivedFormat));
        Track tr = new Track();
        tr.format = derivedFormat;
        this.tracks.add(tr);
        return this.tracks.size() - 1;
    }

    public Format getFormat(int track) {
        return this.tracks.get((int)track).format;
    }

    public int getTrackCount() {
        return this.tracks.size();
    }

    public boolean isVFRSupported() {
        return true;
    }

    public boolean isDataLimitReached() {
        return false;
    }

    public boolean isEmpty(int track) {
        return this.inputTime.isZero();
    }

    private static class Track {
        Format format;

        private Track() {
        }
    }
}

