/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.util.ArrayList;
import java.util.Iterator;
import org.monte.media.amigabitmap.AmigaDisplayInfo;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKey;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.math.Rational;

public class AmigaVideoFormatKeys
extends VideoFormatKeys {
    public static final FormatKey<Integer> MonitorIdKey = new FormatKey("monitorId", Integer.class);
    public static final String ENCODING_ANIM_OP5 = "op5";
    public static final FormatKey<ColorMode> ColorModeKey = new FormatKey("colorMode", ColorMode.class);

    public static Format fromCAMG(int camg) {
        AmigaDisplayInfo i = AmigaDisplayInfo.getInfo(camg);
        return new Format(new Object[]{MediaTypeKey, FormatKeys.MediaType.VIDEO, EncodingKey, "ILBM", WidthKey, i.textOverscanWidth, HeightKey, i.textOverscanHeight, MonitorIdKey, camg & 0xFFFF1000, ColorModeKey, i.isEHB() ? ColorMode.EHB : (i.isHAM() ? ColorMode.HAM : ColorMode.NORMAL), InterlaceKey, i.isInterlace(), PixelAspectRatioKey, new Rational((long)i.resolutionX, (long)i.resolutionY), FrameRateKey, new Rational((long)i.fps, 1L)});
    }

    public static int toCAMG(Format fmt) {
        int camg = 0;
        int monitorId = 0;
        if (fmt.containsKey(MonitorIdKey)) {
            monitorId = (Integer)fmt.get(MonitorIdKey);
        } else {
            ArrayList<AmigaDisplayInfo> infs = new ArrayList<AmigaDisplayInfo>(AmigaDisplayInfo.getAllInfos().values());
            if (fmt.containsKey(InterlaceKey)) {
                boolean value = (Boolean)fmt.get(InterlaceKey);
                AmigaVideoFormatKeys.reduceListBoolean(value, AmigaDisplayInfo::isInterlace, infs);
            }
            if (fmt.containsKey(FrameRateKey)) {
                Rational value = (Rational)fmt.get(FrameRateKey);
                AmigaVideoFormatKeys.reduceListRational(value, inf -> new Rational((long)inf.fps, 1L), infs);
            }
            if (fmt.containsKey(PixelAspectRatioKey)) {
                Rational value = (Rational)fmt.get(PixelAspectRatioKey);
                AmigaVideoFormatKeys.reduceListRational(value, inf -> new Rational((long)inf.resolutionX, (long)inf.resolutionY), infs);
            }
            ArrayList<AmigaDisplayInfo> bestInfs = new ArrayList<AmigaDisplayInfo>(infs);
            if (fmt.containsKey(WidthKey)) {
                int value = (Integer)fmt.get(WidthKey);
                AmigaVideoFormatKeys.reduceListIntegerOnlyTakeIfSmaller(value, inf -> inf.textOverscanWidth, infs);
            }
            if (fmt.containsKey(HeightKey)) {
                Integer value = (Integer)fmt.get(HeightKey);
                AmigaVideoFormatKeys.reduceListIntegerOnlyTakeIfSmaller(value, inf -> inf.textOverscanHeight, infs);
            }
            if (infs.isEmpty()) {
                infs = new ArrayList<AmigaDisplayInfo>(bestInfs);
                if (fmt.containsKey(WidthKey)) {
                    Integer value = (Integer)fmt.get(WidthKey);
                    AmigaVideoFormatKeys.reduceListIntegerOnlyTakeIfSmaller(value, inf -> inf.maxOverscanWidth, infs);
                }
                if (fmt.containsKey(HeightKey)) {
                    Integer value = (Integer)fmt.get(HeightKey);
                    AmigaVideoFormatKeys.reduceListIntegerOnlyTakeIfSmaller(value, inf -> inf.maxOverscanHeight, infs);
                }
            }
            if (infs.isEmpty()) {
                infs = new ArrayList<AmigaDisplayInfo>(bestInfs);
                if (fmt.containsKey(WidthKey)) {
                    Integer value = (Integer)fmt.get(WidthKey);
                    AmigaVideoFormatKeys.reduceListInteger(value, inf -> inf.maxOverscanWidth, infs);
                }
                if (fmt.containsKey(HeightKey)) {
                    Integer value = (Integer)fmt.get(HeightKey);
                    AmigaVideoFormatKeys.reduceListInteger(value, inf -> inf.maxOverscanHeight, infs);
                }
            }
        }
        int colorMode = 0;
        if (fmt.containsKey(ColorModeKey)) {
            switch (((ColorMode)((Object)fmt.get(ColorModeKey))).ordinal()) {
                case 1: {
                    colorMode = 128;
                    break;
                }
                case 0: {
                    colorMode = 2048;
                    break;
                }
            }
        }
        camg = monitorId | colorMode;
        return camg;
    }

    private static void reduceListRational(Rational value, InfGetter<Rational> g, ArrayList<AmigaDisplayInfo> infs) {
        ArrayList<AmigaDisplayInfo> bestInfs = new ArrayList<AmigaDisplayInfo>();
        bestInfs.add(infs.get(0));
        float bestCost = g.get(infs.get(0)).subtract(value).floatValue();
        bestCost *= bestCost;
        Iterator<AmigaDisplayInfo> i = infs.iterator();
        while (i.hasNext()) {
            AmigaDisplayInfo inf = i.next();
            Rational iv = g.get(inf);
            if (iv.compareTo(value) != 0) {
                i.remove();
            }
            float icost = iv.subtract(value).floatValue();
            if ((icost *= icost) < bestCost) {
                bestInfs.clear();
                bestCost = icost;
                continue;
            }
            if (icost != bestCost) continue;
            bestInfs.add(inf);
        }
        if (infs.isEmpty()) {
            infs.addAll(bestInfs);
        }
    }

    private static void reduceListInteger(int value, InfGetter<Integer> g, ArrayList<AmigaDisplayInfo> infs) {
        ArrayList<AmigaDisplayInfo> bestInfs = new ArrayList<AmigaDisplayInfo>();
        bestInfs.add(infs.get(0));
        float bestCost = g.get(infs.get(0)) - value;
        bestCost *= bestCost;
        Iterator<AmigaDisplayInfo> i = infs.iterator();
        while (i.hasNext()) {
            AmigaDisplayInfo inf = i.next();
            int iv = g.get(inf);
            if (iv != value) {
                i.remove();
            }
            float icost = iv - value;
            if ((icost *= icost) < bestCost) {
                bestInfs.clear();
                bestCost = icost;
                continue;
            }
            if (icost != bestCost) continue;
            bestInfs.add(inf);
        }
        if (infs.isEmpty()) {
            infs.addAll(bestInfs);
        }
    }

    private static void reduceListIntegerOnlyTakeIfSmaller(int value, InfGetter<Integer> g, ArrayList<AmigaDisplayInfo> infs) {
        AmigaVideoFormatKeys.reduceListInteger(value, g, infs);
        Iterator<AmigaDisplayInfo> i = infs.iterator();
        while (i.hasNext()) {
            AmigaDisplayInfo inf = i.next();
            int iv = g.get(inf);
            if (value <= iv) continue;
            i.remove();
        }
    }

    private static void reduceListBoolean(boolean value, InfGetter<Boolean> g, ArrayList<AmigaDisplayInfo> infs) {
        Iterator<AmigaDisplayInfo> i = infs.iterator();
        while (i.hasNext()) {
            AmigaDisplayInfo inf = i.next();
            boolean iv = g.get(inf);
            if (iv == value) continue;
            i.remove();
        }
    }

    static enum ColorMode {
        HAM,
        EHB,
        NORMAL;

    }

    private static interface InfGetter<T> {
        public T get(AmigaDisplayInfo var1);
    }
}

