/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.monte.media.math.Rational;

public class AudioMixer {
    private int[] data = new int[0];
    private static final AudioFormat stereoFormat = new AudioFormat(44100.0f, 16, 2, true, true);
    private static final AudioFormat monoFormat = new AudioFormat(44100.0f, 16, 1, true, true);
    private final byte[] tmp = new byte[1024];

    public void add(AudioInputStream in, Rational startTime, int repeats, float volume, int pan) throws IOException {
        if (!(volume >= 0.0f) || Float.isNaN(volume)) {
            throw new IllegalArgumentException("volume: " + volume);
        }
        switch (pan) {
            case -1: {
                float leftVolume = volume;
                float rightVolume = 0.0f;
                this.mixMono(in, startTime, repeats, leftVolume, rightVolume);
                break;
            }
            case 0: {
                float rightVolume;
                float leftVolume = rightVolume = volume;
                this.mixStereo(in, startTime, repeats, leftVolume, rightVolume);
                break;
            }
            case 1: {
                float leftVolume = 0.0f;
                float rightVolume = 1.0f;
                this.mixMono(in, startTime, repeats, leftVolume, rightVolume);
                break;
            }
            default: {
                throw new IllegalArgumentException("pan: " + pan);
            }
        }
    }

    public int getSampleCount() {
        return this.data.length / 2;
    }

    private void mixMono(AudioInputStream in, Rational startTime, int repeats, float leftVolume, float rightVolume) throws IOException {
        int destOffset = (int)startTime.floorNumerator((long)((int)monoFormat.getSampleRate()));
        try (AudioInputStream converted = AudioSystem.getAudioInputStream(monoFormat, in);){
            converted.mark(Integer.MAX_VALUE);
            for (int r = 0; r < repeats; ++r) {
                int count = converted.read(this.tmp);
                while (count != -1) {
                    this.mixMono(this.tmp, 0, count, destOffset, leftVolume, rightVolume);
                    destOffset += count / 2;
                    count = converted.read(this.tmp);
                }
                converted.reset();
            }
        }
    }

    private void mixMono(byte[] bytes, int off, int len, int destOffset, float leftVolume, float rightVolume) {
        int j = destOffset * 2;
        this.ensureCapacity(destOffset + len / 2);
        for (int i = 0; i < len; i += 2) {
            short inMono = (short)((bytes[off + i] & 0xFF) << 8 | (bytes[off + i + 1] & 0xFF) << 0);
            int outLeft = (int)((float)inMono * leftVolume);
            int outRight = (int)((float)inMono * rightVolume);
            int n = j++;
            this.data[n] = this.data[n] + outLeft;
            int n2 = j++;
            this.data[n2] = this.data[n2] + outRight;
        }
    }

    private void ensureCapacity(int size) {
        if (this.data.length < size * 2) {
            this.data = Arrays.copyOf(this.data, size * 2);
        }
    }

    private void mixStereo(AudioInputStream in, Rational startTime, int repeats, float leftVolume, float rightVolume) throws IOException {
        int destOffset = (int)startTime.floorNumerator((long)((int)monoFormat.getSampleRate()));
        try (AudioInputStream converted = AudioSystem.getAudioInputStream(stereoFormat, in);){
            converted.mark(Integer.MAX_VALUE);
            for (int r = 0; r < repeats; ++r) {
                int count = converted.read(this.tmp);
                while (count != -1) {
                    this.mixStereo(this.tmp, 0, count, destOffset, leftVolume, rightVolume);
                    destOffset += count / 4;
                    count = converted.read(this.tmp);
                }
                in.reset();
            }
        }
    }

    private void mixStereo(byte[] bytes, int off, int len, int destOffset, float leftVolume, float rightVolume) {
        int j = destOffset * 2;
        this.ensureCapacity(destOffset + len / 4);
        for (int i = 0; i < len; i += 4) {
            short inLeft = (short)((bytes[off + i] & 0xFF) << 8 | (bytes[off + i + 1] & 0xFF) << 0);
            short inRight = (short)((bytes[off + i + 2] & 0xFF) << 8 | (bytes[off + i + 3] & 0xFF) << 0);
            int outLeft = (int)((float)inLeft * leftVolume);
            int outRight = (int)((float)inRight * rightVolume);
            int n = j++;
            this.data[n] = this.data[n] + outLeft;
            int n2 = j++;
            this.data[n2] = this.data[n2] + outRight;
        }
    }

    public int getMaxAbsoluteValue() {
        int maxAbs = 0;
        for (int i = 0; i < this.data.length; ++i) {
            int abs = Math.abs(this.data[i]);
            if (abs <= maxAbs) continue;
            maxAbs = abs;
        }
        return maxAbs;
    }

    public byte[] toByteArray() {
        int maxAbs = this.getMaxAbsoluteValue();
        byte[] b = new byte[this.getSampleCount() * 4];
        if (maxAbs <= Short.MAX_VALUE) {
            int j = 0;
            for (int sample : this.data) {
                b[j++] = (byte)((sample & 0xFF00) >> 8);
                b[j++] = (byte)(sample & 0xFF);
            }
        } else {
            float volume = 32767.0f / (float)maxAbs;
            int j = 0;
            int n = this.data.length;
            for (int i = 0; i < n; ++i) {
                int sample = (int)((float)this.data[i] * volume);
                b[j++] = (byte)((sample & 0xFF00) >> 8);
                b[j++] = (byte)(sample & 0xFF);
            }
        }
        return b;
    }
}

