/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.eightsvx;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.monte.media.eightsvx.LoopableAudioClip;

public class JDK13LongAudioClip
implements LoopableAudioClip,
Runnable {
    private SourceDataLine dataLine;
    private byte[] samples;
    private int sampleRate;
    private int framePosition;
    private int loopStart;
    private int loopEnd;
    private int loopCount;
    private volatile Thread thread;
    private int volume;
    private float pan;

    public JDK13LongAudioClip(byte[] samples, int sampleRate, int volume, float pan) {
        this.samples = samples;
        this.sampleRate = sampleRate;
        this.volume = volume;
        this.pan = pan;
        this.samples = samples;
        this.sampleRate = sampleRate;
        this.loopStart = 0;
        this.loopEnd = samples.length;
    }

    @Override
    public void loop() {
        this.stop();
        this.framePosition = 0;
        this.loop(-1);
    }

    @Override
    public synchronized void loop(int count) {
        this.stop();
        try {
            FloatControl control;
            this.dataLine = this.createDataLine();
            this.dataLine.open();
            if (this.dataLine.isControlSupported(FloatControl.Type.BALANCE)) {
                control = (FloatControl)this.dataLine.getControl(FloatControl.Type.BALANCE);
                control.setValue(this.pan);
            }
            if (this.dataLine.isControlSupported(FloatControl.Type.VOLUME)) {
                control = (FloatControl)this.dataLine.getControl(FloatControl.Type.VOLUME);
                control.setValue((float)this.volume / 64.0f);
            }
            this.loopCount = count;
            this.thread = new Thread((Runnable)this, "JDK13AudioClip");
            this.thread.setPriority(6);
            this.thread.start();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public void play() {
        this.stop();
        this.framePosition = 0;
        this.loop(0);
    }

    public void start() {
        this.loop(0);
    }

    @Override
    public synchronized void stop() {
        Thread t = this.thread;
        if (this.thread != null) {
            this.thread = null;
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.dataLine = null;
        }
    }

    public void setFramePosition(int param) {
        this.framePosition = param;
    }

    public long getMicrosecondLength() {
        return this.samples.length / this.sampleRate;
    }

    public long getMicrosecondPosition() {
        SourceDataLine sdl = this.dataLine;
        return sdl == null ? 0L : sdl.getMicrosecondPosition();
    }

    public void setLoopPoints(int start, int end) {
        if (start < 0 || start >= this.samples.length || end < start && end != -1 || end >= this.samples.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end);
        }
        this.loopStart = start;
        this.loopEnd = end == -1 ? this.samples.length : end + 1;
    }

    private SourceDataLine createDataLine() throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(this.sampleRate, 8, 1, true, true);
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
        SourceDataLine sdl = (SourceDataLine)AudioSystem.getLine(lineInfo);
        return sdl;
    }

    @Override
    public void run() {
        this.dataLine.start();
        byte[] buf = new byte[512];
        if (this.loopCount > 0 && this.framePosition < this.loopEnd) {
            while (this.thread == Thread.currentThread() && (this.loopCount > 0 || this.loopCount == -1)) {
                while (this.thread == Thread.currentThread() && this.framePosition < this.loopEnd) {
                    System.arraycopy(this.samples, this.framePosition, buf, 0, Math.min(512, this.loopEnd - this.framePosition));
                    this.framePosition += this.dataLine.write(buf, 0, Math.min(512, this.loopEnd - this.framePosition));
                }
                if (this.thread != Thread.currentThread() || this.loopCount <= 0 && this.loopCount != -1) continue;
                if (this.loopCount != -1) {
                    --this.loopCount;
                }
                this.framePosition = this.loopStart;
            }
        }
        while (this.thread == Thread.currentThread() && this.framePosition < this.samples.length) {
            System.arraycopy(this.samples, this.framePosition, buf, 0, Math.min(512, this.samples.length - this.framePosition));
            this.framePosition += this.dataLine.write(buf, 0, Math.min(512, this.samples.length - this.framePosition));
        }
        if (this.thread == Thread.currentThread()) {
            this.dataLine.drain();
        }
        this.dataLine.stop();
        this.dataLine.close();
        if (this.thread == null) {
            System.out.println(String.valueOf(this) + " PRELIMINARY finish");
        } else {
            System.out.println(String.valueOf(this) + " liberate finish");
        }
    }
}

