/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.iff;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.monte.media.io.ByteArray;

public class MC68000InputStream
extends FilterInputStream {
    private long scan;
    private long mark;
    private byte[] byteBuffer = new byte[8];

    public MC68000InputStream(InputStream in) {
        super(in);
    }

    public int readUBYTE() throws IOException {
        int b0 = this.in.read();
        if (b0 == -1) {
            throw new EOFException();
        }
        ++this.scan;
        return b0 & 0xFF;
    }

    public short readWORD() throws IOException {
        this.readFully(this.byteBuffer, 0, 2);
        return ByteArray.getShortBE((byte[])this.byteBuffer, (int)0);
    }

    public int readUWORD() throws IOException {
        return this.readWORD() & 0xFFFF;
    }

    public int readLONG() throws IOException {
        this.readFully(this.byteBuffer, 0, 4);
        return ByteArray.getIntBE((byte[])this.byteBuffer, (int)0);
    }

    public long readINT64() throws IOException {
        this.readFully(this.byteBuffer, 0, 8);
        return ByteArray.getLongBE((byte[])this.byteBuffer, (int)0);
    }

    public long readULONG() throws IOException {
        return (long)this.readLONG() & 0xFFFFFFFFL;
    }

    public void align() throws IOException {
        if (this.scan % 2L == 1L) {
            this.skipFully(1L);
        }
    }

    public long getScan() {
        return this.scan;
    }

    @Override
    public int read() throws IOException {
        int data = this.in.read();
        ++this.scan;
        return data;
    }

    public void readFully(byte[] b, int offset, int length) throws IOException {
        int count = 0;
        while (count < length) {
            int current = this.in.read(b, offset + count, length - count);
            if (count < 0) {
                throw new EOFException();
            }
            count += current;
            this.scan += (long)current;
        }
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int count = this.in.read(b, offset, length);
        if (count > 0) {
            this.scan += (long)count;
        }
        return count;
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.scan;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.scan = this.mark;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.scan += skipped;
        return skipped;
    }

    public void skipFully(long n) throws IOException {
        int total = 0;
        int cur = 0;
        while ((long)total < n && (cur = (int)this.in.skip(n - (long)total)) > 0) {
            total += cur;
        }
        if (cur == 0) {
            throw new EOFException();
        }
        this.scan += (long)total;
    }

    public static int unpackByteRun1(byte[] in, byte[] out) throws IOException {
        int iOut = 0;
        int iIn = 0;
        int n = 0;
        try {
            while (iOut < out.length) {
                if ((n = in[iIn++]) >= 0) {
                    System.arraycopy(in, iIn, out, iOut, ++n);
                    iOut += n;
                    iIn += n;
                    continue;
                }
                if (n == -128) continue;
                byte copyByte = in[iIn++];
                while (n < 1) {
                    out[iOut++] = copyByte;
                    ++n;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("MC68000InputStream.unpackByteRun1(): " + String.valueOf(e));
            System.out.println("  Plane-Index: " + iOut + " Plane size:" + out.length);
            System.out.println("  Buffer-Index: " + iIn + " Buffer size:" + in.length);
            System.out.println("  Command: " + n);
        }
        return iOut;
    }
}

