/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.pbm;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.image.AnimatedImageReader;
import org.monte.media.io.ImageInputStreamAdapter;
import org.monte.media.pbm.PBMDecoder;
import org.monte.media.pbm.PBMImageReaderSpi;

public class PBMImageReader
extends ImageReader
implements AnimatedImageReader {
    private ArrayList<ColorCyclingMemoryImageSource> images = null;

    public PBMImageReader(PBMImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (allowSearch && this.images == null) {
            this.readImages();
        }
        return this.images.size();
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readImages();
        return this.images.get(imageIndex).getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readImages();
        return this.images.get(imageIndex).getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readImages();
        ColorCyclingMemoryImageSource iip = this.images.get(imageIndex);
        LinkedList<ImageTypeSpecifier> l = new LinkedList<ImageTypeSpecifier>();
        l.add(new ImageTypeSpecifier(iip.getColorModel(), iip.getColorModel().createCompatibleSampleModel(iip.getWidth(), iip.getHeight())));
        return l.iterator();
    }

    @Override
    public float getAspectRatio(int imageIndex) throws IOException {
        this.readImages();
        ColorCyclingMemoryImageSource mis = this.images.get(imageIndex);
        float ratio = (float)this.getWidth(imageIndex) / (float)this.getHeight(imageIndex);
        if (mis.getProperties().containsKey("aspect")) {
            ratio = (float)((double)ratio * (Double)mis.getProperties().get("aspect"));
        }
        return ratio;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.readImages();
        return this.images.get(imageIndex).toBufferedImage();
    }

    public Image readAnimatedImage(int imageIndex) throws IOException {
        this.readImages();
        ColorCyclingMemoryImageSource ccmis = this.images.get(imageIndex);
        if (ccmis.isColorCyclingAvailable()) {
            ccmis.start();
        }
        return Toolkit.getDefaultToolkit().createImage(ccmis);
    }

    private void readImages() throws IOException {
        ImageInputStream in = (ImageInputStream)this.getInput();
        if (this.images == null) {
            in.seek(0L);
            PBMDecoder d = new PBMDecoder((InputStream)new ImageInputStreamAdapter(in));
            this.images = d.produce();
        }
    }
}

