/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.amigabitmap;

import java.awt.Dimension;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class AmigaDisplayInfo {
    public final int camg;
    public final String name;
    public final int textOverscanWidth;
    public final int textOverscanHeight;
    public final int maxOverscanWidth;
    public final int maxOverscanHeight;
    public final int minimalSizeWidth;
    public final int minimalSizeHeight;
    public final int maximalSizeWidth;
    public final int maximalSizeHeight;
    public final int colorRegisterDepth;
    public final int resolutionX;
    public final int resolutionY;
    public final int pixelSpeed;
    public final int fps;
    private static TreeMap<Integer, AmigaDisplayInfo> infos;
    public static final int MONITOR_ID_MASK = -61440;
    public static final int DEFAULT_MONITOR_ID = 0;
    public static final int NTSC_MONITOR_ID = 69632;
    public static final int PAL_MONITOR_ID = 135168;
    public static final int MULTISCAN_MONITOR_ID = 200704;
    public static final int A2024_MONITOR_ID = 266240;
    public static final int PROTO_MONITOR_ID = 331776;
    public static final int EURO72_MONITOR_ID = 397312;
    public static final int EURO36_MONITOR_ID = 462848;
    public static final int SUPER72_MONITOR_ID = 528384;
    public static final int DBLNTSC_MONITOR_ID = 593920;
    public static final int DBLPAL_MONITOR_ID = 659456;
    private static final TreeMap<Integer, MonitorItem> monitorToFPSMap;
    public static final int COLORMODE_MASK = 2176;
    public static final int HAM_COLORMODE = 2048;
    public static final int EHB_COLORMODE = 128;
    public static final int PALNTSC_INTERLACE_MASK = 4;
    public static final int PALNTSC_INTERLACE_MODE = 4;
    public static final int MULTISCAN_INTERLACE_MASK = 1;
    public static final int MULTISCAN_INTERLACE_MODE = 1;
    public static final int DUALPLAYFIELD_MASK = 1024;
    public static final int DUALPLAYFIELD_MODE = 1024;
    public static final int NTSC_320x200_44t52_60fps = 69632;
    public static final int NTSC_320x400_44t26_interlaced_60fps = 69636;
    public static final int NTSC_640x200_22t52_60fps = 102400;
    public static final int NTSC_640x400_22t26_interlaced_60fps = 102404;
    public static final int NTSC_1280x200_11t52_60fps = 102432;
    public static final int NTSC_1280x400_11t26_interlaced_60fps = 102436;
    public static final int PAL_320x256_44t44_50fps = 135168;
    public static final int PAL_320x512_44t22_interlaced_50fps = 135172;
    public static final int PAL_640x256_22t44_50fps = 167936;
    public static final int PAL_640x512_22t22_interlaced_50fps = 167940;
    public static final int PAL_1280x256_11t44_50fps = 167968;
    public static final int PAL_1280x512_11t22_interlaced_50fps = 167972;
    public static final int MULTISCAN_160x480_88t22_58fps = 200708;
    public static final int MULTISCAN_160x960_88t11_interlaced_58fps = 200709;
    public static final int MULTISCAN_320x480_44t22_58fps = 233476;
    public static final int MULTISCAN_320x960_44t11_interlaced_58fps = 233477;
    public static final int MULTISCAN_640x480_22t22_58fps = 233508;
    public static final int MULTISCAN_640x960_22t11_interlaced_58fps = 233509;
    public static final int EURO72_640x400_22t22_69fps = 430116;
    public static final int EURO72_640x800_22t11_interlaced_69fps = 430117;
    public static final int EURO36_320x200_44t44_73fps = 462848;
    public static final int EURO36_320x400_44t22_interlaced_73fps = 462852;
    public static final int EURO36_640x200_22t44_73fps = 495616;
    public static final int EURO36_640x400_22t22_interlaced_73fps = 495620;
    public static final int EURO36_1280x200_11t44_73fps = 495648;
    public static final int EURO36_1280x400_11t22_interlaced_73fps = 495652;
    public static final int SUPER72_200x300_68t40_71fps = 528384;
    public static final int SUPER72_200x600_68t20_interlaced_71fps = 528388;
    public static final int SUPER72_400x300_34t40_71fps = 561152;
    public static final int SUPER72_400x600_34t20_interlaced_71fps = 561156;
    public static final int SUPER72_800x300_17t40_71fps = 561184;
    public static final int SUPER72_800x600_17t20_interlaced_71fps = 561188;
    public static final int DBLNTSC_320x200_44t52_58fps = 593920;
    public static final int DBLNTSC_320x400_44t26_58fps = 593924;
    public static final int DBLNTSC_320x800_44t13_interlaced_58fps = 593925;
    public static final int DBLNTSC_640x200_22t52_58fps = 626688;
    public static final int DBLNTSC_640x400_22t26_58fps = 626692;
    public static final int DBLNTSC_640x800_22t13_interlaced_58fps = 626693;
    public static final int DBLPAL_320x256_44t44_48fps = 659456;
    public static final int DBLPAL_320x512_44t22_48fps = 659460;
    public static final int DBLPAL_320x1024_44t11_interlaced_48fps = 659461;
    public static final int DBLPAL_640x256_22t44_48fps = 692224;
    public static final int DBLPAL_640x512_22t22_48fps = 692228;
    public static final int DBLPAL_640x1024_22t11_interlaced_48fps = 692229;
    private static final Object[][] infoTable;

    public AmigaDisplayInfo(int camg, String name, Dimension textOverscan, Dimension maxOverscan, Dimension minimalSize, Dimension maximalSize, int colorRegisterDepth, Dimension resolution, int pixelSpeed, int fps) {
        this.camg = camg;
        this.name = name;
        this.textOverscanWidth = textOverscan.width;
        this.textOverscanHeight = textOverscan.height;
        this.maxOverscanWidth = maxOverscan.width;
        this.maxOverscanHeight = maxOverscan.height;
        this.minimalSizeWidth = minimalSize.width;
        this.minimalSizeHeight = minimalSize.height;
        this.maximalSizeWidth = maximalSize.width;
        this.maximalSizeHeight = maximalSize.height;
        this.colorRegisterDepth = colorRegisterDepth;
        this.resolutionX = resolution.width;
        this.resolutionY = resolution.height;
        this.pixelSpeed = pixelSpeed;
        this.fps = fps;
    }

    public boolean isOCS() {
        return this.colorRegisterDepth == 4;
    }

    public boolean isHAM() {
        return (this.camg & 0x880) == 2048;
    }

    public boolean isEHB() {
        return (this.camg & 0x880) == 128;
    }

    public boolean isInterlace() {
        return switch (this.camg & 0xFFFF1000) {
            case 69632, 135168 -> (this.camg & 4) == 4;
            case 200704 -> (this.camg & 1) == 1;
            default -> false;
        };
    }

    public static Map<Integer, AmigaDisplayInfo> getAllInfos() {
        if (infos == null) {
            infos = new TreeMap();
            for (Object[] e : infoTable) {
                int i = 0;
                int camg = (Integer)e[i++];
                String name = (String)e[i++];
                Dimension textOverscan = new Dimension((Integer)e[i++], (Integer)e[i++]);
                Dimension maxOverscan = new Dimension((Integer)e[i++], (Integer)e[i++]);
                Dimension minimalSize = new Dimension((Integer)e[i++], (Integer)e[i++]);
                Dimension maximalSize = new Dimension((Integer)e[i++], (Integer)e[i++]);
                int colorRegisterDepth = (Integer)e[i++];
                Dimension resolution = new Dimension((Integer)e[i++], (Integer)e[i++]);
                int pixelSpeed = (Integer)e[i++];
                Integer fps = AmigaDisplayInfo.monitorToFPSMap.get((Object)Integer.valueOf((int)(camg & 0xFFFF1000))).fps;
                if (fps == null) {
                    System.out.println("NO FPS  0x" + Integer.toHexString(camg) + " " + name);
                }
                infos.put(camg, new AmigaDisplayInfo(camg, name, textOverscan, maxOverscan, minimalSize, maximalSize, colorRegisterDepth, resolution, pixelSpeed, fps));
            }
        }
        return Collections.unmodifiableMap(infos);
    }

    public static AmigaDisplayInfo getInfo(int camg) {
        return AmigaDisplayInfo.getAllInfos().get(camg);
    }

    public static int[] getMonitorIds() {
        return new int[]{0, 69632, 135168, 200704, 266240, 331776, 397312, 462848, 528384, 593920, 659456};
    }

    public static int[] getGoodMonitorIds() {
        return new int[]{0, 69632, 135168, 200704, 397312, 462848, 528384, 593920, 659456};
    }

    public static int getFPS(int camg) {
        MonitorItem mi = monitorToFPSMap.get(camg & 0xFFFF1000);
        return mi == null ? 0 : mi.fps;
    }

    public static String getMonitorName(int camg) {
        MonitorItem mi = monitorToFPSMap.get(camg & 0xFFFF1000);
        return mi == null ? null : mi.name;
    }

    public boolean isDualPlayfield() {
        return (this.camg & 0x400) == 1024;
    }

    /*
     * Opcode count of 24317 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        monitorToFPSMap = new TreeMap();
        monitorToFPSMap.put(0, new MonitorItem("NTSC OCS", 60));
        monitorToFPSMap.put(69632, new MonitorItem("NTSC", 60));
        monitorToFPSMap.put(135168, new MonitorItem("PAL", 50));
        monitorToFPSMap.put(200704, new MonitorItem("MULTISCAN", 58));
        monitorToFPSMap.put(266240, new MonitorItem("A2024", 60));
        monitorToFPSMap.put(331776, new MonitorItem("PROTO", 60));
        monitorToFPSMap.put(397312, new MonitorItem("EURO72", 69));
        monitorToFPSMap.put(462848, new MonitorItem("EURO36", 73));
        monitorToFPSMap.put(528384, new MonitorItem("SUPER72", 71));
        monitorToFPSMap.put(593920, new MonitorItem("DBLNTSC", 58));
        monitorToFPSMap.put(659456, new MonitorItem("DBLPAL", 48));
        infoTable = new Object[][]{{0, "NTSC OCS:LowRes", 320, 200, 362, 241, 16, 1, 16368, 16384, 4, 44, 52, 140}, {4, "NTSC OCS:LowRes Interlace", 320, 400, 362, 482, 16, 1, 16368, 16384, 4, 44, 26, 140}, {128, " OCS", 320, 200, 362, 241, 16, 1, 16368, 16384, 4, 44, 52, 140}, {132, " OCS", 320, 400, 362, 482, 16, 1, 16368, 16384, 4, 44, 26, 140}, {1024, " OCS", 320, 200, 362, 241, 16, 1, 16368, 16384, 4, 44, 52, 140}, {1028, " OCS", 320, 400, 362, 482, 16, 1, 16368, 16384, 4, 44, 26, 140}, {1088, " OCS", 320, 200, 362, 241, 16, 1, 16368, 16384, 4, 44, 52, 140}, {1092, " OCS", 320, 400, 362, 482, 16, 1, 16368, 16384, 4, 44, 26, 140}, {2048, " OCS", 320, 200, 362, 241, 16, 1, 16368, 16384, 4, 44, 52, 140}, {2052, " OCS", 320, 400, 362, 482, 16, 1, 16368, 16384, 4, 44, 26, 140}, {32768, "NTSC OCS:HighRes", 640, 200, 724, 241, 32, 1, 16368, 16384, 4, 22, 52, 70}, {32772, "NTSC OCS:HighRes Interlace", 640, 400, 724, 482, 32, 1, 16368, 16384, 4, 22, 26, 70}, {32800, "NTSC OCS:SuperHighRes", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 4, 11, 52, 35}, {32804, "NTSC OCS:SuperHighRes Interlace", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 4, 11, 26, 35}, {32896, "", 640, 200, 724, 241, 32, 1, 16368, 16384, 4, 22, 52, 70}, {32900, "", 640, 400, 724, 482, 32, 1, 16368, 16384, 4, 22, 26, 70}, {32928, "", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 4, 11, 52, 35}, {32932, "", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 4, 11, 26, 35}, {33792, "", 640, 200, 724, 241, 32, 1, 16368, 16384, 4, 22, 52, 70}, {33796, "", 640, 400, 724, 482, 32, 1, 16368, 16384, 4, 22, 26, 70}, {33824, "", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 4, 11, 52, 35}, {33828, "", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 4, 11, 26, 35}, {33856, "", 640, 200, 724, 241, 32, 1, 16368, 16384, 4, 22, 52, 70}, {33860, "", 640, 400, 724, 482, 32, 1, 16368, 16384, 4, 22, 26, 70}, {33888, "", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 4, 11, 52, 35}, {33892, "", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 4, 11, 26, 35}, {34816, "", 640, 200, 724, 241, 32, 1, 16368, 16384, 4, 22, 52, 70}, {34820, "", 640, 400, 724, 482, 32, 1, 16368, 16384, 4, 22, 26, 70}, {34848, "", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 4, 11, 52, 35}, {34852, "", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 4, 11, 26, 35}, {69632, "NTSC:LowRes", 320, 200, 362, 241, 16, 1, 16368, 16384, 8, 44, 52, 140}, {69636, "NTSC:LowRes Interlace", 320, 400, 362, 482, 16, 1, 16368, 16384, 8, 44, 26, 140}, {69760, "", 320, 200, 362, 241, 16, 1, 16368, 16384, 8, 44, 52, 140}, {69764, "", 320, 400, 362, 482, 16, 1, 16368, 16384, 8, 44, 26, 140}, {70656, "", 320, 200, 362, 241, 16, 1, 16368, 16384, 8, 44, 52, 140}, {70660, "", 320, 400, 362, 482, 16, 1, 16368, 16384, 8, 44, 26, 140}, {70720, "", 320, 200, 362, 241, 16, 1, 16368, 16384, 8, 44, 52, 140}, {70724, "", 320, 400, 362, 482, 16, 1, 16368, 16384, 8, 44, 26, 140}, {71680, "", 320, 200, 362, 241, 16, 1, 16368, 16384, 8, 44, 52, 140}, {71684, "", 320, 400, 362, 482, 16, 1, 16368, 16384, 8, 44, 26, 140}, {102400, "NTSC:HighRes", 640, 200, 724, 241, 32, 1, 16368, 16384, 8, 22, 52, 70}, {102404, "NTSC:HighRes Interlace", 640, 400, 724, 482, 32, 1, 16368, 16384, 8, 22, 26, 70}, {102432, "NTSC:SuperHighRes", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 8, 11, 52, 35}, {102436, "NTSC:SuperHighRes Interlace", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 8, 11, 26, 35}, {102528, "", 640, 200, 724, 241, 32, 1, 16368, 16384, 8, 22, 52, 70}, {102532, "", 640, 400, 724, 482, 32, 1, 16368, 16384, 8, 22, 26, 70}, {102560, "", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 8, 11, 52, 35}, {102564, "", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 8, 11, 26, 35}, {103424, "", 640, 200, 724, 241, 32, 1, 16368, 16384, 8, 22, 52, 70}, {103428, "", 640, 400, 724, 482, 32, 1, 16368, 16384, 8, 22, 26, 70}, {103456, "", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 8, 11, 52, 35}, {103460, "", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 8, 11, 26, 35}, {103488, "", 640, 200, 724, 241, 32, 1, 16368, 16384, 8, 22, 52, 70}, {103492, "", 640, 400, 724, 482, 32, 1, 16368, 16384, 8, 22, 26, 70}, {103520, "", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 8, 11, 52, 35}, {103524, "", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 8, 11, 26, 35}, {104448, "", 640, 200, 724, 241, 32, 1, 16368, 16384, 8, 22, 52, 70}, {104452, "", 640, 400, 724, 482, 32, 1, 16368, 16384, 8, 22, 26, 70}, {104480, "", 1280, 200, 1448, 241, 64, 1, 16368, 16384, 8, 11, 52, 35}, {104484, "", 1280, 400, 1448, 482, 64, 1, 16368, 16384, 8, 11, 26, 35}, {135168, "PAL:LowRes", 320, 256, 362, 283, 16, 1, 16368, 16384, 8, 44, 44, 140}, {135172, "PAL:LowRes Interlace", 320, 512, 362, 566, 16, 1, 16368, 16384, 8, 44, 22, 140}, {135296, "", 320, 256, 362, 283, 16, 1, 16368, 16384, 8, 44, 44, 140}, {135300, "", 320, 512, 362, 566, 16, 1, 16368, 16384, 8, 44, 22, 140}, {136192, "", 320, 256, 362, 283, 16, 1, 16368, 16384, 8, 44, 44, 140}, {136196, "", 320, 512, 362, 566, 16, 1, 16368, 16384, 8, 44, 22, 140}, {136256, "", 320, 256, 362, 283, 16, 1, 16368, 16384, 8, 44, 44, 140}, {136260, "", 320, 512, 362, 566, 16, 1, 16368, 16384, 8, 44, 22, 140}, {137216, "", 320, 256, 362, 283, 16, 1, 16368, 16384, 8, 44, 44, 140}, {137220, "", 320, 512, 362, 566, 16, 1, 16368, 16384, 8, 44, 22, 140}, {167936, "PAL:HighRes", 640, 256, 724, 283, 32, 1, 16368, 16384, 8, 22, 44, 70}, {167940, "PAL:HighRes Interlace", 640, 512, 724, 566, 32, 1, 16368, 16384, 8, 22, 22, 70}, {167968, "PAL:SuperHighRes", 1280, 256, 1448, 283, 64, 1, 16368, 16384, 8, 11, 44, 35}, {167972, "PAL:SuperHighRes Interlace", 1280, 512, 1448, 566, 64, 1, 16368, 16384, 8, 11, 22, 35}, {168064, "", 640, 256, 724, 283, 32, 1, 16368, 16384, 8, 22, 44, 70}, {168068, "", 640, 512, 724, 566, 32, 1, 16368, 16384, 8, 22, 22, 70}, {168096, "", 1280, 256, 1448, 283, 64, 1, 16368, 16384, 8, 11, 44, 35}, {168100, "", 1280, 512, 1448, 566, 64, 1, 16368, 16384, 8, 11, 22, 35}, {168960, "", 640, 256, 724, 283, 32, 1, 16368, 16384, 8, 22, 44, 70}, {168964, "", 640, 512, 724, 566, 32, 1, 16368, 16384, 8, 22, 22, 70}, {168992, "", 1280, 256, 1448, 283, 64, 1, 16368, 16384, 8, 11, 44, 35}, {168996, "", 1280, 512, 1448, 566, 64, 1, 16368, 16384, 8, 11, 22, 35}, {169024, "", 640, 256, 724, 283, 32, 1, 16368, 16384, 8, 22, 44, 70}, {169028, "", 640, 512, 724, 566, 32, 1, 16368, 16384, 8, 22, 22, 70}, {169056, "", 1280, 256, 1448, 283, 64, 1, 16368, 16384, 8, 11, 44, 35}, {169060, "", 1280, 512, 1448, 566, 64, 1, 16368, 16384, 8, 11, 22, 35}, {169984, "", 640, 256, 724, 283, 32, 1, 16368, 16384, 8, 22, 44, 70}, {169988, "", 640, 512, 724, 566, 32, 1, 16368, 16384, 8, 22, 22, 70}, {170016, "", 1280, 256, 1448, 283, 64, 1, 16368, 16384, 8, 11, 44, 35}, {170020, "", 1280, 512, 1448, 566, 64, 1, 16368, 16384, 8, 11, 22, 35}, {200704, "MULTISCAN:ExtraLowRes", 160, 240, 164, 240, 16, 1, 16368, 16384, 8, 88, 44, 140}, {200708, "MULTISCAN:ExtraLowRes", 160, 480, 164, 480, 16, 1, 16368, 16384, 8, 88, 22, 140}, {200709, "MULTISCAN:ExtraLowRes Interlace", 160, 960, 164, 960, 16, 1, 16368, 16384, 8, 88, 11, 140}, {200832, "", 160, 240, 164, 240, 16, 1, 16368, 16384, 8, 88, 44, 140}, {200836, "", 160, 480, 164, 480, 16, 1, 16368, 16384, 8, 88, 22, 140}, {200837, "", 160, 960, 164, 960, 16, 1, 16368, 16384, 8, 88, 11, 140}, {201732, "", 160, 480, 164, 480, 16, 1, 16368, 16384, 8, 88, 22, 140}, {201733, "", 160, 960, 164, 960, 16, 1, 16368, 16384, 8, 88, 11, 140}, {201796, "", 160, 480, 164, 480, 16, 1, 16368, 16384, 8, 88, 22, 140}, {201797, "", 160, 960, 164, 960, 16, 1, 16368, 16384, 8, 88, 11, 140}, {202752, "", 160, 240, 164, 240, 16, 1, 16368, 16384, 8, 88, 44, 140}, {202756, "", 160, 480, 164, 480, 16, 1, 16368, 16384, 8, 88, 22, 140}, {202757, "", 160, 960, 164, 960, 16, 1, 16368, 16384, 8, 88, 11, 140}, {233472, "MULTISCAN:LowRes", 320, 240, 328, 240, 16, 1, 16368, 16384, 8, 44, 44, 70}, {233476, "MULTISCAN:LowRes", 320, 480, 328, 480, 16, 1, 16368, 16384, 8, 44, 22, 70}, {233477, "MULTISCAN:LowRes Interlace", 320, 960, 328, 960, 16, 1, 16368, 16384, 8, 44, 11, 70}, {233504, "MULTISCAN:Productivity", 640, 240, 656, 240, 16, 1, 16368, 16384, 8, 22, 44, 35}, {233508, "MULTISCAN:Productivity", 640, 480, 656, 480, 16, 1, 16368, 16384, 8, 22, 22, 35}, {233509, "MULTISCAN:Productivity Interl.", 640, 960, 656, 960, 16, 1, 16368, 16384, 8, 22, 11, 35}, {233600, "", 320, 240, 328, 240, 16, 1, 16368, 16384, 8, 44, 44, 70}, {233604, "", 320, 480, 328, 480, 16, 1, 16368, 16384, 8, 44, 22, 70}, {233605, "", 320, 960, 328, 960, 16, 1, 16368, 16384, 8, 44, 11, 70}, {233632, "", 640, 240, 656, 240, 16, 1, 16368, 16384, 8, 22, 44, 35}, {233636, "", 640, 480, 656, 480, 16, 1, 16368, 16384, 8, 22, 22, 35}, {233637, "", 640, 960, 656, 960, 16, 1, 16368, 16384, 8, 22, 11, 35}, {234500, "", 320, 480, 328, 480, 16, 1, 16368, 16384, 8, 44, 22, 70}, {234501, "", 320, 960, 328, 960, 16, 1, 16368, 16384, 8, 44, 11, 70}, {234532, "", 640, 480, 656, 480, 16, 1, 16368, 16384, 8, 22, 22, 35}, {234533, "", 640, 960, 656, 960, 16, 1, 16368, 16384, 8, 22, 11, 35}, {234564, "", 320, 480, 328, 480, 16, 1, 16368, 16384, 8, 44, 22, 70}, {234565, "", 320, 960, 328, 960, 16, 1, 16368, 16384, 8, 44, 11, 70}, {234596, "", 640, 480, 656, 480, 16, 1, 16368, 16384, 8, 22, 22, 35}, {234597, "", 640, 960, 656, 960, 16, 1, 16368, 16384, 8, 22, 11, 35}, {235520, "", 320, 240, 328, 240, 16, 1, 16368, 16384, 8, 44, 44, 70}, {235524, "", 320, 480, 328, 480, 16, 1, 16368, 16384, 8, 44, 22, 70}, {235525, "", 320, 960, 328, 960, 16, 1, 16368, 16384, 8, 44, 11, 70}, {235552, "", 640, 240, 656, 240, 16, 1, 16368, 16384, 8, 22, 44, 35}, {235556, "", 640, 480, 656, 480, 16, 1, 16368, 16384, 8, 22, 22, 35}, {235557, "", 640, 960, 656, 960, 16, 1, 16368, 16384, 8, 22, 11, 35}, {397312, "EURO72:ExtraLowRes", 160, 200, 164, 200, 16, 1, 16368, 16384, 8, 88, 44, 140}, {397316, "EURO72:ExtraLowRes", 160, 400, 164, 400, 16, 1, 16368, 16384, 8, 88, 22, 140}, {397317, "EURO72:ExtraLowRes", 160, 800, 164, 800, 16, 1, 16368, 16384, 8, 88, 11, 140}, {397440, "", 160, 200, 164, 200, 16, 1, 16368, 16384, 8, 88, 44, 140}, {397444, "", 160, 400, 164, 400, 16, 1, 16368, 16384, 8, 88, 22, 140}, {397445, "", 160, 800, 164, 800, 16, 1, 16368, 16384, 8, 88, 11, 140}, {398340, "", 160, 400, 164, 400, 16, 1, 16368, 16384, 8, 88, 22, 140}, {398341, "", 160, 800, 164, 800, 16, 1, 16368, 16384, 8, 88, 11, 140}, {398404, "", 160, 400, 164, 400, 16, 1, 16368, 16384, 8, 88, 22, 140}, {398405, "", 160, 800, 164, 800, 16, 1, 16368, 16384, 8, 88, 11, 140}, {399360, "", 160, 200, 164, 200, 16, 1, 16368, 16384, 8, 88, 44, 140}, {399364, "", 160, 400, 164, 400, 16, 1, 16368, 16384, 8, 88, 22, 140}, {399365, "", 160, 800, 164, 800, 16, 1, 16368, 16384, 8, 88, 11, 140}, {430080, "EURO72:LowRes", 320, 200, 328, 200, 16, 1, 16368, 16384, 8, 44, 44, 70}, {430084, "EURO72:LowRes", 320, 400, 328, 400, 16, 1, 16368, 16384, 8, 44, 22, 70}, {430085, "EURO72:LowRes", 320, 800, 328, 800, 16, 1, 16368, 16384, 8, 44, 11, 70}, {430112, "EURO72:Productivity", 640, 200, 656, 200, 16, 1, 16368, 16384, 8, 22, 44, 35}, {430116, "EURO72:Productivity", 640, 400, 656, 400, 16, 1, 16368, 16384, 8, 22, 22, 35}, {430117, "EURO72:Productivity Interl.", 640, 800, 656, 800, 16, 1, 16368, 16384, 8, 22, 11, 35}, {430208, "", 320, 200, 328, 200, 16, 1, 16368, 16384, 8, 44, 44, 70}, {430212, "", 320, 400, 328, 400, 16, 1, 16368, 16384, 8, 44, 22, 70}, {430213, "", 320, 800, 328, 800, 16, 1, 16368, 16384, 8, 44, 11, 70}, {430240, "", 640, 200, 656, 200, 16, 1, 16368, 16384, 8, 22, 44, 35}, {430244, "", 640, 400, 656, 400, 16, 1, 16368, 16384, 8, 22, 22, 35}, {430245, "", 640, 800, 656, 800, 16, 1, 16368, 16384, 8, 22, 11, 35}, {431108, "", 320, 400, 328, 400, 16, 1, 16368, 16384, 8, 44, 22, 70}, {431109, "", 320, 800, 328, 800, 16, 1, 16368, 16384, 8, 44, 11, 70}, {431140, "", 640, 400, 656, 400, 16, 1, 16368, 16384, 8, 22, 22, 35}, {431141, "", 640, 800, 656, 800, 16, 1, 16368, 16384, 8, 22, 11, 35}, {431172, "", 320, 400, 328, 400, 16, 1, 16368, 16384, 8, 44, 22, 70}, {431173, "", 320, 800, 328, 800, 16, 1, 16368, 16384, 8, 44, 11, 70}, {431204, "", 640, 400, 656, 400, 16, 1, 16368, 16384, 8, 22, 22, 35}, {431205, "", 640, 800, 656, 800, 16, 1, 16368, 16384, 8, 22, 11, 35}, {432128, "", 320, 200, 328, 200, 16, 1, 16368, 16384, 8, 44, 44, 70}, {432132, "", 320, 400, 328, 400, 16, 1, 16368, 16384, 8, 44, 22, 70}, {432133, "", 320, 800, 328, 800, 16, 1, 16368, 16384, 8, 44, 11, 70}, {432160, "", 640, 200, 656, 200, 16, 1, 16368, 16384, 8, 22, 44, 35}, {432164, "", 640, 400, 656, 400, 16, 1, 16368, 16384, 8, 22, 22, 35}, {432165, "", 640, 800, 656, 800, 16, 1, 16368, 16384, 8, 22, 11, 35}, {462848, "EURO36:LowRes", 320, 200, 362, 200, 16, 1, 16368, 16384, 8, 44, 44, 140}, {462852, "EURO36:LowRes Interlace", 320, 400, 362, 400, 16, 1, 16368, 16384, 8, 44, 22, 140}, {462976, "", 320, 200, 362, 200, 16, 1, 16368, 16384, 8, 44, 44, 140}, {462980, "", 320, 400, 362, 400, 16, 1, 16368, 16384, 8, 44, 22, 140}, {463872, "", 320, 200, 362, 200, 16, 1, 16368, 16384, 8, 44, 44, 140}, {463876, "", 320, 400, 362, 400, 16, 1, 16368, 16384, 8, 44, 22, 140}, {463936, "", 320, 200, 362, 200, 16, 1, 16368, 16384, 8, 44, 44, 140}, {463940, "", 320, 400, 362, 400, 16, 1, 16368, 16384, 8, 44, 22, 140}, {464896, "", 320, 200, 362, 200, 16, 1, 16368, 16384, 8, 44, 44, 140}, {464900, "", 320, 400, 362, 400, 16, 1, 16368, 16384, 8, 44, 22, 140}, {495616, "EURO36:HighRes", 640, 200, 724, 200, 16, 1, 16368, 16384, 8, 22, 44, 70}, {495620, "EURO36:HighRes Interlace", 640, 400, 724, 400, 16, 1, 16368, 16384, 8, 22, 22, 70}, {495648, "EURO36:SuperHighRes", 1280, 200, 1448, 200, 16, 1, 16368, 16384, 8, 11, 44, 35}, {495652, "EURO36:SuperHighRes Interl.", 1280, 400, 1448, 400, 16, 1, 16368, 16384, 8, 11, 22, 35}, {495744, "", 640, 200, 724, 200, 16, 1, 16368, 16384, 8, 22, 44, 70}, {495748, "", 640, 400, 724, 400, 16, 1, 16368, 16384, 8, 22, 22, 70}, {495776, "", 1280, 200, 1448, 200, 16, 1, 16368, 16384, 8, 11, 44, 35}, {495780, "", 1280, 400, 1448, 400, 16, 1, 16368, 16384, 8, 11, 22, 35}, {496640, "", 640, 200, 724, 200, 16, 1, 16368, 16384, 8, 22, 44, 70}, {496644, "", 640, 400, 724, 400, 16, 1, 16368, 16384, 8, 22, 22, 70}, {496672, "", 1280, 200, 1448, 200, 16, 1, 16368, 16384, 8, 11, 44, 35}, {496676, "", 1280, 400, 1448, 400, 16, 1, 16368, 16384, 8, 11, 22, 35}, {496704, "", 640, 200, 724, 200, 16, 1, 16368, 16384, 8, 22, 44, 70}, {496708, "", 640, 400, 724, 400, 16, 1, 16368, 16384, 8, 22, 22, 70}, {496736, "", 1280, 200, 1448, 200, 16, 1, 16368, 16384, 8, 11, 44, 35}, {496740, "", 1280, 400, 1448, 400, 16, 1, 16368, 16384, 8, 11, 22, 35}, {497664, "", 640, 200, 724, 200, 16, 1, 16368, 16384, 8, 22, 44, 70}, {497668, "", 640, 400, 724, 400, 16, 1, 16368, 16384, 8, 22, 22, 70}, {497696, "", 1280, 200, 1448, 200, 16, 1, 16368, 16384, 8, 11, 44, 35}, {497700, "", 1280, 400, 1448, 400, 16, 1, 16368, 16384, 8, 11, 22, 35}, {528384, "SUPER72:LowRes", 200, 300, 228, 306, 16, 1, 16368, 16384, 8, 68, 40, 140}, {528388, "SUPER72:LowRes Interlace", 200, 600, 228, 612, 16, 1, 16368, 16384, 8, 68, 20, 140}, {528392, "SUPER72:LowRes", 200, 150, 228, 153, 16, 1, 16368, 16384, 8, 68, 80, 140}, {528512, "", 200, 300, 228, 306, 16, 1, 16368, 16384, 8, 68, 40, 140}, {528516, "", 200, 600, 228, 612, 16, 1, 16368, 16384, 8, 68, 20, 140}, {528520, "", 200, 150, 228, 153, 16, 1, 16368, 16384, 8, 68, 80, 140}, {529408, "", 200, 300, 228, 306, 16, 1, 16368, 16384, 8, 68, 40, 140}, {529412, "", 200, 600, 228, 612, 16, 1, 16368, 16384, 8, 68, 20, 140}, {529472, "", 200, 300, 228, 306, 16, 1, 16368, 16384, 8, 68, 40, 140}, {529476, "", 200, 600, 228, 612, 16, 1, 16368, 16384, 8, 68, 20, 140}, {530432, "", 200, 300, 228, 306, 16, 1, 16368, 16384, 8, 68, 40, 140}, {530436, "", 200, 600, 228, 612, 16, 1, 16368, 16384, 8, 68, 20, 140}, {530440, "", 200, 150, 228, 153, 16, 1, 16368, 16384, 8, 68, 80, 140}, {561152, "SUPER72:HighRes", 400, 300, 456, 306, 16, 1, 16368, 16384, 8, 34, 40, 70}, {561156, "SUPER72:HighRes Interlace", 400, 600, 456, 612, 16, 1, 16368, 16384, 8, 34, 20, 70}, {561160, "SUPER72:HighRes", 400, 150, 456, 153, 16, 1, 16368, 16384, 8, 34, 80, 70}, {561184, "SUPER72:SuperHighRes", 800, 300, 912, 306, 16, 1, 16368, 16384, 8, 17, 40, 35}, {561188, "SUPER72:SuperHighRes Interlace", 800, 600, 912, 612, 16, 1, 16368, 16384, 8, 17, 20, 35}, {561192, "SUPER72:HighRes", 800, 150, 912, 153, 16, 1, 16368, 16384, 8, 17, 80, 35}, {561280, "", 400, 300, 456, 306, 16, 1, 16368, 16384, 8, 34, 40, 70}, {561284, "", 400, 600, 456, 612, 16, 1, 16368, 16384, 8, 34, 20, 70}, {561288, "", 400, 150, 456, 153, 16, 1, 16368, 16384, 8, 34, 80, 70}, {561312, "", 800, 300, 912, 306, 16, 1, 16368, 16384, 8, 17, 40, 35}, {561316, "", 800, 600, 912, 612, 16, 1, 16368, 16384, 8, 17, 20, 35}, {561320, "", 800, 150, 912, 153, 16, 1, 16368, 16384, 8, 17, 80, 35}, {562176, "", 400, 300, 456, 306, 16, 1, 16368, 16384, 8, 34, 40, 70}, {562180, "", 400, 600, 456, 612, 16, 1, 16368, 16384, 8, 34, 20, 70}, {562208, "", 800, 300, 912, 306, 16, 1, 16368, 16384, 8, 17, 40, 35}, {562212, "", 800, 600, 912, 612, 16, 1, 16368, 16384, 8, 17, 20, 35}, {562240, "", 400, 300, 456, 306, 16, 1, 16368, 16384, 8, 34, 40, 70}, {562244, "", 400, 600, 456, 612, 16, 1, 16368, 16384, 8, 34, 20, 70}, {562272, "", 800, 300, 912, 306, 16, 1, 16368, 16384, 8, 17, 40, 35}, {562276, "", 800, 600, 912, 612, 16, 1, 16368, 16384, 8, 17, 20, 35}, {563200, "", 400, 300, 456, 306, 16, 1, 16368, 16384, 8, 34, 40, 70}, {563204, "", 400, 600, 456, 612, 16, 1, 16368, 16384, 8, 34, 20, 70}, {563208, "", 400, 150, 456, 153, 16, 1, 16368, 16384, 8, 34, 80, 70}, {563232, "", 800, 300, 912, 306, 16, 1, 16368, 16384, 8, 17, 40, 35}, {563236, "", 800, 600, 912, 612, 16, 1, 16368, 16384, 8, 17, 20, 35}, {563240, "", 800, 150, 912, 153, 16, 1, 16368, 16384, 8, 17, 80, 35}, {593920, "DBLNTSC:LowRes", 320, 200, 360, 227, 16, 1, 16368, 16384, 8, 44, 52, 70}, {593924, "DBLNTSC:LowRes Flickerfree", 320, 400, 360, 454, 16, 1, 16368, 16384, 8, 44, 26, 70}, {593925, "DBLNTSC:LowRes Interlace", 320, 800, 360, 908, 16, 1, 16368, 16384, 8, 44, 13, 70}, {594048, "", 320, 200, 360, 227, 16, 1, 16368, 16384, 8, 44, 52, 70}, {594052, "", 320, 400, 360, 454, 16, 1, 16368, 16384, 8, 44, 26, 70}, {594053, "", 320, 800, 360, 908, 16, 1, 16368, 16384, 8, 44, 13, 70}, {594432, "DBLNTSC:ExtraLowRes", 160, 200, 180, 227, 16, 1, 16368, 16384, 8, 88, 52, 140}, {594436, "DBLNTSC:ExtraLowRes", 160, 400, 180, 454, 16, 1, 16368, 16384, 8, 88, 26, 140}, {594437, "DBLNTSC:ExtraLowRes", 160, 800, 180, 908, 16, 1, 16368, 16384, 8, 88, 13, 140}, {594560, "", 160, 200, 180, 227, 16, 1, 16368, 16384, 8, 88, 52, 140}, {594564, "", 160, 400, 180, 454, 16, 1, 16368, 16384, 8, 88, 26, 140}, {594565, "", 160, 800, 180, 908, 16, 1, 16368, 16384, 8, 88, 13, 140}, {594944, "", 320, 400, 360, 454, 16, 1, 16368, 16384, 8, 44, 26, 70}, {594948, "", 320, 400, 360, 454, 16, 1, 16368, 16384, 8, 44, 26, 70}, {594949, "", 320, 800, 360, 908, 16, 1, 16368, 16384, 8, 44, 13, 70}, {595008, "", 320, 400, 360, 454, 16, 1, 16368, 16384, 8, 44, 26, 70}, {595012, "", 320, 400, 360, 454, 16, 1, 16368, 16384, 8, 44, 26, 70}, {595013, "", 320, 800, 360, 908, 16, 1, 16368, 16384, 8, 44, 13, 70}, {595456, "", 160, 400, 180, 454, 16, 1, 16368, 16384, 8, 88, 26, 140}, {595460, "", 160, 400, 180, 454, 16, 1, 16368, 16384, 8, 88, 26, 140}, {595461, "", 160, 800, 180, 908, 16, 1, 16368, 16384, 8, 88, 13, 140}, {595520, "", 160, 400, 180, 454, 16, 1, 16368, 16384, 8, 88, 26, 140}, {595524, "", 160, 400, 180, 454, 16, 1, 16368, 16384, 8, 88, 26, 140}, {595525, "", 160, 800, 180, 908, 16, 1, 16368, 16384, 8, 88, 13, 140}, {595968, "", 320, 200, 360, 227, 16, 1, 16368, 16384, 8, 44, 52, 70}, {595972, "", 320, 400, 360, 454, 16, 1, 16368, 16384, 8, 44, 26, 70}, {595973, "", 320, 800, 360, 908, 16, 1, 16368, 16384, 8, 44, 13, 70}, {596480, "", 160, 200, 180, 227, 16, 1, 16368, 16384, 8, 88, 52, 140}, {596484, "", 160, 400, 180, 454, 16, 1, 16368, 16384, 8, 88, 26, 140}, {596485, "", 160, 800, 180, 908, 16, 1, 16368, 16384, 8, 88, 13, 140}, {626688, "DBLNTSC:HighRes", 640, 200, 720, 227, 16, 1, 16368, 16384, 8, 22, 52, 35}, {626692, "DBLNTSC:HighRes Flickerfree", 640, 400, 720, 454, 16, 1, 16368, 16384, 8, 22, 26, 35}, {626693, "DBLNTSC:HighRes Interlace", 640, 800, 720, 908, 16, 1, 16368, 16384, 8, 22, 13, 35}, {626816, "", 640, 200, 720, 227, 16, 1, 16368, 16384, 8, 22, 52, 35}, {626820, "", 640, 400, 720, 454, 16, 1, 16368, 16384, 8, 22, 26, 35}, {626821, "", 640, 800, 720, 908, 16, 1, 16368, 16384, 8, 22, 13, 35}, {627712, "", 640, 400, 720, 454, 16, 1, 16368, 16384, 8, 22, 26, 35}, {627716, "", 640, 400, 720, 454, 16, 1, 16368, 16384, 8, 22, 26, 35}, {627717, "", 640, 800, 720, 908, 16, 1, 16368, 16384, 8, 22, 13, 35}, {627776, "", 640, 400, 720, 454, 16, 1, 16368, 16384, 8, 22, 26, 35}, {627780, "", 640, 400, 720, 454, 16, 1, 16368, 16384, 8, 22, 26, 35}, {627781, "", 640, 800, 720, 908, 16, 1, 16368, 16384, 8, 22, 13, 35}, {628736, "", 640, 200, 720, 227, 16, 1, 16368, 16384, 8, 22, 52, 35}, {628740, "", 640, 400, 720, 454, 16, 1, 16368, 16384, 8, 22, 26, 35}, {628741, "", 640, 800, 720, 908, 16, 1, 16368, 16384, 8, 22, 13, 35}, {659456, "DBLPAL:LowRes", 320, 256, 360, 275, 16, 1, 16368, 16384, 8, 44, 44, 70}, {659460, "DBLPAL:LowRes Flickerfree", 320, 512, 360, 550, 16, 1, 16368, 16384, 8, 44, 22, 70}, {659461, "DBLPAL:LowRes Interlace", 320, 1024, 360, 1100, 16, 1, 16368, 16384, 8, 44, 11, 70}, {659584, "", 320, 256, 360, 275, 16, 1, 16368, 16384, 8, 44, 44, 70}, {659588, "", 320, 512, 360, 550, 16, 1, 16368, 16384, 8, 44, 22, 70}, {659589, "", 320, 1024, 360, 1100, 16, 1, 16368, 16384, 8, 44, 11, 70}, {659968, "DBLPAL:ExtraLowRes", 160, 256, 180, 275, 16, 1, 16368, 16384, 8, 88, 44, 140}, {659972, "DBLPAL:ExtraLowRes", 160, 512, 180, 550, 16, 1, 16368, 16384, 8, 88, 22, 140}, {659973, "DBLPAL:ExtraLowRes", 160, 1024, 180, 1100, 16, 1, 16368, 16384, 8, 88, 11, 140}, {660096, "", 160, 256, 180, 275, 16, 1, 16368, 16384, 8, 88, 44, 140}, {660100, "", 160, 512, 180, 550, 16, 1, 16368, 16384, 8, 88, 22, 140}, {660101, "", 160, 1024, 180, 1100, 16, 1, 16368, 16384, 8, 88, 11, 140}, {660480, "", 320, 512, 360, 550, 16, 1, 16368, 16384, 8, 44, 22, 70}, {660484, "", 320, 512, 360, 550, 16, 1, 16368, 16384, 8, 44, 22, 70}, {660485, "", 320, 1024, 360, 1100, 16, 1, 16368, 16384, 8, 44, 11, 70}, {660544, "", 320, 512, 360, 550, 16, 1, 16368, 16384, 8, 44, 22, 70}, {660548, "", 320, 512, 360, 550, 16, 1, 16368, 16384, 8, 44, 22, 70}, {660549, "", 320, 1024, 360, 1100, 16, 1, 16368, 16384, 8, 44, 11, 70}, {660992, "", 160, 512, 180, 550, 16, 1, 16368, 16384, 8, 88, 22, 140}, {660996, "", 160, 512, 180, 550, 16, 1, 16368, 16384, 8, 88, 22, 140}, {660997, "", 160, 1024, 180, 1100, 16, 1, 16368, 16384, 8, 88, 11, 140}, {661056, "", 160, 512, 180, 550, 16, 1, 16368, 16384, 8, 88, 22, 140}, {661060, "", 160, 512, 180, 550, 16, 1, 16368, 16384, 8, 88, 22, 140}, {661061, "", 160, 1024, 180, 1100, 16, 1, 16368, 16384, 8, 88, 11, 140}, {661504, "", 320, 256, 360, 275, 16, 1, 16368, 16384, 8, 44, 44, 70}, {661508, "", 320, 512, 360, 550, 16, 1, 16368, 16384, 8, 44, 22, 70}, {661509, "", 320, 1024, 360, 1100, 16, 1, 16368, 16384, 8, 44, 11, 70}, {662016, "", 160, 256, 180, 275, 16, 1, 16368, 16384, 8, 88, 44, 140}, {662020, "", 160, 512, 180, 550, 16, 1, 16368, 16384, 8, 88, 22, 140}, {662021, "", 160, 1024, 180, 1100, 16, 1, 16368, 16384, 8, 88, 11, 140}, {692224, "DBLPAL:HighRes", 640, 256, 720, 275, 16, 1, 16368, 16384, 8, 22, 44, 35}, {692228, "DBLPAL:HighRes Flickerfree", 640, 512, 720, 550, 16, 1, 16368, 16384, 8, 22, 22, 35}, {692229, "DBLPAL:HighRes Interlace", 640, 1024, 720, 1100, 16, 1, 16368, 16384, 8, 22, 11, 35}, {692352, "", 640, 256, 720, 275, 16, 1, 16368, 16384, 8, 22, 44, 35}, {692356, "", 640, 512, 720, 550, 16, 1, 16368, 16384, 8, 22, 22, 35}, {692357, "", 640, 1024, 720, 1100, 16, 1, 16368, 16384, 8, 22, 11, 35}, {693248, "", 640, 512, 720, 550, 16, 1, 16368, 16384, 8, 22, 22, 35}, {693252, "", 640, 512, 720, 550, 16, 1, 16368, 16384, 8, 22, 22, 35}, {693253, "", 640, 1024, 720, 1100, 16, 1, 16368, 16384, 8, 22, 11, 35}, {693312, "", 640, 512, 720, 550, 16, 1, 16368, 16384, 8, 22, 22, 35}, {693316, "", 640, 512, 720, 550, 16, 1, 16368, 16384, 8, 22, 22, 35}, {693317, "", 640, 1024, 720, 1100, 16, 1, 16368, 16384, 8, 22, 11, 35}, {694272, "", 640, 256, 720, 275, 16, 1, 16368, 16384, 8, 22, 44, 35}, {694276, "", 640, 512, 720, 550, 16, 1, 16368, 16384, 8, 22, 22, 35}, {694277, "", 640, 1024, 720, 1100, 16, 1, 16368, 16384, 8, 22, 11, 35}};
    }

    private static class MonitorItem {
        String name;
        int fps;

        public MonitorItem(String name, int fps) {
            this.name = name;
            this.fps = fps;
        }
    }
}

