/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.amigabitmap.codec.video;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.monte.media.amigabitmap.AmigaBitmapImage;
import org.monte.media.amigabitmap.AmigaBitmapImageFactory;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKey;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.codec.video.AbstractVideoCodec;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.iff.IFFVisitor;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.ilbm.ILBMDecoder;
import org.monte.media.pbm.PBMDecoder;

public class AmigaBitmapCodec
extends AbstractVideoCodec {
    public AmigaBitmapCodec() {
        super(new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "ILBM", VideoFormatKeys.DataClassKey, AmigaBitmapImage.class})}, new Format[]{new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "ILBM", VideoFormatKeys.DataClassKey, AmigaBitmapImage.class})});
    }

    public Format setOutputFormat(Format f) {
        super.setOutputFormat(f);
        if (this.outputFormat != null && this.inputFormat != null) {
            this.outputFormat = this.outputFormat.prepend(this.inputFormat.intersectKeys(new FormatKey[]{VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey, VideoFormatKeys.DepthKey}));
        }
        return this.outputFormat;
    }

    public int process(Buffer in, Buffer out) {
        if (this.outputFormat.get(FormatKeys.EncodingKey) == "ILBM") {
            return this.encodeToBitmapImage(in, out);
        }
        if (this.outputFormat.get(FormatKeys.EncodingKey) == "image") {
            return this.encodeToBufferedImage(in, out);
        }
        out.setFlag(BufferFlag.DISCARD);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int encodeToBitmapImage(Buffer in, Buffer out) {
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.format = this.outputFormat;
        try {
            out.setFlag(BufferFlag.KEYFRAME);
            if (in.data instanceof File) {
                boolean success;
                ArrayList<Object> imgs;
                IFFVisitor d;
                File f = (File)in.data;
                try (BufferedInputStream ins = new BufferedInputStream(new FileInputStream(f));){
                    d = new ILBMDecoder(ins);
                    imgs = ((ILBMDecoder)d).produceBitmaps();
                    AmigaBitmapImage img = imgs.get(0);
                    out.data = img;
                    success = true;
                }
                if (!success) {
                    ins = new BufferedInputStream(new FileInputStream(f));
                    try {
                        d = new PBMDecoder(ins);
                        imgs = ((PBMDecoder)d).produce();
                        ColorCyclingMemoryImageSource mis = (ColorCyclingMemoryImageSource)imgs.get(0);
                        out.data = AmigaBitmapImageFactory.toBitmapImage(mis);
                        success = true;
                    }
                    catch (IOException e) {
                        success = false;
                    }
                    finally {
                        ((InputStream)ins).close();
                    }
                }
                if (!success) {
                    BufferedImage img = ImageIO.read(f);
                    out.data = AmigaBitmapImageFactory.toBitmapImage(img);
                    success = true;
                }
            } else if (in.data instanceof AmigaBitmapImage) {
                out.data = in.data;
            } else if (in.data instanceof BufferedImage) {
                out.data = AmigaBitmapImageFactory.toBitmapImage((BufferedImage)in.data);
            }
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int encodeToBufferedImage(Buffer in, Buffer out) {
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.format = this.outputFormat;
        try {
            out.setFlag(BufferFlag.KEYFRAME);
            if (in.data instanceof File) {
                boolean success;
                ArrayList<Object> imgs;
                IFFVisitor d;
                File f = (File)in.data;
                try (BufferedInputStream ins = new BufferedInputStream(new FileInputStream(f));){
                    d = new ILBMDecoder(ins);
                    imgs = ((ILBMDecoder)d).produceBitmaps();
                    AmigaBitmapImage img = imgs.get(0);
                    out.data = AmigaBitmapImageFactory.toBufferedImage(img);
                    success = true;
                }
                if (!success) {
                    ins = new BufferedInputStream(new FileInputStream(f));
                    try {
                        d = new PBMDecoder(ins);
                        imgs = ((PBMDecoder)d).produce();
                        ColorCyclingMemoryImageSource mis = (ColorCyclingMemoryImageSource)imgs.get(0);
                        out.data = AmigaBitmapImageFactory.toBufferedImage(AmigaBitmapImageFactory.toBitmapImage(mis));
                        success = true;
                    }
                    catch (IOException e) {
                        success = false;
                    }
                    finally {
                        ((InputStream)ins).close();
                    }
                }
                if (!success) {
                    BufferedImage img = ImageIO.read(f);
                    out.data = img;
                    success = true;
                }
            } else if (in.data instanceof AmigaBitmapImage) {
                out.data = AmigaBitmapImageFactory.toBufferedImage((AmigaBitmapImage)in.data);
            } else if (in.data instanceof BufferedImage) {
                out.data = in.data;
            }
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }
}

