/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import org.monte.media.amigabitmap.AmigaBitmapImage;
import org.monte.media.anim.ANIMFrame;
import org.monte.media.anim.ANIMMovieResources;
import org.monte.media.exception.ParseException;
import org.monte.media.iff.IFFParser;

public class ANIMKeyFrame
extends ANIMFrame {
    private int compression;
    protected static final int VDAT_ID = IFFParser.stringToID("VDAT");

    @Override
    public void setData(byte[] data) {
        this.data = data;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    @Override
    public void decode(AmigaBitmapImage bitmap, ANIMMovieResources track) {
        switch (this.compression) {
            case 1: {
                ANIMKeyFrame.unpackByteRun1(this.data, bitmap.getBitmap());
                break;
            }
            case 2: {
                this.unpackVertical(this.data, bitmap);
                break;
            }
            default: {
                System.arraycopy(this.data, 0, bitmap.getBitmap(), 0, this.data.length);
            }
        }
    }

    public static int unpackByteRun1(byte[] in, byte[] out) {
        int iOut = 0;
        int iIn = 0;
        int n = 0;
        try {
            while (iOut < out.length) {
                if ((n = in[iIn++]) >= 0) {
                    System.arraycopy(in, iIn, out, iOut, ++n);
                    iOut += n;
                    iIn += n;
                    continue;
                }
                if (n == -128) continue;
                byte copyByte = in[iIn++];
                while (n < 1) {
                    out[iOut++] = copyByte;
                    ++n;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("ANIMKeyFrame.unpackByteRun1(): " + String.valueOf(e));
            System.out.println("  Plane-Index: " + iOut + " Plane size:" + out.length);
            System.out.println("  Buffer-Index: " + iIn + " Buffer size:" + in.length);
            System.out.println("  Command: " + n);
        }
        return iOut;
    }

    /*
     * Unable to fully structure code
     */
    public void unpackVertical(byte[] in, AmigaBitmapImage bm) {
        out = bm.getBitmap();
        iIn = 0;
        endOfData = 0;
        bmhdWidth = bm.getWidth();
        bmhdHeight = bm.getHeight();
        bmhdNbPlanes = bm.getDepth();
        buf = new byte[bmhdWidth * bmhdHeight / 8];
        scanlineStride = bm.getScanlineStride();
        columnCount = bmhdWidth / 8 * bmhdHeight;
        columnStride = bmhdHeight * 2;
        try {
            for (p = 0; p < bmhdNbPlanes; ++p) {
                iBuf = 0;
                iIn = endOfData;
                if ((id = (in[iIn++] & 255) << 24 | (in[iIn++] & 255) << 16 | (in[iIn++] & 255) << 8 | in[iIn++] & 255) != ANIMKeyFrame.VDAT_ID) {
                    throw new ParseException("Illegal VDAT chunk ID:" + IFFParser.idToString(id) + " at " + (iIn - 4));
                }
                if ((long)iIn + (length = ((long)in[iIn++] & 255L) << 24 | ((long)in[iIn++] & 255L) << 16 | ((long)in[iIn++] & 255L) << 8 | (long)in[iIn++] & 255L) > (long)in.length) {
                    throw new ParseException("Illegal VDAT chunk length:" + length + " at " + (iIn - 4));
                }
                endOfData = (int)((long)endOfData + (length + 8L));
                cnt = (in[iIn++] & 255) << 8 | in[iIn++] & 255;
                iCmd = iIn;
                iIn = iIn + cnt - 2;
lbl23:
                // 5 sources

                try {
                    for (i = cnt - 2; i > 0 && iIn < endOfData; --i) {
                        block17: {
                            block16: {
                                block15: {
                                    if ((cmd = in[iCmd++]) != 0) break block15;
                                    n = (in[iIn++] & 255) << 8 | in[iIn++] & 255;
                                    n *= 2;
                                    while (n > 0) {
                                        buf[iBuf++] = in[iIn++];
                                        --n;
                                    }
                                    ** GOTO lbl23
                                }
                                if (cmd != 1) break block16;
                                n = (in[iIn++] & 255) << 8 | in[iIn++] & 255;
                                dhigh = in[iIn++];
                                dlow = in[iIn++];
                                while (n > 0) {
                                    buf[iBuf++] = dhigh;
                                    buf[iBuf++] = dlow;
                                    --n;
                                }
                                ** GOTO lbl23
                            }
                            if (cmd < 2) break block17;
                            dhigh = in[iIn++];
                            dlow = in[iIn++];
                            for (n = cmd; n > 0; --n) {
                                buf[iBuf++] = dhigh;
                                buf[iBuf++] = dlow;
                            }
                            ** GOTO lbl23
                        }
                        for (n = cmd * -2; n > 0; --n) {
                            buf[iBuf++] = in[iIn++];
                        }
                        ** GOTO lbl23
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.println("IndexOutOfBounds in bitplane " + p);
                    e.printStackTrace();
                }
                bitplaneOffset = bm.getBitplaneStride() * p;
                xBuf = 0;
                xOut = 0;
                while (xBuf < columnCount) {
                    yBuf = 0;
                    yOut = bitplaneOffset;
                    while (yBuf < columnStride) {
                        out[xOut + yOut] = buf[xBuf + yBuf];
                        out[xOut + 1 + yOut] = buf[xBuf + 1 + yBuf];
                        yBuf += 2;
                        yOut += scanlineStride;
                    }
                    xBuf += columnStride;
                    xOut += 2;
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }
}

