/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.amigabitmap.AmigaBitmapImage;
import org.monte.media.anim.ANIMOutputStream;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.Multiplexer;
import org.monte.media.math.Rational;

public class ANIMMultiplexer
implements Multiplexer {
    private final ANIMOutputStream out;
    protected Rational inputTime;

    public ANIMMultiplexer(File file) throws IOException {
        this.out = new ANIMOutputStream(file);
    }

    public ANIMMultiplexer(ImageOutputStream out) throws IOException {
        this.out = new ANIMOutputStream(out);
    }

    public int addTrack(Format fmt) throws IOException {
        return 0;
    }

    public void write(int trackIndex, Buffer buf) throws IOException {
        if (!buf.isFlag(BufferFlag.DISCARD)) {
            long jiffies = this.out.getJiffies();
            if (this.inputTime == null) {
                this.inputTime = new Rational(0L, 1L);
            }
            this.inputTime = this.inputTime.add(buf.sampleDuration.multiply((long)buf.sampleCount));
            Rational outputTime = new Rational(this.out.getMovieTime(), jiffies);
            Rational outputDuration = this.inputTime.subtract(outputTime);
            outputDuration = outputDuration.round(jiffies);
            int outputMediaDuration = Math.max(1, (int)(outputDuration.getNumerator() * jiffies / outputDuration.getDenominator()));
            outputTime = outputTime.add(new Rational((long)outputMediaDuration, jiffies));
            this.out.writeFrame((AmigaBitmapImage)buf.data, outputMediaDuration);
        }
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void setCAMG(int newValue) {
        this.out.setCAMG(newValue);
    }
}

