/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.util.Map;
import java.util.TreeMap;
import org.monte.media.amigabitmap.AmigaBitmapImage;
import org.monte.media.anim.ANIMDemultiplexer;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.Track;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.math.Rational;

public class ANIMVideoTrack
implements Track {
    private ANIMDemultiplexer demux;
    private long jiffyPosition;
    private Format format = null;
    private long jiffyCount = 0L;
    private TreeMap<Long, Integer> jiffiesToFrameMap = new TreeMap();
    private boolean hasColorCycling;

    public ANIMVideoTrack(ANIMDemultiplexer demux) {
        this.demux = demux;
        this.jiffyCount = 0L;
        int n = demux.getFrameCount();
        for (int i = 0; i < n; ++i) {
            this.jiffiesToFrameMap.put(this.jiffyCount, i);
            this.jiffyCount += (long)demux.getDuration(i);
        }
        this.hasColorCycling = demux.getColorCyclesCount() > 0;
    }

    public long getSampleCount() {
        return this.demux.getFrameCount();
    }

    public void setPosition(long pos) {
        this.jiffyPosition = pos;
    }

    public long getPosition() {
        return this.jiffyPosition;
    }

    public void read(Buffer buf) {
        if (this.jiffyPosition < this.jiffyCount) {
            Map.Entry<Long, Integer> entry = this.jiffiesToFrameMap.floorEntry(this.jiffyPosition);
            Long framePositionInJiffies = entry.getKey();
            int frameIndex = entry.getValue();
            buf.setFlagsTo(new BufferFlag[]{BufferFlag.KEYFRAME});
            if (!(buf.data instanceof AmigaBitmapImage)) {
                buf.data = this.demux.createCompatibleBitmap();
            }
            this.demux.readFrame(frameIndex, (AmigaBitmapImage)buf.data);
            int duration = this.hasColorCycling ? 1 : (int)(framePositionInJiffies + (long)this.demux.getDuration(frameIndex) - this.jiffyPosition);
            buf.sampleDuration = new Rational((long)duration, (long)this.demux.getJiffies());
            buf.format = this.getFormat();
            buf.sampleCount = 1;
            buf.timeStamp = new Rational(this.jiffyPosition, (long)this.demux.getJiffies());
            this.jiffyPosition += (long)duration;
        } else {
            buf.setFlagsTo(new BufferFlag[]{BufferFlag.DISCARD, BufferFlag.END_OF_MEDIA});
        }
    }

    public Format getFormat() {
        if (this.format == null) {
            int depth = switch (this.demux.getResources().getScreenMode()) {
                case 0, 2 -> 8;
                default -> 24;
            };
            int jiffies = this.demux.getJiffies();
            this.format = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "tscc", VideoFormatKeys.DepthKey, depth, VideoFormatKeys.WidthKey, this.demux.getWidth(), VideoFormatKeys.HeightKey, this.demux.getHeight(), FormatKeys.FrameRateKey, new Rational((long)jiffies, 1L)});
        }
        return this.format;
    }
}

